/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.services.bean;

import org.chorem.pollen.persistence.PollenEntity;
import org.chorem.pollen.persistence.entity.Choice;
import org.chorem.pollen.persistence.entity.Comment;
import org.chorem.pollen.persistence.entity.Poll;
import org.chorem.pollen.persistence.entity.PollenToken;
import org.chorem.pollen.persistence.entity.PollenUser;
import org.chorem.pollen.persistence.entity.SessionToken;
import org.chorem.pollen.persistence.entity.Vote;
import org.chorem.pollen.services.bean.PollenEntityId;

public class PollenEntityRef<E extends PollenEntity>
extends PollenEntityId<E> {
    protected String permission;

    public static PollenEntityRef<Poll> of(Poll entity) {
        return PollenEntityRef.of(entity, entity.getCreator().getPermission());
    }

    public static PollenEntityRef<Choice> of(Choice entity) {
        return PollenEntityRef.of(entity, entity.getCreator().getPermission());
    }

    public static PollenEntityRef<Comment> of(Comment entity) {
        return PollenEntityRef.of(entity, entity.getAuthor().getPermission());
    }

    public static PollenEntityRef<Vote> of(Vote entity) {
        return PollenEntityRef.of(entity, entity.getVoter().getPermission());
    }

    public static PollenEntityRef<PollenUser> of(SessionToken result) {
        return PollenEntityRef.of(result.getPollenUser(), result.getPollenToken());
    }

    public static <E extends PollenEntity> PollenEntityRef<E> of(E result) {
        return new PollenEntityRef<E>(result, null);
    }

    public static <E extends PollenEntity> PollenEntityRef<E> of(E id, PollenToken permission) {
        return new PollenEntityRef<E>(id, permission == null ? null : permission.getToken());
    }

    public static <E extends PollenEntity> PollenEntityRef<E> newRef(Class<E> entityType) {
        return new PollenEntityRef<E>(entityType);
    }

    protected PollenEntityRef(E entity, String permission) {
        this(entity.getClass());
        this.setEntityId(entity.getTopiaId());
        this.setPermission(permission);
    }

    protected PollenEntityRef(Class<E> entityType) {
        super(entityType);
    }

    public String getPermission() {
        return this.permission;
    }

    public void setPermission(String permission) {
        this.permission = permission;
    }
}

