/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.persistence.entity;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.chorem.pollen.persistence.AbstractPollenDao;
import org.chorem.pollen.persistence.entity.PollenPrincipal;
import org.chorem.pollen.persistence.entity.PollenUser;
import org.chorem.pollen.persistence.entity.Question;
import org.chorem.pollen.persistence.entity.Vote;
import org.chorem.pollen.persistence.entity.VoterListMember;
import org.chorem.pollen.persistence.topia.HqlAndParametersBuilder;
import org.chorem.pollen.persistence.topia.query.AddCriteriaOrRunQueryStep;
import org.nuiton.util.pagination.PaginationOrder;

public class VoteDao
extends AbstractPollenDao<Vote> {
    public static final String ANONYMOUS_NAME = "?";

    @Override
    public Class<Vote> getEntityClass() {
        return Vote.class;
    }

    @Override
    public void delete(Vote entity) {
        if (!entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + String.valueOf(entity) + " is not persisted, you can't delete it");
        }
        super.delete(entity);
    }

    public AddCriteriaOrRunQueryStep<Vote> forQuestionEquals(Question v) {
        return this.forEquals("question", v);
    }

    public AddCriteriaOrRunQueryStep<Vote> forVoterEquals(PollenPrincipal v) {
        return this.forEquals("voter", v);
    }

    public AddCriteriaOrRunQueryStep<Vote> forVoter_PollenUserEquals(PollenUser user) {
        return this.forEquals("voter.pollenUser", user);
    }

    @Deprecated
    public AddCriteriaOrRunQueryStep<Vote> forVoterListMemberContains(VoterListMember v) {
        return this.forContains("voterListMember", v);
    }

    public boolean hasVoteForVoterListMember(VoterListMember v) {
        String hql = " FROM " + Vote.class.getName() + " v WHERE :vlm member of v.voterListMember ";
        Map<String, Object> args = Map.of("vlm", v);
        return this.forHql(hql, args).exists();
    }

    public List<Vote> findAllByQuestion(Question question) {
        return this.forQuestionEquals(question).setOrderByArguments("topiaCreateDate").findAll();
    }

    public List<Vote> findAllByQuestionOrdered(Question question, List<PaginationOrder> paginationOrder) {
        return this.forQuestionEquals(question).setOrderByArguments(paginationOrder).findAll();
    }

    public Optional<Vote> findByQuestionAndVoterName(Question question, String name) {
        return this.forProperties("question", question, "voter.name", name).tryFindUnique();
    }

    public AddCriteriaOrRunQueryStep<Vote> forQuestionAndVoter(Question question, PollenPrincipal mainPrincipal) {
        return this.forQuestionEquals(question).addEquals("voter", mainPrincipal);
    }

    public long getVoteIndex(Vote vote) {
        HqlAndParametersBuilder builder = this.newHqlAndParametersBuilder();
        builder.addEquals("question", vote.getQuestion());
        builder.addLowerOrEquals("topiaCreateDate", vote.getTopiaCreateDate());
        builder.setSelectClause("select count(topiaId)");
        return this.count(builder.getHql(), builder.getHqlParameters());
    }

    public List<Vote> findAllOldVotes(Date until) {
        HqlAndParametersBuilder builder = this.newHqlAndParametersBuilder();
        builder.addLowerThan("topiaCreateDate", until);
        builder.addNotNull("voter.pollenUser");
        builder.addNotEquals("voter.pollenUser.name", ANONYMOUS_NAME);
        return this.findAll(builder.getHql(), builder.getHqlParameters());
    }

    public boolean existsByQuestionAndVoter(Question question, PollenPrincipal mainPrincipal) {
        return this.forQuestionEquals(question).addEquals("voter", mainPrincipal).exists();
    }

    public boolean existsByQuestionAndVoter(Question question, PollenUser pollenUser) {
        return this.forQuestionEquals(question).addEquals("voter.pollenUser", pollenUser).exists();
    }
}

