/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.persistence.topia.internal.support;

import com.google.common.hash.Hashing;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlowQueryWatcher
implements AutoCloseable,
Runnable {
    private static final Logger log = LoggerFactory.getLogger(SlowQueryWatcher.class);
    private static final ExecutorService executorService = Executors.newCachedThreadPool();
    protected final long thresholdDelay;
    protected final Supplier<String> descriptionSupplier;
    protected final Supplier<String> callerNameSupplier;
    protected final String threadName;
    protected final String id;
    protected final long begin;
    protected Long end;
    protected boolean warned;

    public static SlowQueryWatcher start(Supplier<String> descriptionSupplier, Supplier<String> callerNameSupplier, long thresholdDelay) {
        if (!log.isWarnEnabled()) {
            return null;
        }
        String threadName = Thread.currentThread().getName();
        SlowQueryWatcher instance = new SlowQueryWatcher(thresholdDelay, descriptionSupplier, threadName, callerNameSupplier);
        executorService.submit(instance);
        return instance;
    }

    public static SlowQueryWatcher start(Supplier<String> descriptionSupplier, long thresholdDelay) {
        if (!log.isWarnEnabled()) {
            return null;
        }
        String threadName = Thread.currentThread().getName();
        Supplier<String> callerNameSupplier = SlowQueryWatcher.newCallerNameSupplier();
        SlowQueryWatcher instance = new SlowQueryWatcher(thresholdDelay, descriptionSupplier, threadName, callerNameSupplier);
        executorService.submit(instance);
        return instance;
    }

    protected static Supplier<String> newCallerNameSupplier() {
        Thread callerThread = Thread.currentThread();
        Function<StackTraceElement, String> formatter = element -> {
            String className = element.getClassName();
            return element.toString().replaceAll(className + ".", "#");
        };
        Predicate<StackTraceElement> callerFinderPredicate = new Predicate<StackTraceElement>(){
            boolean topiaDepthFound = false;

            @Override
            public boolean test(StackTraceElement element) {
                String className = element.getClassName();
                if (!this.topiaDepthFound) {
                    this.topiaDepthFound = className.startsWith("org.nuiton.topia.persistence.internal");
                    return false;
                }
                return !className.startsWith("org.nuiton.topia.persistence.internal") && !className.startsWith("org.hibernate");
            }
        };
        return () -> {
            StackTraceElement[] stackTrace = callerThread.getStackTrace();
            return Arrays.stream(stackTrace).filter(callerFinderPredicate).map(formatter).findFirst().orElse("N/A");
        };
    }

    private SlowQueryWatcher(long thresholdDelay, Supplier<String> description, String threadName, Supplier<String> callerNameSupplier) {
        this.thresholdDelay = thresholdDelay;
        this.descriptionSupplier = description;
        this.threadName = threadName;
        this.callerNameSupplier = callerNameSupplier;
        this.id = Hashing.crc32().hashLong(System.currentTimeMillis()).toString();
        this.begin = System.currentTimeMillis();
        this.end = null;
        this.warned = false;
    }

    public boolean isStillRunning() {
        return this.end == null;
    }

    protected void displayWarn() {
        this.warned = true;
        String description = this.descriptionSupplier.get();
        String callerName = this.callerNameSupplier.get();
        String message = String.format("[w=%s] Unexpected long query (> %dms) from '%s' in thread [%s] : %s", this.id, this.thresholdDelay, callerName, this.threadName, description);
        log.warn(message);
    }

    public void done() {
        this.end = System.currentTimeMillis();
        long duration = this.end - this.begin;
        if (duration > this.thresholdDelay) {
            if (!this.warned) {
                this.displayWarn();
            }
            String message = String.format("[w=%s] Query took %dms", this.id, duration);
            log.warn(message);
        }
    }

    @Override
    public void run() {
        while (this.isStillRunning() && !this.warned) {
            long current = System.currentTimeMillis();
            if (current - this.begin > this.thresholdDelay) {
                this.displayWarn();
            }
            try {
                TimeUnit.MILLISECONDS.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public void close() {
        if (this.isStillRunning()) {
            this.done();
        }
    }
}

