/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.persistence.topia;

import com.google.common.base.Preconditions;
import com.google.common.io.BaseEncoding;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.chorem.pollen.persistence.PollenEntity;

public class TopiaIdFactory {
    public static <E extends PollenEntity> String newTopiaId(Class<E> entityClass) {
        String uuid = UUID.randomUUID().toString();
        String escapedUuid = uuid.replace("-", "").toUpperCase();
        byte[] bytes = BaseEncoding.base16().decode((CharSequence)escapedUuid);
        String randomPart = BaseEncoding.base64Url().encode(bytes);
        randomPart = randomPart.replace("=", "");
        return TopiaIdFactory.newTopiaId(entityClass, randomPart);
    }

    public static <E extends PollenEntity> String newTopiaId(Class<E> entityClass, String randomPart) {
        String simpleName = entityClass.getSimpleName();
        Preconditions.checkArgument((!simpleName.contains(TopiaIdFactory.getSeparator()) ? 1 : 0) != 0, (Object)"Your entity class name must not contains the separator");
        return simpleName + TopiaIdFactory.getSeparator() + randomPart;
    }

    public static String getRandomPart(String topiaId) {
        return StringUtils.substringAfter((String)topiaId, (String)TopiaIdFactory.getSeparator());
    }

    private static String getSeparator() {
        return "_";
    }
}

