/*
 * #%L
 * Lima Swing
 * 
 * $Id: FiscalPeriodsPane.java 3777 2014-04-14 07:29:08Z sbavencoff $
 * $HeadURL: https://svn.chorem.org/lima/tags/lima-0.7.3/lima-swing/src/main/java/org/chorem/lima/ui/home/FiscalPeriodsPane.java $
 * %%
 * Copyright (C) 2008 - 2012 CodeLutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.ui.home;

import static org.nuiton.i18n.I18n.t;

import java.util.List;

import javax.swing.event.HyperlinkEvent;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.LimaContext;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.business.ServiceListener;
import org.chorem.lima.business.api.FiscalPeriodService;
import org.chorem.lima.business.api.ImportService;
import org.chorem.lima.entity.FiscalPeriod;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.MainView;

/**
 * Panenl de la home view de lima qui affiche les statistiques de
 * l'exercice en cours.
 * 
 * @author chatellier
 * @version $Revision: 3777 $
 * 
 * Last update : $Date: 2014-04-14 09:29:08 +0200 (Mon, 14 Apr 2014) $
 * By : $Author: sbavencoff $
 */
public class FiscalPeriodsPane extends AbstractHomePane implements ServiceListener {

    private static final long serialVersionUID = 1L;

    private static final Log log = LogFactory.getLog(FiscalPeriodsPane.class);

    protected FiscalPeriodService fiscalPeriodService;

    /**
     * Constructors (init services).
     * 
     * @param view home view
     */
    public FiscalPeriodsPane(HomeView view) {
        super(view);

        fiscalPeriodService = LimaServiceFactory.getService(FiscalPeriodService.class);
        LimaServiceFactory.addServiceListener(FiscalPeriodService.class, this);
        LimaServiceFactory.addServiceListener(ImportService.class, this);

        refresh();
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (HyperlinkEvent.EventType.ACTIVATED.equals(e.getEventType())) {
            if (e.getDescription().equals("#fiscalperiodschart")) {
                MainView ui = LimaContext.MAIN_UI_ENTRY_DEF.getContextValue(view);
                ui.getHandler().showFiscalPeriodView(ui);
            }
        }
    }

    public void refresh() {

        log.debug("Rafraîchissement fiscal periods pane");
        
        String htmlBegin = "<font face='sans-serif' size=3>"
                           + "<p style=vertical-align:'bottom', horizontal-align:'center'>";
        String htmlEnd = "</p></font>";

        try {

            //FISCAL PERIOD
            List<FiscalPeriod> fiscalPeriods =
                    fiscalPeriodService.getAllFiscalPeriods();
            List<FiscalPeriod> unblockedFiscalPeriods =
                    fiscalPeriodService.getAllUnblockedFiscalPeriods();
            if (unblockedFiscalPeriods.size() > 0) {
                setBackground(GREEN_BACKGROUND);
                String fiscalString = unblockedFiscalPeriods.size() + " "
                                      + t("lima.ui.home.fiscalperiod.opened") + "<br/>"
                                      + (fiscalPeriods.size() - unblockedFiscalPeriods.size())
                                      + " " + t("lima.ui.home.fiscalperiod.closed")
                                      + "<br/><br/><a href='#fiscalperiodschart'>"
                                      + t("lima.ui.home.fiscalperiod.modify") + "</a>";
                //set Text
                setText(htmlBegin + fiscalString + htmlEnd);


            } else {
                setBackground(RED_BACKGROUND);
                String fiscalString = t("lima.ui.home.fiscalperiod.noopen");
                if (fiscalPeriods.size() > 0) {
                    fiscalString += "<br/>" + fiscalPeriods.size() + " "
                                    + t("lima.ui.home.fiscalperiod.closed");
                }
                fiscalString += "<br/><br/><a href='#fiscalperiodschart'>"
                                + t("lima.ui.home.fiscalperiod.create") + "</a>";
                //set Text
                setText(htmlBegin + fiscalString + htmlEnd);

            }
        } catch (LimaException eee) {
            log.debug("Can't get datas home", eee);
        }
    }

    @Override
    public void notifyMethod(String serviceName, String methodeName) {
        log.debug("Nom de la méthode : " + methodeName);
        if (methodeName.contains("FiscalPeriod") ||
            methodeName.contains("importAll") ||
            methodeName.contains("importAs")) {
            refresh();
        }
    }

}
