package org.chorem.lima.ui.financialstatementchart;

/*
 * #%L
 * Lima :: Swing
 * %%
 * Copyright (C) 2008 - 2014 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.entity.FinancialStatement;
import static org.nuiton.i18n.I18n.t;

public class FinancialStatementMovementForm extends JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_ADD_STATE = "addState";
    public static final String PROPERTY_FINANCIAL_STATEMENT = "financialStatement";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ACCOUNTS_TEXT_FIELD_TEXT = "accountsTextField.text";
    public static final String BINDING_CREDIT_ACCOUNTS_TEXT_FIELD_TEXT = "creditAccountsTextField.text";
    public static final String BINDING_DEBIT_ACCOUNTS_TEXT_FIELD_TEXT = "debitAccountsTextField.text";
    public static final String BINDING_DESCRIPTION_TEXT_FIELD_TEXT = "descriptionTextField.text";
    public static final String BINDING_PROVISION_DEPRECATION_ACCOUNTS_TEXT_FIELD_TEXT = "provisionDeprecationAccountsTextField.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVTU8TQRgeKgUKigJSQCGClhhj3MpHohGifDQVmiKJ5UDsxenu0A5Od9aZWVguxp/gT9C7FxNvnowHzx68GP+CMR68Gt/ZfrGwDZDtYbt9P57ned/Zffr+F4pLgaZ2secZwrUVrRIjt7y9vVnaJabKEGkK6iguUO3TEUOxIuqzmnGp0I1iXren6+3pVV51uE3sQ90LedQr1QEjskKIUmgi2GFKmS400wue44oGalNUGOrbP79jb6zX72IIeQ6oG4ZRJk/qak3SmUcxaik0CEx7OM2wXQYZgtpl0HtBx1YZlvIJrpKX6BXqzqMuBwsAU+j66Uf2Mfx+z1EokcplKGa8fFehdS7KhlnhglQNRqvYcKmxQ21sm1AhFVakCpBmBQtlZBvxQiO+wff87ywXVcfxGbpglp1jhQrdOkoEUaoOQkBbQD3YsvywQgN6FYZej7HCOSPYbpV1p7ZwiRGYZjSweLkPazT8nK5MtHBTuTwuEQYdgxrXq5fWorposFl7ufGcUW5vEU9lKWFwXslAXzMR7O1NZbjp6pmAaexwh4IGo5F0jgmb0b9HgmAD2DQ5TCYDZFfaMfoQE8ehZ0OgkxYpUbV8JvzZNvhzIfgjpiDWWQnm2hDMhxBMO4LvUQlHlCGOICbWp3U2uvkjdPCSrLhKcRuObihw2LVwECfGX+i7+/WoQFcDTyKYi9Eyl9bb31FEceFCGB7d4nE/egqpmhONHnEiDehn/yWHvn/6+THbsJ9+4B4OLT3knmALsDCHCEU19cWa97iKsvQGdhaKKCEJA+v1rXU8RFihngZxwFd7N3W7sYZlBSDi3T8+f0k+/3YOxbKol3FsZbGuX0cJVRGwBc4sz3m05Cs6v98D10tam0LDFtnBLlOrjEuyCRL9o1Sof9HCCk+WqG3BITz0YCfjITtpCislvv4dKnxYauylA3SOtS1v7Sb+DHVRm1Gb+MZc99xQI+5zJHEt3vLWMLft0N+9Tv25WvKvmbDB41VuYQaGtFijn8QK/gZKriIwrO5a86fQd7lTg3Zqn9HZzXCM5IkYOrylL4/DEcZOj9BGw7XIGqYia5iOrOFmZA23I2u4E1nDTGQNc5E13IuM8AAQ/gOETGJRVQoAAA==";
    public static final String PROPERTY$DOCUMENT0 = "$Document0";
    public static final String PROPERTY$DOCUMENT1 = "$Document1";
    public static final String PROPERTY$DOCUMENT2 = "$Document2";
    public static final String PROPERTY$DOCUMENT3 = "$Document3";
    public static final String PROPERTY$DOCUMENT4 = "$Document4";
    private static final Log log = LogFactory.getLog(FinancialStatementMovementForm.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JTextField accountsTextField;
    protected Boolean addState;
    protected JTextField creditAccountsTextField;
    protected JTextField debitAccountsTextField;
    protected JTextField descriptionTextField;
    protected FinancialStatement financialStatement;
    protected JButton ok;
    protected JTextField provisionDeprecationAccountsTextField;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private Document $Document0;
    private Document $Document1;
    private Document $Document2;
    private Document $Document3;
    private Document $Document4;
    private JButton $JButton0;
    private FinancialStatementMovementForm $JDialog0 = this;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private JLabel $JLabel3;
    private JLabel $JLabel4;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
        protected void performCancel() {
            setFinancialStatement(null);
            dispose();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public FinancialStatementMovementForm(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public FinancialStatementMovementForm(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementMovementForm(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public FinancialStatementMovementForm(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementMovementForm(Dialog param0) {
        super(param0);
        $initialize();
    }

    public FinancialStatementMovementForm(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementMovementForm(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FinancialStatementMovementForm(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementMovementForm(Frame param0) {
        super(param0);
        $initialize();
    }

    public FinancialStatementMovementForm(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementMovementForm(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FinancialStatementMovementForm(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementMovementForm(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FinancialStatementMovementForm(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementMovementForm() {
        $initialize();
    }

    public FinancialStatementMovementForm(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementMovementForm(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FinancialStatementMovementForm(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementMovementForm(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FinancialStatementMovementForm(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementMovementForm(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public FinancialStatementMovementForm(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementMovementForm(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public FinancialStatementMovementForm(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementMovementForm(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FinancialStatementMovementForm(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementMovementForm(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public FinancialStatementMovementForm(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementMovementForm(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public FinancialStatementMovementForm(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementMovementForm(Window param0) {
        super(param0);
        $initialize();
    }

    public FinancialStatementMovementForm(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        performCancel();
    }

    public void doActionPerformed__on__ok(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        dispose();
    }

    public void doInsertUpdate__on__$Document0(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getFinancialStatement().setLabel(getDescriptionTextField().getText());
    }

    public void doInsertUpdate__on__$Document1(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getFinancialStatement().setAccounts(getAccountsTextField().getText());
    }

    public void doInsertUpdate__on__$Document2(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getFinancialStatement().setDebitAccounts(getDebitAccountsTextField().getText());
    }

    public void doInsertUpdate__on__$Document3(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getFinancialStatement().setCreditAccounts(getCreditAccountsTextField().getText());
    }

    public void doInsertUpdate__on__$Document4(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getFinancialStatement().setProvisionDeprecationAccounts(getProvisionDeprecationAccountsTextField().getText());
    }

    public void doRemoveUpdate__on__$Document0(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getFinancialStatement().setLabel(getDescriptionTextField().getText());
    }

    public void doRemoveUpdate__on__$Document1(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getFinancialStatement().setAccounts(getAccountsTextField().getText());
    }

    public void doRemoveUpdate__on__$Document2(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getFinancialStatement().setDebitAccounts(getDebitAccountsTextField().getText());
    }

    public void doRemoveUpdate__on__$Document3(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getFinancialStatement().setCreditAccounts(getCreditAccountsTextField().getText());
    }

    public void doRemoveUpdate__on__$Document4(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getFinancialStatement().setProvisionDeprecationAccounts(getProvisionDeprecationAccountsTextField().getText());
    }

    public void doWindowClosing__on__$JDialog0(WindowEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        performCancel();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JTextField getAccountsTextField() {
        return accountsTextField;
    }

    public Boolean getAddState() {
        return addState;
    }

    public JTextField getCreditAccountsTextField() {
        return creditAccountsTextField;
    }

    public JTextField getDebitAccountsTextField() {
        return debitAccountsTextField;
    }

    public JTextField getDescriptionTextField() {
        return descriptionTextField;
    }

    public FinancialStatement getFinancialStatement() {
        return financialStatement;
    }

    public JButton getOk() {
        return ok;
    }

    public JTextField getProvisionDeprecationAccountsTextField() {
        return provisionDeprecationAccountsTextField;
    }

    public Boolean isAddState() {
        return addState !=null && addState;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void set$Document0(Document $Document0) {
        Document oldValue = this.$Document0;
        this.$Document0 = $Document0;
        firePropertyChange(PROPERTY$DOCUMENT0, oldValue, $Document0);
    }

    public void set$Document1(Document $Document1) {
        Document oldValue = this.$Document1;
        this.$Document1 = $Document1;
        firePropertyChange(PROPERTY$DOCUMENT1, oldValue, $Document1);
    }

    public void set$Document2(Document $Document2) {
        Document oldValue = this.$Document2;
        this.$Document2 = $Document2;
        firePropertyChange(PROPERTY$DOCUMENT2, oldValue, $Document2);
    }

    public void set$Document3(Document $Document3) {
        Document oldValue = this.$Document3;
        this.$Document3 = $Document3;
        firePropertyChange(PROPERTY$DOCUMENT3, oldValue, $Document3);
    }

    public void set$Document4(Document $Document4) {
        Document oldValue = this.$Document4;
        this.$Document4 = $Document4;
        firePropertyChange(PROPERTY$DOCUMENT4, oldValue, $Document4);
    }

    public void setAddState(Boolean addState) {
        Boolean oldValue = this.addState;
        this.addState = addState;
        firePropertyChange(PROPERTY_ADD_STATE, oldValue, addState);
    }

    public void setFinancialStatement(FinancialStatement financialStatement) {
        FinancialStatement oldValue = this.financialStatement;
        this.financialStatement = financialStatement;
        firePropertyChange(PROPERTY_FINANCIAL_STATEMENT, oldValue, financialStatement);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Document get$Document0() {
        return $Document0;
    }

    protected Document get$Document1() {
        return $Document1;
    }

    protected Document get$Document2() {
        return $Document2;
    }

    protected Document get$Document3() {
        return $Document3;
    }

    protected Document get$Document4() {
        return $Document4;
    }

    protected JButton get$JButton0() {
        return $JButton0;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected JLabel get$JLabel4() {
        return $JLabel4;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createAccountsTextField() {
        $objectMap.put("accountsTextField", accountsTextField = new JTextField());
        
        accountsTextField.setName("accountsTextField");
        accountsTextField.setColumns(15);
    }

    protected void createAddState() {
        $objectMap.put("addState", addState = true);
    }

    protected void createCreditAccountsTextField() {
        $objectMap.put("creditAccountsTextField", creditAccountsTextField = new JTextField());
        
        creditAccountsTextField.setName("creditAccountsTextField");
        creditAccountsTextField.setColumns(15);
    }

    protected void createDebitAccountsTextField() {
        $objectMap.put("debitAccountsTextField", debitAccountsTextField = new JTextField());
        
        debitAccountsTextField.setName("debitAccountsTextField");
        debitAccountsTextField.setColumns(15);
    }

    protected void createDescriptionTextField() {
        $objectMap.put("descriptionTextField", descriptionTextField = new JTextField());
        
        descriptionTextField.setName("descriptionTextField");
        descriptionTextField.setColumns(15);
    }

    protected void createFinancialStatement() {
        $objectMap.put("financialStatement", financialStatement = null);
    }

    protected void createOk() {
        $objectMap.put("ok", ok = new JButton());
        
        ok.setName("ok");
        ok.setText(t("lima.common.ok"));
        ok.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__ok"));
    }

    protected void createProvisionDeprecationAccountsTextField() {
        $objectMap.put("provisionDeprecationAccountsTextField", provisionDeprecationAccountsTextField = new JTextField());
        
        provisionDeprecationAccountsTextField.setName("provisionDeprecationAccountsTextField");
        provisionDeprecationAccountsTextField.setColumns(15);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JDialog0
        add($Table0);
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(descriptionTextField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(accountsTextField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(debitAccountsTextField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel3, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(creditAccountsTextField, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel4, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(provisionDeprecationAccountsTextField, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JButton0, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(ok, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 5 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 1 property setters
        setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
        // late initializer
        $JDialog0.pack();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JDialog0", $JDialog0);
        createFinancialStatement();
        createAddState();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(t("lima.financialstatement.label"));
        createDescriptionTextField();
        // inline creation of $Document0
        $objectMap.put("$Document0", $Document0 = getDescriptionTextField().getDocument());
        
        $Document0.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document0"));
        $Document0.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document0"));
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(t("lima.financialstatement.accounts"));
        createAccountsTextField();
        // inline creation of $Document1
        $objectMap.put("$Document1", $Document1 = getAccountsTextField().getDocument());
        
        $Document1.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document1"));
        $Document1.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document1"));
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(t("lima.financialstatement.debitaccounts"));
        createDebitAccountsTextField();
        // inline creation of $Document2
        $objectMap.put("$Document2", $Document2 = getDebitAccountsTextField().getDocument());
        
        $Document2.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document2"));
        $Document2.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document2"));
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(t("lima.financialstatement.creditaccounts"));
        createCreditAccountsTextField();
        // inline creation of $Document3
        $objectMap.put("$Document3", $Document3 = getCreditAccountsTextField().getDocument());
        
        $Document3.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document3"));
        $Document3.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document3"));
        // inline creation of $JLabel4
        $objectMap.put("$JLabel4", $JLabel4 = new JLabel());
        
        $JLabel4.setName("$JLabel4");
        $JLabel4.setText(t("lima.financialstatement.provisiondeprecationaccounts"));
        createProvisionDeprecationAccountsTextField();
        // inline creation of $Document4
        $objectMap.put("$Document4", $Document4 = getProvisionDeprecationAccountsTextField().getDocument());
        
        $Document4.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document4"));
        $Document4.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document4"));
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(t("lima.common.cancel"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        createOk();
        // inline creation of $JDialog0
        setName("$JDialog0");
        setModal(true);
        $JDialog0.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__$JDialog0"));
        
        getRootPane().setDefaultButton(ok);// registers 5 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 5 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DESCRIPTION_TEXT_FIELD_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("financialStatement", this);
                if (getFinancialStatement() != null) {
                    getFinancialStatement().addPropertyChangeListener("label", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getFinancialStatement() != null) {
                    SwingUtil.setText(descriptionTextField, getFinancialStatement().getLabel());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("financialStatement", this);
                if (getFinancialStatement() != null) {
                    getFinancialStatement().removePropertyChangeListener("label", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ACCOUNTS_TEXT_FIELD_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("financialStatement", this);
                if (getFinancialStatement() != null) {
                    getFinancialStatement().addPropertyChangeListener("accounts", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getFinancialStatement() != null) {
                    SwingUtil.setText(accountsTextField, getFinancialStatement().getAccounts());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("financialStatement", this);
                if (getFinancialStatement() != null) {
                    getFinancialStatement().removePropertyChangeListener("accounts", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DEBIT_ACCOUNTS_TEXT_FIELD_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("financialStatement", this);
                if (getFinancialStatement() != null) {
                    getFinancialStatement().addPropertyChangeListener("debitAccounts", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getFinancialStatement() != null) {
                    SwingUtil.setText(debitAccountsTextField, getFinancialStatement().getDebitAccounts());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("financialStatement", this);
                if (getFinancialStatement() != null) {
                    getFinancialStatement().removePropertyChangeListener("debitAccounts", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CREDIT_ACCOUNTS_TEXT_FIELD_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("financialStatement", this);
                if (getFinancialStatement() != null) {
                    getFinancialStatement().addPropertyChangeListener("creditAccounts", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getFinancialStatement() != null) {
                    SwingUtil.setText(creditAccountsTextField, getFinancialStatement().getCreditAccounts());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("financialStatement", this);
                if (getFinancialStatement() != null) {
                    getFinancialStatement().removePropertyChangeListener("creditAccounts", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PROVISION_DEPRECATION_ACCOUNTS_TEXT_FIELD_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("financialStatement", this);
                if (getFinancialStatement() != null) {
                    getFinancialStatement().addPropertyChangeListener("provisionDeprecationAccounts", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getFinancialStatement() != null) {
                    SwingUtil.setText(provisionDeprecationAccountsTextField, getFinancialStatement().getProvisionDeprecationAccounts());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("financialStatement", this);
                if (getFinancialStatement() != null) {
                    getFinancialStatement().removePropertyChangeListener("provisionDeprecationAccounts", this);
                }
            }
        });
    }

}