package org.chorem.lima.ui.opening;

/*
 * #%L
 * Lima :: Swing
 * %%
 * Copyright (C) 2008 - 2014 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.enums.AccountsChartEnum;
import static org.nuiton.i18n.I18n.t;

public class CreateAccountsPanel extends JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVTz08TQRR+rRQoKEiJCAEiIh6MulXhBlF+GFRSfwQ8EHtx2p20S7Y748wsrBfjn+CfoHcvJt48GQ+ePXgx/gvGePBqfDNLu62uy8btYbuZed/3vu/t915/g4IUcHaPBIElfE85LWptre3u3q/t0bq6SWVdOFwxAeEvl4d8FYbtzrlUcK5a0fDyIby8wVqcedTrQi9XYEiqpy6VTUqVgtleRF3K8k7nejngvmizdkTFsb788T3/wn7+Kg8QcFRXRCtzR6EiJ30VyDu2ghJ22idll3gNlCEcr4F6T+izDZdIeY+06BN4BgMV6OdEIJmC+fSWDYfBB1zB4MLWA+JR94oCi4mGVW8yQVuW67SI5TsW49TD/taGoETRtXqdYQdpEJwbln4FwzVfKebdEsxHxvkew/JAw/UXXI+KIujAwkNScyl2n4yBmTtdWewAUG+F1Izekp5I0O5gTnXRaKd2ZGFrm9gOCzuHPboQXXdJuKv69HRSxbUjKxaPrFjqrhAw3TMNzKMV5TEKTK4KBeHjMVqr/h3hbbwKwzv5R3g1obn9NTH++d3Xt5vtxI5h71OxpV0Lh0niApMhlKNbj4Zx9ZXjlu8SvlzF3FMXt9Vs40yMsJ3DaxSH/cY03NJw6zaRTaQoDHx5/2Hi8adjkN+EIZcRe5Po+jtQVE2BU2CuHfAbq0bR8YNBfJ7U2hT0KRrgOpRWHM91PDpHFO4PxpNeD3AMMzFj6GipFT/+HN95s9oeRQ6lTf2zPBpH4RH0h93M+h5uZuy6DnNJfZtFGxi3kzn9P97ekfPmeSHOa+/ajazYRJG5muPZmG60q3GXjQ/9Vja0EyloB8OPR42TS//Lo48vZmJQUNgnrm9mt5RFxmICw1RmI+kY1jNrSHIxndlFOoYkF+kYklzMZnaRjiHJRTqGJBdnMrtIx5DkQjP8BjZV0o1KCQAA";
    private static final Log log = LogFactory.getLog(CreateAccountsPanel.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JAXXButtonGroup buttonGroup;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JLabel $JLabel0;
    private CreateAccountsPanel $JPanel0 = this;
    private JRadioButton $JRadioButton0;
    private JRadioButton $JRadioButton1;
    private JRadioButton $JRadioButton2;
    private JRadioButton $JRadioButton3;
    private JRadioButton $JRadioButton4;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public CreateAccountsPanel(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public CreateAccountsPanel(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateAccountsPanel() {
        $initialize();
    }

    public CreateAccountsPanel(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateAccountsPanel(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public CreateAccountsPanel(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateAccountsPanel(boolean param0) {
        super(param0);
        $initialize();
    }

    public CreateAccountsPanel(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JAXXButtonGroup getButtonGroup() {
        return buttonGroup;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JRadioButton get$JRadioButton0() {
        return $JRadioButton0;
    }

    protected JRadioButton get$JRadioButton1() {
        return $JRadioButton1;
    }

    protected JRadioButton get$JRadioButton2() {
        return $JRadioButton2;
    }

    protected JRadioButton get$JRadioButton3() {
        return $JRadioButton3;
    }

    protected JRadioButton get$JRadioButton4() {
        return $JRadioButton4;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createButtonGroup() {
        $objectMap.put("buttonGroup", buttonGroup = new JAXXButtonGroup());
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JPanel0
        add($Table0);
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JRadioButton0, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JRadioButton1, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JRadioButton2, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JRadioButton3, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JRadioButton4, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 10 property setters
        { ButtonGroup $buttonGroup = buttonGroup; $JRadioButton0.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add($JRadioButton0); }
        
        { $JRadioButton0.putClientProperty("$value", AccountsChartEnum.SHORTENED);  Object $buttonGroup = $JRadioButton0.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        { ButtonGroup $buttonGroup = buttonGroup; $JRadioButton1.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add($JRadioButton1); }
        
        { $JRadioButton1.putClientProperty("$value", AccountsChartEnum.BASE);  Object $buttonGroup = $JRadioButton1.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        { ButtonGroup $buttonGroup = buttonGroup; $JRadioButton2.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add($JRadioButton2); }
        
        { $JRadioButton2.putClientProperty("$value", AccountsChartEnum.DEVELOPED);  Object $buttonGroup = $JRadioButton2.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        { ButtonGroup $buttonGroup = buttonGroup; $JRadioButton3.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add($JRadioButton3); }
        
        { $JRadioButton3.putClientProperty("$value", AccountsChartEnum.IMPORT);  Object $buttonGroup = $JRadioButton3.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        { ButtonGroup $buttonGroup = buttonGroup; $JRadioButton4.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add($JRadioButton4); }
        
        { $JRadioButton4.putClientProperty("$value", AccountsChartEnum.IMPORTEBP);  Object $buttonGroup = $JRadioButton4.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JPanel0", $JPanel0);
        createButtonGroup();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(t("lima.ui.opening.accounts"));
        // inline creation of $JRadioButton0
        $objectMap.put("$JRadioButton0", $JRadioButton0 = new JRadioButton());
        
        $JRadioButton0.setName("$JRadioButton0");
        $JRadioButton0.setSelected(true);
        $JRadioButton0.setText(t("lima.charts.account.shortened"));
        // inline creation of $JRadioButton1
        $objectMap.put("$JRadioButton1", $JRadioButton1 = new JRadioButton());
        
        $JRadioButton1.setName("$JRadioButton1");
        $JRadioButton1.setText(t("lima.charts.account.base"));
        // inline creation of $JRadioButton2
        $objectMap.put("$JRadioButton2", $JRadioButton2 = new JRadioButton());
        
        $JRadioButton2.setName("$JRadioButton2");
        $JRadioButton2.setText(t("lima.charts.account.developed"));
        // inline creation of $JRadioButton3
        $objectMap.put("$JRadioButton3", $JRadioButton3 = new JRadioButton());
        
        $JRadioButton3.setName("$JRadioButton3");
        $JRadioButton3.setText(t("lima.ui.importexport.importcsv"));
        // inline creation of $JRadioButton4
        $objectMap.put("$JRadioButton4", $JRadioButton4 = new JRadioButton());
        
        $JRadioButton4.setName("$JRadioButton4");
        $JRadioButton4.setText(t("lima.ui.importexport.importebp"));
        // inline creation of $JPanel0
        setName("$JPanel0");
        
        $completeSetup();
    }

}