/*
 * #%L
 * Lima Swing
 * 
 * $Id: AccountsPane.java 3777 2014-04-14 07:29:08Z sbavencoff $
 * $HeadURL: https://svn.chorem.org/lima/tags/lima-0.7.2/lima-swing/src/main/java/org/chorem/lima/ui/home/AccountsPane.java $
 * %%
 * Copyright (C) 2008 - 2012 CodeLutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.ui.home;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.LimaContext;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.business.ServiceListener;
import org.chorem.lima.business.api.AccountService;
import org.chorem.lima.business.api.ImportService;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.MainView;

import javax.swing.event.HyperlinkEvent;

import static org.nuiton.i18n.I18n.t;

/**
 * Home view pane that display account plan statistics.
 * 
 * @author chatellier
 * @version $Revision: 3777 $
 * 
 * Last update : $Date: 2014-04-14 09:29:08 +0200 (Mon, 14 Apr 2014) $
 * By : $Author: sbavencoff $
 */
public class AccountsPane extends AbstractHomePane implements ServiceListener {

    private static final long serialVersionUID = 1L;

    private static final Log log = LogFactory.getLog(AccountsPane.class);

    protected AccountService accountService;

    public AccountsPane(HomeView view) {
        super(view);

        accountService = LimaServiceFactory.getService(AccountService.class);
        LimaServiceFactory.addServiceListener(AccountService.class, this);
        LimaServiceFactory.addServiceListener(ImportService.class, this);

        refresh();
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (HyperlinkEvent.EventType.ACTIVATED.equals(e.getEventType())) {
            if (e.getDescription().equals("#accountschart")) {
                MainView ui = LimaContext.MAIN_UI_ENTRY_DEF.getContextValue(view);
                ui.getHandler().showAccountView(ui);
            }
        }
    }

    public void refresh() {

        log.debug("Rafraîchissement accounts pane");
        
        String htmlBegin = "<font face='sans-serif' size=3>"
                           + "<p style=vertical-align:'bottom', horizontal-align:'center'>";
        String htmlEnd = "</p></font>";

        try {

            long accountCount = accountService.getAccountCount();
            if (accountCount > 0) {
                setBackground(GREEN_BACKGROUND);
                String accountsString = t("lima.ui.home.chartaccounts.state1_2") + " "
                                        + accountCount + " " + t("lima.ui.home.chartaccounts.state2_2")
                                        + "<br/><br/><a href='#accountschart'>"
                                        + t("lima.ui.home.chartaccounts.modify") + "</a>";
                //set Text
                setText(htmlBegin + accountsString + htmlEnd);
            } else {
                setBackground(RED_BACKGROUND);
                String accountsString = t("lima.ui.home.chartaccounts.nothing")
                                        + "<br/><br/><a href='#accountschart'>"
                                        + t("lima.ui.home.chartaccounts.create") + "</a>";
                //set Text
                setText(htmlBegin + accountsString + htmlEnd);
            }
        } catch (LimaException ex) {
            if (log.isErrorEnabled()) {
                log.error("Can't get datas account editor pane home", ex);
            }
        }
    }

    @Override
    public void notifyMethod(String serviceName, String methodeName) {
        log.debug("Nom de la méthode : " + methodeName);
        if (methodeName.contains("Account") || methodeName.contains("importAll") || methodeName.contains("importAs")) {
            refresh();
        }
    }
}
