package org.chorem.lima.ui.fiscalperiod;

/*
 * #%L
 * Lima :: Swing
 * %%
 * Copyright (C) 2008 - 2014 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class FiscalPeriodView extends Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BLOCK_ENABLED = "blockEnabled";
    public static final String PROPERTY_DELETE_ENABLED = "deleteEnabled";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_BLOCK_BUTTON_ENABLED = "blockButton.enabled";
    public static final String BINDING_DELETE_BUTTON_ENABLED = "deleteButton.enabled";
    public static final String BINDING_UPDATE_BUTTON_ENABLED = "updateButton.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVTU8TQRgeKqWUUpRPIYBWJTHxsIWDXykRBGmQFCS2IcRenO4OdHC6s87Mynox/gR/gt69mHjzZDx49uDF+BeM8eDV+M5u6bZQSqE9bHffj2ee551533n/C0WlQFf2sOcZwrUVrRBj7f729qPSHjHVAyJNQR3FBQp+XREUKaKEVbNLha4Vczo9XU1PL/OKw21i12VncqhPqpeMyDIhSqHpxgxTynS+5s54jisOUGukmqG+/fM78sZ6/S6CkOcAuyRISZ2UFSrpzqEItRQagpVe4DTD9i7QENTeBb5JbVtmWMoNXCHP0SsUy6EeBwsAU+hq+5J9DD/fcxSKzRRwiZFZhWa52DXMMhekYjBawYZLjR0qTcwcIii3jKz/sel/bFGy7zg+TA+AlLFtMSIUun1akNUgM8TqLzFuPluxNSuoxaCWbehSGEucM4LtMDRpEUYUqcZq42Do7JtZK0DCEhagbUSjeIbch1oaB3YdGK/Fx7FlLblKcVuh4YbwwKrDRkKWrmNhRULXRKM/4as41t0fMD/Wn5xZy5uCM7aJbb03FxsIha5GCWM7dcX1t3Wdw0IK3TrNroSJYTEHjyArNHdqUA2WqmEOSKiBqSi3qywv1YvMUanyDQHARqDJhm6CPjXCPg0bqauIosIFs0LjxaOt/RhcQVOPH2pqDeh7/40Nf//082P2oJOHYO3RpqF1gwg6zBEc1Cuqlz4ftLGrKEuvYydTRPFAsj+lppoQy1fdQA7WC46+TjdWsSwDRDT24/OXsaffzqFIFvUxjq0s1vEPUVyVBVSBM8tzFhZ9Rv37vfC8oLnB6d6BaBVs3NA8tRm1SQorGC4lV5F7HtRiqkktaoRK8a9/h/MfFg/q0QX8Jo4ND2sSfYJ6gtX82VYdW01nWcKRxLV4OJ6aDawu/T/qVE/mnP+82UxwNzV1Jw/MQ5viVInaFpwq0KkT7voC9FvGxxtvAy+hYGgUqFMgntJBi2eF0uaFFgiTbZCJkXDknRlGm1c6RmglZbothI2OEVqpaA+hlYrLHatoD6GVipMR4I4zOXMr9jIce7getqik1ZF7pznm9TYwoxU9eVsQawckLvj+KqG7ZdUhm0M3Roe0eiUXCndeo2QDqxakbgDYf7MEvnjgCgAA";
    private static final Log log = LogFactory.getLog(FiscalPeriodView.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton addButton;
    protected JButton blockButton;
    protected Boolean blockEnabled;
    protected JButton deleteButton;
    protected Boolean deleteEnabled;
    protected FiscalPeriodTable fiscalPeriodTable;
    protected FiscalPeriodTableModel fiscalPeriodTableModel;
    protected FiscalPeriodViewHandler handler;
    protected ListSelectionModel selectionModel;
    protected JButton updateButton;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JScrollPane $JScrollPane0;
    private JToolBar $JToolBar0;
    private FiscalPeriodView $Table0 = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    void $afterCompleteSetup() {
            getHandler().init();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public FiscalPeriodView() {
        $initialize();
    }

    public FiscalPeriodView(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__addButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addFiscalPeriod();
    }

    public void doActionPerformed__on__blockButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.blockFiscalPeriod();
    }

    public void doActionPerformed__on__deleteButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.deleteFiscalPeriod();
    }

    public void doActionPerformed__on__updateButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.updateFiscalPeriod();
    }

    public void doValueChanged__on__selectionModel(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.onSelectionChanged(event);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getAddButton() {
        return addButton;
    }

    public JButton getBlockButton() {
        return blockButton;
    }

    public Boolean getBlockEnabled() {
        return blockEnabled;
    }

    public JButton getDeleteButton() {
        return deleteButton;
    }

    public Boolean getDeleteEnabled() {
        return deleteEnabled;
    }

    public FiscalPeriodTable getFiscalPeriodTable() {
        return fiscalPeriodTable;
    }

    public FiscalPeriodTableModel getFiscalPeriodTableModel() {
        return fiscalPeriodTableModel;
    }

    public FiscalPeriodViewHandler getHandler() {
        return handler;
    }

    public ListSelectionModel getSelectionModel() {
        return selectionModel;
    }

    public JButton getUpdateButton() {
        return updateButton;
    }

    public Boolean isBlockEnabled() {
        return blockEnabled !=null && blockEnabled;
    }

    public Boolean isDeleteEnabled() {
        return deleteEnabled !=null && deleteEnabled;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBlockEnabled(Boolean blockEnabled) {
        Boolean oldValue = this.blockEnabled;
        this.blockEnabled = blockEnabled;
        firePropertyChange(PROPERTY_BLOCK_ENABLED, oldValue, blockEnabled);
    }

    public void setDeleteEnabled(Boolean deleteEnabled) {
        Boolean oldValue = this.deleteEnabled;
        this.deleteEnabled = deleteEnabled;
        firePropertyChange(PROPERTY_DELETE_ENABLED, oldValue, deleteEnabled);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JToolBar get$JToolBar0() {
        return $JToolBar0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createAddButton() {
        $objectMap.put("addButton", addButton = new JButton());
        
        addButton.setName("addButton");
        addButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addButton"));
    }

    protected void createBlockButton() {
        $objectMap.put("blockButton", blockButton = new JButton());
        
        blockButton.setName("blockButton");
        blockButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__blockButton"));
    }

    protected void createBlockEnabled() {
        $objectMap.put("blockEnabled", blockEnabled = false);
    }

    protected void createDeleteButton() {
        $objectMap.put("deleteButton", deleteButton = new JButton());
        
        deleteButton.setName("deleteButton");
        deleteButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__deleteButton"));
    }

    protected void createDeleteEnabled() {
        $objectMap.put("deleteEnabled", deleteEnabled = false);
    }

    protected void createFiscalPeriodTable() {
        $objectMap.put("fiscalPeriodTable", fiscalPeriodTable = new FiscalPeriodTable(handler));
        
        fiscalPeriodTable.setName("fiscalPeriodTable");
        fiscalPeriodTable.setColumnControlVisible(true);
        fiscalPeriodTable.setRowHeight(24);
        fiscalPeriodTable.setSortable(false);
    }

    protected void createFiscalPeriodTableModel() {
        $objectMap.put("fiscalPeriodTableModel", fiscalPeriodTableModel = new FiscalPeriodTableModel());
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new FiscalPeriodViewHandler(this));
    }

    protected void createSelectionModel() {
        $objectMap.put("selectionModel", selectionModel = new DefaultListSelectionModel());
        
        selectionModel.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__selectionModel"));
    }

    protected void createUpdateButton() {
        $objectMap.put("updateButton", updateButton = new JButton());
        
        updateButton.setName("updateButton");
        updateButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__updateButton"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $Table0
        add($JToolBar0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JScrollPane0, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JToolBar0
        $JToolBar0.add(addButton);
        $JToolBar0.add(updateButton);
        $JToolBar0.add(blockButton);
        $JToolBar0.add(deleteButton);
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(fiscalPeriodTable);
        
        // apply 3 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 11 property setters
        addButton.setIcon(SwingUtil.createActionIcon("fiscalPeriod-new"));
        addButton.setToolTipText( t("lima.charts.fiscalperiod.add") + " (Ctrl+N)");
        updateButton.setIcon(SwingUtil.createActionIcon("fiscalPeriod-edit"));
        updateButton.setToolTipText( t("lima.charts.fiscalperiod.update") + " (Ctrl+M)");
        blockButton.setIcon(SwingUtil.createActionIcon("fiscalPeriod-close"));
        blockButton.setToolTipText( t("lima.charts.fiscalperiod.block") + " (Ctrl+B)");
        deleteButton.setIcon(SwingUtil.createActionIcon("fiscalPeriod-remove"));
        deleteButton.setToolTipText( t("lima.charts.fiscalperiod.delete") + " (Del)");
        fiscalPeriodTable.setModel(fiscalPeriodTableModel);
        fiscalPeriodTable.setSelectionModel(selectionModel);
        selectionModel.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$Table0", $Table0);
        createHandler();
        createBlockEnabled();
        createDeleteEnabled();
        // inline creation of $JToolBar0
        $objectMap.put("$JToolBar0", $JToolBar0 = new JToolBar());
        
        $JToolBar0.setName("$JToolBar0");
        $JToolBar0.setFloatable(false);
        createAddButton();
        createUpdateButton();
        createBlockButton();
        createDeleteButton();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createFiscalPeriodTableModel();
        createFiscalPeriodTable();
        createSelectionModel();
        // inline creation of $Table0
        setName("$Table0");
        
        // registers 3 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 3 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_UPDATE_BUTTON_ENABLED, true ,"deleteEnabled") {
        
            @Override
            public void processDataBinding() {
                updateButton.setEnabled(isDeleteEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_BLOCK_BUTTON_ENABLED, true ,"blockEnabled") {
        
            @Override
            public void processDataBinding() {
                blockButton.setEnabled(isBlockEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_DELETE_BUTTON_ENABLED, true ,"deleteEnabled") {
        
            @Override
            public void processDataBinding() {
                deleteButton.setEnabled(isDeleteEnabled());
            }
        });
    }

}