/*
 * #%L
 * Lima Swing
 * 
 * $Id: AccountComboBox.java 3765 2014-03-17 09:21:37Z dcosse $
 * $HeadURL: https://svn.chorem.org/lima/tags/lima-0.7.2/lima-swing/src/main/java/org/chorem/lima/ui/accountsreports/AccountComboBox.java $
 * %%
 * Copyright (C) 2008 - 2012 CodeLutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.ui.accountsreports;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;

import javax.swing.JComboBox;

import org.chorem.lima.entity.Account;
import org.chorem.lima.util.AccountToString;
import org.jdesktop.swingx.autocomplete.AutoCompleteDecorator;

/**
 * Combo box pour les comptes qui ajoute quelques comportement comme
 * l'autocompletion.
 * 
 * @author chatellier
 * @version $Revision: 3765 $
 * 
 * Last update : $Date: 2014-03-17 10:21:37 +0100 (Mon, 17 Mar 2014) $
 * By : $Author: dcosse $
 */
public class AccountComboBox extends JComboBox implements KeyListener {

    private static final long serialVersionUID = 1L;

    protected Timer timer;

    public AccountComboBox() {
        AutoCompleteDecorator.decorate(this, AccountToString.getInstance());
        getEditor().getEditorComponent().addKeyListener(this);
    }

    public void back() {
        int row = getSelectedIndex();

        if (row > 0) {
            getEditor().setItem(getItemAt(row - 1));
        }
    }

    public void next() {
        int size = getModel().getSize();
        int row = getSelectedIndex();

        if (row < size - 1) {
            getEditor().setItem(getItemAt(row + 1));
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {

    }

    @Override
    public void keyReleased(KeyEvent e) {
        Timer timer = getTimer();
        if(timer != null) {
            // if task were scheduled, they are canceled.
            timer.cancel();
            resetTimer();
        } else {
            // a new task is scheduled.
            timer = initTimer();
            TimerTaskKeyEvent task = new TimerTaskKeyEvent();
            task.setE(e);
            timer.schedule(task, 2000);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }


    synchronized void resetTimer(){
        this.timer = null;
    }

    synchronized Timer initTimer() {
        timer = new Timer();
        return this.timer;
    }

    synchronized Timer getTimer(){
        return this.timer;
    }


    public class TimerTaskKeyEvent extends TimerTask {

        protected KeyEvent e;

        @Override
        public void run() {
            Object object = getSelectedItem();
            if (object instanceof Account) {
                fireActionEvent();
            }

            // delegate popup list menu
            if (e.getKeyChar() == KeyEvent.VK_ENTER) {
                firePopupMenuCanceled();
            }
            // the timer is closed.
            resetTimer();
        }

        public void setE(KeyEvent e) {
            this.e = e;
        }
    }

}
