package org.chorem.lima.ui.vatreports;

/*
 * #%L
 * Lima :: Swing
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2008 - 2014 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.ListSelectionModel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.ui.common.IntervalPanel;
import org.jdesktop.swingx.JXTable;
import static org.nuiton.i18n.I18n._;

public class VatReportView extends Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_AUTO_COMPLETE = "autoComplete";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAJVTTU8UQRCtXdiF5SN+IAQiJqgkGE16jVeMIhgCZP0IGELci70zHbaxp7vtroHxYvwJ/gS9ezHx5sl48OzBi/EvGOPBq7F7ZneH1VFxDjOTqn6vXlXXe/kFKtbA2T2aJMTEEnnEyMaNnZ07rT0W4E1mA8M1KgPZUypDuQmjYS9uEc43Gx5e78DrKyrSSjJ5CL3YgBGLjwWzbcYQ4Uw/IrC2vtVLLyY6Nl3Wnqgi1uffvpafhU9flAES7dRVXStz/0LlnQw2oMxDhJOu0j6tCyp3nQzD5a7TO+5jK4Jae5tG7BE8gaEGVDU1jgzh3NFbTjlSfKIRhubv0ZZglxEuKbNLgrYyLCKCR5TEnOxTNEwrg5ZsU9xMf7c5O9A6Zag6fJvKUDCDcOU/8GsZKKcZozEqr1owZAgnfLPED4AsKyUYlfnRcS6RmX0q7lLJBMJCQd1ARZGSZP3wSQ+v9VhO+YJBp+BKmwUPl1WCMOkLJ8QeuKGTjW68HzrOQo6uneUYUUmEiT5MFu0gDJzuu363WCRfrPzmS02omNiFEaabv+/ipktlWzj9yxZ6wjT7Y2ri45vPr1e7qzfgak8WHj3kHLcS2ijtbo/70seyvYuRi/otqhebULNMONultpotELbVSTtxrl52ax5O1qhtO4rK0Ke376YefBiA8iqMCEXDVerPr0MN28ZNQYkw0deXUkVjB8PufdxrQxjOKjNvh6tcCi7ZHEVnhlaM7FriRjFbMIqenlbt/feJrVdL3XGUnLyZPx7PR1K5D9WsWurFjs0KvTeqLYtDldupyGAl/53Sne2dS9/zRf0OIkvQZxeS2H8upKL938Ujcvgw+QvDjGP4CRfeOZBfBQAA";
    private static final Log log = LogFactory.getLog(VatReportView.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Boolean autoComplete;
    protected JCheckBox autocompleteCheckBox;
    protected JButton editVatButton;
    protected VatReportViewHandler handler;
    protected IntervalPanel intervalPanel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private VatReportView $Table0 = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    void $afterCompleteSetup() {
            getHandler().init();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public VatReportView() {
        $initialize();
    }

    public VatReportView(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__autocompleteCheckBox(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setAutoComplete(!autoComplete);
    }

    public void doActionPerformed__on__editVatButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().editVat();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Boolean getAutoComplete() {
        return autoComplete;
    }

    public JCheckBox getAutocompleteCheckBox() {
        return autocompleteCheckBox;
    }

    public JButton getEditVatButton() {
        return editVatButton;
    }

    public VatReportViewHandler getHandler() {
        return handler;
    }

    public IntervalPanel getIntervalPanel() {
        return intervalPanel;
    }

    public Boolean isAutoComplete() {
        return autoComplete !=null && autoComplete;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setAutoComplete(Boolean autoComplete) {
        Boolean oldValue = this.autoComplete;
        this.autoComplete = autoComplete;
        firePropertyChange(PROPERTY_AUTO_COMPLETE, oldValue, autoComplete);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createAutoComplete() {
        $objectMap.put("autoComplete", autoComplete = true);
    }

    protected void createAutocompleteCheckBox() {
        $objectMap.put("autocompleteCheckBox", autocompleteCheckBox = new JCheckBox());
        
        autocompleteCheckBox.setName("autocompleteCheckBox");
        autocompleteCheckBox.setSelected(true);
        autocompleteCheckBox.setText(_("lima.common.autocomplete"));
        autocompleteCheckBox.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__autocompleteCheckBox"));
    }

    protected void createEditVatButton() {
        $objectMap.put("editVatButton", editVatButton = new JButton());
        
        editVatButton.setName("editVatButton");
        editVatButton.setText(_("lima.reports.vat"));
        editVatButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__editVatButton"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new VatReportViewHandler(this));
    }

    protected void createIntervalPanel() {
        $objectMap.put("intervalPanel", intervalPanel = new IntervalPanel());
        
        intervalPanel.setName("intervalPanel");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $Table0
        add(intervalPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        add(autocompleteCheckBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        add(editVatButton, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$Table0", $Table0);
        createHandler();
        createAutoComplete();
        createIntervalPanel();
        createAutocompleteCheckBox();
        createEditVatButton();
        // inline creation of $Table0
        setName("$Table0");
        
        $completeSetup();
    }

}