package org.chorem.lima.ui.financialtransaction;

/*
 * #%L
 * Lima :: Swing
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2008 - 2014 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JToolBar.Separator;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.entity.EntryBook;
import org.chorem.lima.entity.FinancialPeriod;
import org.chorem.lima.entity.FiscalPeriod;
import org.chorem.lima.ui.common.EntryBookComboBoxModel;
import org.chorem.lima.ui.common.EntryBookListRenderer;
import org.chorem.lima.ui.common.FinancialPeriodComboBoxModel;
import org.chorem.lima.ui.common.FinancialTransactionTableModel;
import org.chorem.lima.ui.common.FiscalPeriodComboBoxModel;
import static org.nuiton.i18n.I18n._;

public class FinancialTransactionView extends Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_ASSIGNABLE_IN_ALL_ENTRIES = "assignableInAllEntries";
    public static final String PROPERTY_BALANCE = "balance";
    public static final String PROPERTY_ENTRY_IN_CLIP_BOARD = "entryInClipBoard";
    public static final String PROPERTY_SELECTED_ROW = "selectedRow";
    public static final String PROPERTY_TRANSACTION_IN_CLIP_BOARD = "transactionInClipBoard";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JBUTTON1_ENABLED = "$JButton1.enabled";
    private static final String BINDING_$JBUTTON2_ENABLED = "$JButton2.enabled";
    private static final String BINDING_$JBUTTON3_ENABLED = "$JButton3.enabled";
    private static final String BINDING_$JBUTTON4_ENABLED = "$JButton4.enabled";
    private static final String BINDING_$JBUTTON5_ENABLED = "$JButton5.enabled";
    private static final String BINDING_$JBUTTON6_ENABLED = "$JButton6.enabled";
    private static final String BINDING_$JBUTTON7_ENABLED = "$JButton7.enabled";
    private static final String BINDING_$JBUTTON8_ENABLED = "$JButton8.enabled";
    private static final String BINDING_$JBUTTON9_ENABLED = "$JButton9.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKWYz28bRRTHJya/nFBIkzRtRRqlxSAkxDpNSGmVUvKjNYlxaFVHKJBLx7sTe5rxzHZ23LhCQr1y40+AOxckbpwQB84cuCD+BVRxgAsS4s2u7c0668mIzcGJ5r332e/37ey+cb79A40EEl19jNttR7a4ok3ilDf29+/XHhNX3SWBK6mvhETRz1AO5Q7QpNdbDxR6/aCiy4ud8uKWaPqCE36ieq2CJgL1jJGgQYhS6Eqywg2CYrUXXmv7Ldml9kSlUb/+80XuK+/5NzmE2j6oewOsLJ5VFTsZrqAc9RSahis9xUWGeR1kSMrroPecXttiOAg+xk3yBH2Bxipo1McSYApds7ccMsL6tq/QWGEP1xhZUmhdyLrjNoQkTYfRJnZa1DmkHHOXYqYk5gF2FRXcKXUX9+LFTyg59v0QOwrQBuYeI1KhD7NCtyNSzH4lIIyE4V3hEabQgm5M2wmOoU9OhQaqmkiIKyejSuI9FMcKnddlju6xsykEI5jHmXMnlO3wLUb9TYGlp6OzcdYU9Fc+Gxwfq2HAu6RveQ7aT+tcd32HbzB2DyiUBH1ZE4XyHsjaxBJuzexJi911nZjv5ecL5c2WUoJD+kwiPVrWaVdOZ1/XC9cGBJdNwZWU4GxPdKFKYGti2HdLfXfodMaAC7xruvqqKXjDFHzPFLxpaSps29sDILcsIcspkPFCuYJrhEHXphNdC1eTuZcPaeBi9oBIKjx44mtiU7Q7D8VKynPnimYzfNIGVMWbbzaNrNCFhKLuerqBsEN3krH53pOfqvmGSfPgwlj2xQF8Hb6blDJcw+5Ryn0a5qStLO/fiuH+LafYnwvfF/CyOeozvjTY+L3Uktjy+VPMFLPnCuWqKwVjDzDXb/qLifsYh5JvlIXDlFdyOCw6sm9a3K/UUv/kFh6QqNBGltERMvRFPvVhBr+WmMEw3Z14usfjd+gAjcgWLCt06eD0geAhhKKjwKW+o4AGhtF/52Z+/eH370vd+b8K176Qmnri+AJz2ZfCh2lJ9aVfjYZ/S1FW3MX+2gHKR3MrPNvMpwirdsIgDq4XzTVd7mzjoAGIkbHffvxp7tEvL6FcCU0wgb0S1vk7KK8aErogmNf2P1gPFb18PA6fU1obbJzErIXZe9vDCi/WKPdg69xpQy/mU3rRE1TL//zXTPW79W4/hkDf5YHpcU9GPkOjlDPKSXgi6hx2Uk9Ak35AWp6IDzVpx5wh/XvK7+y7evh5lGY4fwjtUdH+m74dSVjECgZ0raUIGNaVInSi/3oSghcswMPUjWYwT2dctWBMKngD7VF/r/OK+t8ovfy5gVCwEDNGwhOMlwmjl59nJpisvGlF+DIzweTCjmBy8VZmF3YEkws7gsnFO5ld2BFMLuwIJhfFzC7sCCYXdgSTi+uZXdgRTC7sCCYXK5ld2BFMLuwIJhermV3YEUwu7AgmF7cyu7AjmFzYEUwu3rcYfeNMn/BL0RfXDJyRpj4MGyBbNmIk4R6RxCTmbE6vsU+zEEyNLVkR/s5M+MdA+MiGMISyEoydtCOYOrmbWYMdwaThfmYNdgSThmrmHWVHMO2o/cw7yopg7KQdweTikc03IymOtwmtN5RBig2o7/+3Z8j6D1Wy4ckQGAAA";
    private static final Log log = LogFactory.getLog(FinancialTransactionView.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Boolean assignableInAllEntries;
    protected JButton back;
    protected Boolean balance;
    protected JComboBox entryBookComboBox;
    protected EntryBookComboBoxModel entryBookComboBoxModel;
    protected Boolean entryInClipBoard;
    protected JComboBox financialPeriodComboBox;
    protected FinancialPeriodComboBoxModel financialPeriodComboBoxModel;
    protected FinancialTransactionTable financialTransactionTable;
    protected FinancialTransactionTableModel financialTransactionTableModel;
    protected JComboBox fiscalPeriodComboBox;
    protected FiscalPeriodComboBoxModel fiscalPeriodComboBoxModel;
    protected FinancialTransactionViewHandler handler;
    protected JButton next;
    protected Boolean selectedRow;
    protected ListSelectionModel selectionModel;
    protected Boolean transactionInClipBoard;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JButton $JButton0;
    private JButton $JButton1;
    private JButton $JButton2;
    private JButton $JButton3;
    private JButton $JButton4;
    private JButton $JButton5;
    private JButton $JButton6;
    private JButton $JButton7;
    private JButton $JButton8;
    private JButton $JButton9;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private JScrollPane $JScrollPane0;
    private Separator $JToolBar$Separator0;
    private Separator $JToolBar$Separator1;
    private Separator $JToolBar$Separator2;
    private Separator $JToolBar$Separator3;
    private JToolBar $JToolBar0;
    private FinancialTransactionView $Table0 = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    void $afterCompleteSetup() {
            handler.init();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public FinancialTransactionView() {
        $initialize();
    }

    public FinancialTransactionView(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addFinancialTransaction();
    }

    public void doActionPerformed__on__$JButton1(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.deleteSelectedTransaction();
    }

    public void doActionPerformed__on__$JButton2(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.copyTransaction();
    }

    public void doActionPerformed__on__$JButton3(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.pasteTransaction();
    }

    public void doActionPerformed__on__$JButton4(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addEntry();
    }

    public void doActionPerformed__on__$JButton5(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.deleteSelectedEntry();
    }

    public void doActionPerformed__on__$JButton6(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.copyEntry();
    }

    public void doActionPerformed__on__$JButton7(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.pasteEntry();
    }

    public void doActionPerformed__on__$JButton8(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.assignAllEntries();
    }

    public void doActionPerformed__on__$JButton9(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.balanceTransaction();
    }

    public void doActionPerformed__on__back(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.back(financialPeriodComboBox);
    }

    public void doActionPerformed__on__next(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.next(financialPeriodComboBox);
    }

    public void doItemStateChanged__on__entryBookComboBox(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.entryBookSelected(event);
    }

    public void doItemStateChanged__on__financialPeriodComboBox(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.financialPeriodSelected(event);
    }

    public void doItemStateChanged__on__fiscalPeriodComboBox(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.fiscalPeriodSelected(event);
    }

    public void doValueChanged__on__selectionModel(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.selectionChanged();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Boolean getAssignableInAllEntries() {
        return assignableInAllEntries;
    }

    public JButton getBack() {
        return back;
    }

    public Boolean getBalance() {
        return balance;
    }

    public JComboBox getEntryBookComboBox() {
        return entryBookComboBox;
    }

    public EntryBookComboBoxModel getEntryBookComboBoxModel() {
        return entryBookComboBoxModel;
    }

    public Boolean getEntryInClipBoard() {
        return entryInClipBoard;
    }

    public JComboBox getFinancialPeriodComboBox() {
        return financialPeriodComboBox;
    }

    public FinancialPeriodComboBoxModel getFinancialPeriodComboBoxModel() {
        return financialPeriodComboBoxModel;
    }

    public FinancialTransactionTable getFinancialTransactionTable() {
        return financialTransactionTable;
    }

    public FinancialTransactionTableModel getFinancialTransactionTableModel() {
        return financialTransactionTableModel;
    }

    public JComboBox getFiscalPeriodComboBox() {
        return fiscalPeriodComboBox;
    }

    public FiscalPeriodComboBoxModel getFiscalPeriodComboBoxModel() {
        return fiscalPeriodComboBoxModel;
    }

    public FinancialTransactionViewHandler getHandler() {
        return handler;
    }

    public JButton getNext() {
        return next;
    }

    public Boolean getSelectedRow() {
        return selectedRow;
    }

    public ListSelectionModel getSelectionModel() {
        return selectionModel;
    }

    public Boolean getTransactionInClipBoard() {
        return transactionInClipBoard;
    }

    public Boolean isAssignableInAllEntries() {
        return assignableInAllEntries !=null && assignableInAllEntries;
    }

    public Boolean isBalance() {
        return balance !=null && balance;
    }

    public Boolean isEntryInClipBoard() {
        return entryInClipBoard !=null && entryInClipBoard;
    }

    public Boolean isSelectedRow() {
        return selectedRow !=null && selectedRow;
    }

    public Boolean isTransactionInClipBoard() {
        return transactionInClipBoard !=null && transactionInClipBoard;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setAssignableInAllEntries(Boolean assignableInAllEntries) {
        Boolean oldValue = this.assignableInAllEntries;
        this.assignableInAllEntries = assignableInAllEntries;
        firePropertyChange(PROPERTY_ASSIGNABLE_IN_ALL_ENTRIES, oldValue, assignableInAllEntries);
    }

    public void setBalance(Boolean balance) {
        Boolean oldValue = this.balance;
        this.balance = balance;
        firePropertyChange(PROPERTY_BALANCE, oldValue, balance);
    }

    public void setEntryInClipBoard(Boolean entryInClipBoard) {
        Boolean oldValue = this.entryInClipBoard;
        this.entryInClipBoard = entryInClipBoard;
        firePropertyChange(PROPERTY_ENTRY_IN_CLIP_BOARD, oldValue, entryInClipBoard);
    }

    public void setSelectedRow(Boolean selectedRow) {
        Boolean oldValue = this.selectedRow;
        this.selectedRow = selectedRow;
        firePropertyChange(PROPERTY_SELECTED_ROW, oldValue, selectedRow);
    }

    public void setTransactionInClipBoard(Boolean transactionInClipBoard) {
        Boolean oldValue = this.transactionInClipBoard;
        this.transactionInClipBoard = transactionInClipBoard;
        firePropertyChange(PROPERTY_TRANSACTION_IN_CLIP_BOARD, oldValue, transactionInClipBoard);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton get$JButton0() {
        return $JButton0;
    }

    protected JButton get$JButton1() {
        return $JButton1;
    }

    protected JButton get$JButton2() {
        return $JButton2;
    }

    protected JButton get$JButton3() {
        return $JButton3;
    }

    protected JButton get$JButton4() {
        return $JButton4;
    }

    protected JButton get$JButton5() {
        return $JButton5;
    }

    protected JButton get$JButton6() {
        return $JButton6;
    }

    protected JButton get$JButton7() {
        return $JButton7;
    }

    protected JButton get$JButton8() {
        return $JButton8;
    }

    protected JButton get$JButton9() {
        return $JButton9;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected Separator get$JToolBar$Separator0() {
        return $JToolBar$Separator0;
    }

    protected Separator get$JToolBar$Separator1() {
        return $JToolBar$Separator1;
    }

    protected Separator get$JToolBar$Separator2() {
        return $JToolBar$Separator2;
    }

    protected Separator get$JToolBar$Separator3() {
        return $JToolBar$Separator3;
    }

    protected JToolBar get$JToolBar0() {
        return $JToolBar0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createAssignableInAllEntries() {
        $objectMap.put("assignableInAllEntries", assignableInAllEntries = false);
    }

    protected void createBack() {
        $objectMap.put("back", back = new JButton());
        
        back.setName("back");
        back.setToolTipText(_("lima.ui.financialtransaction.previousfinancialperiod"));
        back.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__back"));
    }

    protected void createBalance() {
        $objectMap.put("balance", balance = true);
    }

    protected void createEntryBookComboBox() {
        $objectMap.put("entryBookComboBox", entryBookComboBox = new JComboBox());
        
        entryBookComboBox.setName("entryBookComboBox");
        entryBookComboBox.setToolTipText(_("lima.ui.financialtransaction.entrybook"));
        entryBookComboBox.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__entryBookComboBox"));
    }

    protected void createEntryBookComboBoxModel() {
        $objectMap.put("entryBookComboBoxModel", entryBookComboBoxModel = new EntryBookComboBoxModel());
    }

    protected void createEntryInClipBoard() {
        $objectMap.put("entryInClipBoard", entryInClipBoard = false);
    }

    protected void createFinancialPeriodComboBox() {
        $objectMap.put("financialPeriodComboBox", financialPeriodComboBox = new JComboBox());
        
        financialPeriodComboBox.setName("financialPeriodComboBox");
        financialPeriodComboBox.setToolTipText(_("lima.ui.financialtransaction.financialperiod"));
        financialPeriodComboBox.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__financialPeriodComboBox"));
    }

    protected void createFinancialPeriodComboBoxModel() {
        $objectMap.put("financialPeriodComboBoxModel", financialPeriodComboBoxModel = new FinancialPeriodComboBoxModel());
    }

    protected void createFinancialTransactionTable() {
        $objectMap.put("financialTransactionTable", financialTransactionTable = new FinancialTransactionTable(handler));
        
        financialTransactionTable.setName("financialTransactionTable");
        financialTransactionTable.setRowHeight(22);
    }

    protected void createFinancialTransactionTableModel() {
        $objectMap.put("financialTransactionTableModel", financialTransactionTableModel = new FinancialTransactionTableModel());
    }

    protected void createFiscalPeriodComboBox() {
        $objectMap.put("fiscalPeriodComboBox", fiscalPeriodComboBox = new JComboBox());
        
        fiscalPeriodComboBox.setName("fiscalPeriodComboBox");
        fiscalPeriodComboBox.setToolTipText(_("lima.ui.financialtransaction.fiscalyear"));
        fiscalPeriodComboBox.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__fiscalPeriodComboBox"));
    }

    protected void createFiscalPeriodComboBoxModel() {
        $objectMap.put("fiscalPeriodComboBoxModel", fiscalPeriodComboBoxModel = new FiscalPeriodComboBoxModel());
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new FinancialTransactionViewHandler(this));
    }

    protected void createNext() {
        $objectMap.put("next", next = new JButton());
        
        next.setName("next");
        next.setToolTipText(_("lima.ui.financialtransaction.nextfinancialperiod"));
        next.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__next"));
    }

    protected void createSelectedRow() {
        $objectMap.put("selectedRow", selectedRow = false);
    }

    protected void createSelectionModel() {
        $objectMap.put("selectionModel", selectionModel = new DefaultListSelectionModel());
        
        selectionModel.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__selectionModel"));
    }

    protected void createTransactionInClipBoard() {
        $objectMap.put("transactionInClipBoard", transactionInClipBoard = false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $Table0
        add($JToolBar0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JScrollPane0, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JToolBar0
        $JToolBar0.add($JButton0);
        $JToolBar0.add($JButton1);
        $JToolBar0.add($JButton2);
        $JToolBar0.add($JButton3);
        $JToolBar0.add($JToolBar$Separator0);
        $JToolBar0.add($JButton4);
        $JToolBar0.add($JButton5);
        $JToolBar0.add($JButton6);
        $JToolBar0.add($JButton7);
        $JToolBar0.add($JButton8);
        $JToolBar0.add($JToolBar$Separator1);
        $JToolBar0.add($JButton9);
        $JToolBar0.add($JToolBar$Separator2);
        $JToolBar0.add($JLabel0);
        $JToolBar0.add(fiscalPeriodComboBox);
        $JToolBar0.add($JLabel1);
        $JToolBar0.add(financialPeriodComboBox);
        $JToolBar0.add(back);
        $JToolBar0.add(next);
        $JToolBar0.add($JToolBar$Separator3);
        $JToolBar0.add($JLabel2);
        $JToolBar0.add(entryBookComboBox);
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(financialTransactionTable);
        
        // apply 9 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 37 property setters
        selectionModel.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        $JButton0.setIcon(SwingUtil.createActionIcon("add-financial-transaction"));
        $JButton0.setToolTipText( _("lima.entries.addTransaction") + " (Ctrl+Shift+N)");
        $JButton1.setIcon(SwingUtil.createActionIcon("delete-financial-transaction"));
        $JButton1.setToolTipText( _("lima.entries.remove.transaction") + " (Ctrl+Shift+Del)");
        $JButton2.setIcon(SwingUtil.createActionIcon("copy"));
        $JButton2.setToolTipText( _("lima.entries.copy.transaction") + " (Ctrl+Shift+C)");
        $JButton3.setIcon(SwingUtil.createActionIcon("paste"));
        $JButton3.setToolTipText( _("lima.entries.paste.transaction") + " (Ctrl+Shift+V)");
        $JButton4.setIcon(SwingUtil.createActionIcon("add-entry"));
        $JButton4.setToolTipText( _("lima.entries.addEntry") + " (Ctrl+N)");
        $JButton5.setIcon(SwingUtil.createActionIcon("delete-entry"));
        $JButton5.setToolTipText( _("lima.entries.remove.entry") + " (Ctrl+Del)");
        $JButton6.setIcon(SwingUtil.createActionIcon("copy"));
        $JButton6.setToolTipText( _("lima.entries.copy.entry") + " (Ctrl+Alt+C)");
        $JButton7.setIcon(SwingUtil.createActionIcon("paste"));
        $JButton7.setToolTipText( _("lima.entries.paste.entry") + " (Ctrl+Alt+V)");
        $JButton8.setIcon(SwingUtil.createActionIcon("assign-all-entries-in-transaction"));
        $JButton8.setToolTipText( _("lima.entries.assign.entries") + " (Ctrl+Alt+A)");
        $JButton9.setIcon(SwingUtil.createActionIcon("balance"));
        $JButton9.setToolTipText( _("lima.entries.balance") + " (Ctrl+B)");
        $JLabel0.setIcon(SwingUtil.createActionIcon("choose-fiscal-year"));
        $JLabel0.setLabelFor(fiscalPeriodComboBox);
        fiscalPeriodComboBox.setModel(fiscalPeriodComboBoxModel);
        fiscalPeriodComboBox.setRenderer(new org.chorem.lima.ui.common.FiscalPeriodListRenderer());
        $JLabel1.setIcon(SwingUtil.createActionIcon("choose-fiscal-period"));
        $JLabel1.setLabelFor(financialPeriodComboBox);
        financialPeriodComboBox.setModel(financialPeriodComboBoxModel);
        financialPeriodComboBox.setRenderer(new org.chorem.lima.ui.common.FinancialPeriodListRenderer());
        back.setIcon(SwingUtil.createActionIcon("previous"));
        next.setIcon(SwingUtil.createActionIcon("next"));
        $JLabel2.setIcon(SwingUtil.createActionIcon("choose-book"));
        $JLabel2.setLabelFor(entryBookComboBox);
        entryBookComboBox.setModel(entryBookComboBoxModel);
        entryBookComboBox.setRenderer(new org.chorem.lima.ui.common.EntryBookListRenderer());
        financialTransactionTable.setModel(financialTransactionTableModel);
        financialTransactionTable.setSelectionModel(selectionModel);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$Table0", $Table0);
        createHandler();
        createSelectionModel();
        createSelectedRow();
        createTransactionInClipBoard();
        createEntryInClipBoard();
        createBalance();
        createAssignableInAllEntries();
        // inline creation of $JToolBar0
        $objectMap.put("$JToolBar0", $JToolBar0 = new JToolBar());
        
        $JToolBar0.setName("$JToolBar0");
        $JToolBar0.setFloatable(false);
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        // inline creation of $JButton2
        $objectMap.put("$JButton2", $JButton2 = new JButton());
        
        $JButton2.setName("$JButton2");
        $JButton2.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton2"));
        // inline creation of $JButton3
        $objectMap.put("$JButton3", $JButton3 = new JButton());
        
        $JButton3.setName("$JButton3");
        $JButton3.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton3"));
        // inline creation of $JToolBar$Separator0
        $objectMap.put("$JToolBar$Separator0", $JToolBar$Separator0 = new Separator());
        
        $JToolBar$Separator0.setName("$JToolBar$Separator0");
        // inline creation of $JButton4
        $objectMap.put("$JButton4", $JButton4 = new JButton());
        
        $JButton4.setName("$JButton4");
        $JButton4.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton4"));
        // inline creation of $JButton5
        $objectMap.put("$JButton5", $JButton5 = new JButton());
        
        $JButton5.setName("$JButton5");
        $JButton5.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton5"));
        // inline creation of $JButton6
        $objectMap.put("$JButton6", $JButton6 = new JButton());
        
        $JButton6.setName("$JButton6");
        $JButton6.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton6"));
        // inline creation of $JButton7
        $objectMap.put("$JButton7", $JButton7 = new JButton());
        
        $JButton7.setName("$JButton7");
        $JButton7.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton7"));
        // inline creation of $JButton8
        $objectMap.put("$JButton8", $JButton8 = new JButton());
        
        $JButton8.setName("$JButton8");
        $JButton8.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton8"));
        // inline creation of $JToolBar$Separator1
        $objectMap.put("$JToolBar$Separator1", $JToolBar$Separator1 = new Separator());
        
        $JToolBar$Separator1.setName("$JToolBar$Separator1");
        // inline creation of $JButton9
        $objectMap.put("$JButton9", $JButton9 = new JButton());
        
        $JButton9.setName("$JButton9");
        $JButton9.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton9"));
        // inline creation of $JToolBar$Separator2
        $objectMap.put("$JToolBar$Separator2", $JToolBar$Separator2 = new Separator());
        
        $JToolBar$Separator2.setName("$JToolBar$Separator2");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        createFiscalPeriodComboBoxModel();
        createFiscalPeriodComboBox();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        createFinancialPeriodComboBoxModel();
        createFinancialPeriodComboBox();
        createBack();
        createNext();
        // inline creation of $JToolBar$Separator3
        $objectMap.put("$JToolBar$Separator3", $JToolBar$Separator3 = new Separator());
        
        $JToolBar$Separator3.setName("$JToolBar$Separator3");
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        createEntryBookComboBoxModel();
        createEntryBookComboBox();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createFinancialTransactionTableModel();
        createFinancialTransactionTable();
        // inline creation of $Table0
        setName("$Table0");
        
        // registers 9 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 9 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON1_ENABLED, true ,"selectedRow") {
        
            @Override
            public void processDataBinding() {
                $JButton1.setEnabled(isSelectedRow());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON2_ENABLED, true ,"selectedRow") {
        
            @Override
            public void processDataBinding() {
                $JButton2.setEnabled(isSelectedRow());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON3_ENABLED, true ,"transactionInClipBoard") {
        
            @Override
            public void processDataBinding() {
                $JButton3.setEnabled(isTransactionInClipBoard());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON4_ENABLED, true ,"selectedRow") {
        
            @Override
            public void processDataBinding() {
                $JButton4.setEnabled(isSelectedRow());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON5_ENABLED, true ,"selectedRow") {
        
            @Override
            public void processDataBinding() {
                $JButton5.setEnabled(isSelectedRow());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON6_ENABLED, true ,"selectedRow") {
        
            @Override
            public void processDataBinding() {
                $JButton6.setEnabled(isSelectedRow());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON7_ENABLED, true ,"entryInClipBoard" ,"selectedRow") {
        
            @Override
            public void processDataBinding() {
                $JButton7.setEnabled(isEntryInClipBoard() && isSelectedRow());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON8_ENABLED, true ,"assignableInAllEntries" ,"selectedRow") {
        
            @Override
            public void processDataBinding() {
                $JButton8.setEnabled(isAssignableInAllEntries() && isSelectedRow());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON9_ENABLED, true ,"balance") {
        
            @Override
            public void processDataBinding() {
                $JButton9.setEnabled(!isBalance());
            }
        });
    }

}