/*
 * #%L
 * Lima Swing
 * 
 * $Id: FinancialStatementReportTableCellRenderer.java 3293 2011-09-17 14:17:04Z tchemit $
 * $HeadURL: https://svn.chorem.org/lima/tags/lima-0.7.1/lima-swing/src/main/java/org/chorem/lima/ui/financialstatementreport/FinancialStatementReportTableCellRenderer.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.ui.financialstatementreport;

import org.chorem.lima.LimaConfig;
import org.chorem.lima.LimaContext;
import org.chorem.lima.beans.FinancialStatementAmounts;

import javax.swing.JTable;
import javax.swing.SwingConstants;
import javax.swing.table.DefaultTableCellRenderer;
import java.awt.Component;
import java.awt.Font;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;


/**
 * Permet de modifier l'apparence du tableau pour le bilan à l'actif
 *
 * @author Rémi Chapelet
 */

public class FinancialStatementReportTableCellRenderer extends DefaultTableCellRenderer {

    private static final long serialVersionUID = 4682358397738816778L;

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value,
                                                   boolean isSelected, boolean hasFocus, int row, int column) {

        // Get table
        FinancialStatementReportTableModel financialStatementReportTableModel = (FinancialStatementReportTableModel) table.getModel();

        // Récupère le bilan de la ligne
        Object object = financialStatementReportTableModel.getElementAt(row);
        Component cell = super.getTableCellRendererComponent(
                table, value, isSelected, hasFocus, row, column);

        // Si le bilan est un soustotal, alors la ligne est en gras
        if (object instanceof FinancialStatementAmounts) {
            FinancialStatementAmounts financialStatementAmounts = (FinancialStatementAmounts) object;

            if (financialStatementAmounts.getLevel() == 1) {
                setFont(new Font("Verdana", Font.BOLD, 14));
            }

            if (financialStatementAmounts.getHeader()) {
                setFont(new Font("Verdana", Font.BOLD, 12));
            }
            if (!financialStatementAmounts.getHeader() && !financialStatementAmounts.getSubAmount()) {
                if (column == 0) {
                    cell.setFont(new Font("Verdana", Font.ITALIC, 12));
                }
            }
        }

        if (object instanceof BigDecimal) {
            setHorizontalAlignment(SwingConstants.LEFT);
            setValue(value);
        }

        return this;
    }

    public void setValue(Object aValue) {
        Object result = aValue;
        if (aValue != null && aValue instanceof BigDecimal) {
            LimaConfig config = LimaContext.getContext().getConfig();
            String scale = "";
            for (int i = 0; i < config.getScale(); i++) {
                scale += "0";
            }
            DecimalFormat formatter = new DecimalFormat("##0." + scale);
            DecimalFormatSymbols symbol = new DecimalFormatSymbols();
            symbol.setDecimalSeparator(config.getDecimalSeparator());
            symbol.setGroupingSeparator(config.getThousandSeparator());
            formatter.setDecimalFormatSymbols(symbol);
            formatter.setGroupingUsed(true);
            formatter.setGroupingSize(3);
            result = formatter.format(result);
        }
        super.setValue(result);
    }

}
