package org.chorem.lima.ui.celleditor;

/*
 * #%L
 * Lima :: Swing
 * $Id: AccountTableCellRenderer.java 3721 2013-12-31 15:03:48Z sbavencoff $
 * $HeadURL: https://svn.chorem.org/lima/tags/lima-0.7.1/lima-swing/src/main/java/org/chorem/lima/ui/celleditor/AccountTableCellRenderer.java $
 * %%
 * Copyright (C) 2008 - 2013 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import org.chorem.lima.entity.Account;

/**
 * @author Sylvain Bavencoff <bavencoff@codelutin.com>
 */
public class AccountTableCellRenderer extends DefaultLimaTableCellRenderer {

    @Override
    public void setValue(Object value) {
        Object result = value;
        if (value != null && value instanceof Account) {
            Account account = (Account) value;
            result = account.getAccountNumber() + " - " + account.getLabel();
        }
        super.setValue(result);
    }

}
