package org.chorem.android.saymytexts;

/*
 * #%L
 * Say My Texts
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.media.AudioManager;
import android.media.ToneGenerator;
import android.net.Uri;
import android.os.Bundle;
import android.speech.RecognitionListener;
import android.speech.RecognizerIntent;
import android.speech.SpeechRecognizer;
import android.telephony.SmsManager;
import android.util.Log;

import java.util.List;

/**
 * @author Kevin Morin (Code Lutin)
 * @since x.x
 */
public class SayNextActionBroadcastReceiver extends BroadcastReceiver {

    private static final String TAG = "SayNextActionBroadcastReceiver";

    public static final String ACTION_SAY_NEXT_ACTION = "org.chorem.android.saymytexts.SAY_NEXT_ACTION";

    public static final String INTENT_EXTRA_SMS = "sms";
    public static final String INTENT_EXTRA_MESSAGE = "message";
    public static final String INTENT_EXTRA_ATTEMPT_NUMBER = "attemptNumber";
    public static final String INTENT_EXTRA_FALLBACK_ACTION = "fallbackAction";

    @Override
    public void onReceive(final Context context, final Intent intent) {
        Log.d(TAG, "next action ?");
        final SMS sms = (SMS) intent.getSerializableExtra(INTENT_EXTRA_SMS);

        if (sms != null) {
            SpeechRecognizer speechRecognizer = SpeechRecognizer.createSpeechRecognizer(context);
            speechRecognizer.setRecognitionListener(new RecognitionListener() {

                private ToneGenerator tg = new ToneGenerator(AudioManager.STREAM_VOICE_CALL, ToneGenerator.MAX_VOLUME);

                @Override
                public void onReadyForSpeech(Bundle params) {
                }

                @Override
                public void onBeginningOfSpeech() {
                }

                @Override
                public void onRmsChanged(float rmsdB) {
                }

                @Override
                public void onBufferReceived(byte[] buffer) {}

                @Override
                public void onEndOfSpeech() {}

                @Override
                public void onError(int error) {
                    Log.d(TAG, "onError " + error);
                    tg.startTone(ToneGenerator.TONE_PROP_NACK);
                    reaskAction(context, intent, sms);
                }

                @Override
                public void onResults(Bundle data) {
                    List<String> results = data.getStringArrayList(SpeechRecognizer.RESULTS_RECOGNITION);

                    Log.d(TAG, "results " + results);
                    if (results != null) {

                        if (results.contains(context.getString(R.string.call_action))) {
                            try {
                                Intent callIntent = new Intent(Intent.ACTION_CALL);
                                callIntent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                                callIntent.setData(Uri.parse("tel:" + sms.getSenderNumber()));
                                context.startActivity(callIntent);

                            } catch (ActivityNotFoundException activityException) {
                                Log.e(TAG, "Calling a Phone Number failed", activityException);
                                tg.startTone(ToneGenerator.TONE_PROP_NACK);
                                readNext(context);
                            }

                        } else if (results.contains(context.getString(R.string.answer_action))
                                || results.contains(context.getString(R.string.modifiy_action))) {
                            Log.d(TAG, "Répondre ou corriger");

                            Intent serviceIntent = new Intent(context, SayMyTextService.class);
                            serviceIntent.setAction(SayMyTextService.ACTION_DICTATE_SMS);
                            serviceIntent.putExtra(SayMyTextService.INTENT_EXTRA_SMS, sms);
                            context.startService(serviceIntent);

                        } else if (results.contains(context.getString(R.string.confirm_action))) {
                            String message = intent.getStringExtra(INTENT_EXTRA_MESSAGE);
                            SmsManager smsManager = SmsManager.getDefault();
                            smsManager.sendTextMessage(sms.getSenderNumber(), null, message, null, null);

                            tg.startTone(ToneGenerator.TONE_PROP_ACK);

                            readNext(context);

                        } else if (results.contains(context.getString(R.string.quit_action))
                                || results.contains(context.getString(R.string.cancel_action))) {
                            // do nothing
                            Log.d(TAG, "Quitter");
                            tg.startTone(ToneGenerator.TONE_PROP_ACK);

                            readNext(context);

                        } else {
                            tg.startTone(ToneGenerator.TONE_PROP_NACK);
                            reaskAction(context, intent, sms);
                        }

                    } else {
                        tg.startTone(ToneGenerator.TONE_PROP_NACK);
                        reaskAction(context, intent, sms);
                    }
                }

                @Override
                public void onPartialResults(Bundle partialResults) {}

                @Override
                public void onEvent(int eventType, Bundle params) {}
            });

            Intent recognizeIntent = new Intent(RecognizerIntent.ACTION_RECOGNIZE_SPEECH);
            // Specify free form input
            recognizeIntent.putExtra(RecognizerIntent.EXTRA_LANGUAGE_MODEL,
                                     RecognizerIntent.LANGUAGE_MODEL_FREE_FORM);

            speechRecognizer.startListening(recognizeIntent);
        }
    }

    protected void reaskAction(Context context, Intent intent, SMS sms) {
        int attemptNumber = intent.getIntExtra(INTENT_EXTRA_ATTEMPT_NUMBER, 1);
        String fallbackAction = intent.getStringExtra(INTENT_EXTRA_FALLBACK_ACTION);
        String dictatedMessage = intent.getStringExtra(INTENT_EXTRA_MESSAGE);

        Intent serviceIntent = new Intent(context, SayMyTextService.class);
        serviceIntent.setAction(fallbackAction);
        serviceIntent.putExtra(SayMyTextService.INTENT_EXTRA_SMS, sms);
        serviceIntent.putExtra(SayMyTextService.INTENT_EXTRA_ATTEMPT_NUMBER, attemptNumber);
        serviceIntent.putExtra(SayMyTextService.INTENT_EXTRA_DICTATED_MESSAGE, dictatedMessage);
        context.startService(serviceIntent);
    }

    protected void readNext(Context context) {
        Intent serviceIntent = new Intent(context, SayMyTextService.class);
        serviceIntent.setAction(SayMyTextService.ACTION_READ_NEXT_SMS);
        context.startService(serviceIntent);
    }
}
