/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.operator.bc;

import org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.GOST3411Digest;
import org.bouncycastle.crypto.digests.MD2Digest;
import org.bouncycastle.crypto.digests.MD4Digest;
import org.bouncycastle.crypto.digests.MD5Digest;
import org.bouncycastle.crypto.digests.RIPEMD128Digest;
import org.bouncycastle.crypto.digests.RIPEMD160Digest;
import org.bouncycastle.crypto.digests.RIPEMD256Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.digests.SHA224Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.SHA384Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.operator.OperatorCreationException;

class BcUtil {
    BcUtil() {
    }

    static Digest createDigest(AlgorithmIdentifier algorithmIdentifier) throws OperatorCreationException {
        SHA1Digest sHA1Digest;
        if (algorithmIdentifier.getAlgorithm().equals((Object)OIWObjectIdentifiers.idSHA1)) {
            sHA1Digest = new SHA1Digest();
        } else if (algorithmIdentifier.getAlgorithm().equals((Object)NISTObjectIdentifiers.id_sha224)) {
            sHA1Digest = new SHA224Digest();
        } else if (algorithmIdentifier.getAlgorithm().equals((Object)NISTObjectIdentifiers.id_sha256)) {
            sHA1Digest = new SHA256Digest();
        } else if (algorithmIdentifier.getAlgorithm().equals((Object)NISTObjectIdentifiers.id_sha384)) {
            sHA1Digest = new SHA384Digest();
        } else if (algorithmIdentifier.getAlgorithm().equals((Object)NISTObjectIdentifiers.id_sha512)) {
            sHA1Digest = new SHA512Digest();
        } else if (algorithmIdentifier.getAlgorithm().equals((Object)PKCSObjectIdentifiers.md5)) {
            sHA1Digest = new MD5Digest();
        } else if (algorithmIdentifier.getAlgorithm().equals((Object)PKCSObjectIdentifiers.md4)) {
            sHA1Digest = new MD4Digest();
        } else if (algorithmIdentifier.getAlgorithm().equals((Object)PKCSObjectIdentifiers.md2)) {
            sHA1Digest = new MD2Digest();
        } else if (algorithmIdentifier.getAlgorithm().equals((Object)CryptoProObjectIdentifiers.gostR3411)) {
            sHA1Digest = new GOST3411Digest();
        } else if (algorithmIdentifier.getAlgorithm().equals((Object)TeleTrusTObjectIdentifiers.ripemd128)) {
            sHA1Digest = new RIPEMD128Digest();
        } else if (algorithmIdentifier.getAlgorithm().equals((Object)TeleTrusTObjectIdentifiers.ripemd160)) {
            sHA1Digest = new RIPEMD160Digest();
        } else if (algorithmIdentifier.getAlgorithm().equals((Object)TeleTrusTObjectIdentifiers.ripemd256)) {
            sHA1Digest = new RIPEMD256Digest();
        } else {
            throw new OperatorCreationException("cannot recognise digest");
        }
        return sHA1Digest;
    }
}

