/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.derivative.impl;

import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayU8;

public class GradientTwo0_Standard {
    public static void process(GrayF32 orig, GrayF32 derivX, GrayF32 derivY) {
        float[] data = orig.data;
        float[] imgX = derivX.data;
        float[] imgY = derivY.data;
        int width = orig.getWidth();
        int height = orig.getHeight() - 1;
        int stride = orig.stride;
        for (int y = 0; y < height; ++y) {
            int indexSrc;
            int indexX = derivX.startIndex + derivX.stride * y;
            int indexY = derivY.startIndex + derivY.stride * y;
            int endX = indexSrc + width - 1;
            for (indexSrc = orig.startIndex + orig.stride * y; indexSrc < endX; ++indexSrc) {
                float val = data[indexSrc];
                imgX[indexX++] = data[indexSrc + 1] - val;
                imgY[indexY++] = data[indexSrc + stride] - val;
            }
        }
    }

    public static void process(GrayU8 orig, GrayS16 derivX, GrayS16 derivY) {
        byte[] data = orig.data;
        short[] imgX = derivX.data;
        short[] imgY = derivY.data;
        int width = orig.getWidth();
        int height = orig.getHeight() - 1;
        int stride = orig.stride;
        for (int y = 0; y < height; ++y) {
            int indexSrc;
            int indexX = derivX.startIndex + derivX.stride * y;
            int indexY = derivY.startIndex + derivY.stride * y;
            int endX = indexSrc + width - 1;
            for (indexSrc = orig.startIndex + stride * y; indexSrc < endX; ++indexSrc) {
                int val = data[indexSrc] & 0xFF;
                imgX[indexX++] = (short)((data[indexSrc + 1] & 0xFF) - val);
                imgY[indexY++] = (short)((data[indexSrc + stride] & 0xFF) - val);
            }
        }
    }

    public static void process(GrayS16 orig, GrayS16 derivX, GrayS16 derivY) {
        short[] data = orig.data;
        short[] imgX = derivX.data;
        short[] imgY = derivY.data;
        int width = orig.getWidth();
        int height = orig.getHeight() - 1;
        int stride = orig.stride;
        for (int y = 0; y < height; ++y) {
            int indexSrc;
            int indexX = derivX.startIndex + derivX.stride * y;
            int indexY = derivY.startIndex + derivY.stride * y;
            int endX = indexSrc + width - 1;
            for (indexSrc = orig.startIndex + stride * y; indexSrc < endX; ++indexSrc) {
                short val = data[indexSrc];
                imgX[indexX++] = (short)(data[indexSrc + 1] - val);
                imgY[indexY++] = (short)(data[indexSrc + stride] - val);
            }
        }
    }
}

