/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.color;

public class ColorDifference {
    static final int l = 0;
    static final int a = 1;
    static final int b = 2;

    public static double deltaECIE76(double[] lab1, double[] lab2) {
        return ColorDifference.deltaECIE76(lab1[0], lab1[1], lab1[2], lab2[0], lab2[1], lab2[2]);
    }

    public static double deltaECIE76(double l1, double a1, double b1, double l2, double a2, double b2) {
        double p1 = l1 - l2;
        double p2 = a1 - a2;
        double p3 = b1 - b2;
        return Math.sqrt(p1 * p1 + p2 * p2 + p3 * p3);
    }

    public static double deltaECIE94(double[] lab1, double[] lab2, double KL, double KC, double KH, double K1, double K2) {
        return ColorDifference.deltaECIE94(lab1[0], lab1[1], lab1[2], lab2[0], lab2[1], lab2[2], KL, KC, KH, K1, K2);
    }

    public static double deltaECIE94(double l1, double a1, double b1, double l2, double a2, double b2, double KL, double KC, double KH, double K1, double K2) {
        double deltaL = l1 - l2;
        double deltaA = a1 - a2;
        double deltaB = b1 - b2;
        double C1 = Math.sqrt(a1 * a1 + b1 * b1);
        double C2 = Math.sqrt(a2 * a2 + b2 * b2);
        double deltaC = C1 - C2;
        double deltaH = deltaA * deltaA + deltaB * deltaB - deltaC * deltaC;
        double SL = 1.0;
        double SC = 1.0 + K1 * C1;
        double SH = 1.0 + K2 * C1;
        double p1 = deltaL / (KL * SL);
        double p2 = deltaC / (KC * SC);
        double p3 = 1.0 / (KH * SH);
        return Math.sqrt(p1 * p1 + p2 * p2 + deltaH * p3 * p3);
    }

    public static double deltaECIE94(double[] lab1, double[] lab2) {
        return ColorDifference.deltaECIE94(lab1[0], lab1[1], lab1[2], lab2[0], lab2[1], lab2[2]);
    }

    public static double deltaECIE94(double l1, double a1, double b1, double l2, double a2, double b2) {
        return ColorDifference.deltaECIE94(l1, a1, b1, l2, a2, b2, 1.0, 1.0, 1.0, 0.045, 0.015);
    }

    public static double deltaECIEDE2000(double[] lab1, double[] lab2) {
        return ColorDifference.deltaECIEDE2000(lab1[0], lab1[1], lab1[2], lab2[0], lab2[1], lab2[2]);
    }

    public static double deltaECIEDE2000(double l1, double a1, double b1, double l2, double a2, double b2) {
        double C1 = Math.sqrt(a1 * a1 + b1 * b1);
        double C2 = Math.sqrt(a2 * a2 + b2 * b2);
        double avgC = (C1 + C2) / 2.0;
        double p = avgC * avgC * avgC * avgC * avgC * avgC * avgC;
        double G = 0.5 * (1.0 - Math.sqrt(p / (p + 6.103515625E9)));
        double a1p = a1 * (1.0 + G);
        double a2p = a2 * (1.0 + G);
        double C1p = Math.sqrt(a1p * a1p + b1 * b1);
        double C2p = Math.sqrt(a2p * a2p + b2 * b2);
        double h1p = 0.0;
        if ((b1 != 0.0 || a1p != 0.0) && (h1p = Math.toDegrees(Math.atan2(b1, a1p))) < 0.0) {
            h1p += 360.0;
        }
        double h2p = 0.0;
        if ((b2 != 0.0 || a2p != 0.0) && (h2p = Math.toDegrees(Math.atan2(b2, a2p))) < 0.0) {
            h2p += 360.0;
        }
        double deltaLp = l2 - l1;
        double deltaCp = C2p - C1p;
        double deltahp = 0.0;
        if (C1p * C2p != 0.0) {
            deltahp = Math.abs(h2p - h1p) <= 180.0 ? h2p - h1p : (h2p - h1p > 180.0 ? h2p - h1p - 360.0 : h2p - h1p + 360.0);
        }
        double deltaHp = 2.0 * Math.sqrt(C1p * C2p) * Math.sin(Math.toRadians(deltahp / 2.0));
        double avgLp = (l1 + l2) / 2.0;
        double avgCp = (C1p + C2p) / 2.0;
        double avghp = 0.0;
        if (C1p * C2p != 0.0) {
            if (Math.abs(h1p - h2p) <= 180.0) {
                avghp = (h1p + h2p) / 2.0;
            } else if (h1p + h2p < 360.0) {
                avghp = (h1p + h2p + 360.0) / 2.0;
            } else if (h1p + h2p >= 360.0) {
                avghp = (h1p + h2p - 360.0) / 2.0;
            }
        }
        double T = 1.0 - 0.17 * Math.cos(Math.toRadians(avghp - 30.0)) + 0.24 * Math.cos(Math.toRadians(2.0 * avghp)) + 0.32 * Math.cos(Math.toRadians(3.0 * avghp + 6.0)) - 0.2 * Math.cos(Math.toRadians(4.0 * avghp - 63.0));
        p = (avghp - 275.0) / 25.0;
        double deltaTheta = 30.0 * Math.exp(-p * p);
        p = avgCp * avgCp * avgCp * avgCp * avgCp * avgCp * avgCp;
        double RC = 2.0 * Math.sqrt(p / (p + 6.103515625E9));
        p = avgLp - 50.0;
        double SL = 1.0 + 0.015 * p * p / Math.sqrt(20.0 + p * p);
        double SC = 1.0 + 0.045 * avgCp;
        double SH = 1.0 + 0.015 * avgCp * T;
        double RT = -RC * Math.sin(Math.toRadians(2.0 * deltaTheta));
        double KL = 1.0;
        double KC = 1.0;
        double KH = 1.0;
        double p1 = deltaLp / (KL * SL);
        double p2 = deltaCp / (KC * SC);
        double p3 = deltaHp / (KH * SH);
        return Math.sqrt(p1 * p1 + p2 * p2 + p3 * p3 + RT * (deltaCp / (KC * SC)) * (deltaHp / (KH * SH)));
    }

    public static double deltaECMC(double[] lab1, double[] lab2, double lightness, double chroma) {
        return ColorDifference.deltaECMC(lab1[0], lab1[1], lab1[2], lab2[0], lab2[1], lab2[2], lightness, chroma);
    }

    public static double deltaECMC(double l1, double a1, double b1, double l2, double a2, double b2, double lightness, double chroma) {
        double H;
        double C1 = Math.sqrt(a1 * a1 + b1 * b1);
        double C2 = Math.sqrt(a2 * a2 + b2 * b2);
        double deltaC = C1 - C2;
        double deltaL = l1 - l2;
        double deltaA = a1 - a2;
        double deltaB = b1 - b2;
        double deltaH = deltaA * deltaA + deltaB * deltaB - deltaC * deltaC;
        double SL = 0.511;
        if (l1 >= 16.0) {
            SL = 0.040975 * l1 / (1.0 + 0.01765 * l1);
        }
        double SC = 0.0638 * C1 / (1.0 + 0.0131 * C1) + 0.638;
        double H1 = H = Math.toDegrees(Math.atan2(b1, a1));
        if (H < 0.0) {
            H1 += 360.0;
        }
        double p = C1 * C1 * C1 * C1;
        double F = Math.sqrt(p / (p + 1900.0));
        double T = H1 <= 345.0 && H1 >= 164.0 ? 0.56 + Math.abs(0.2 * Math.cos(Math.toRadians(H1 + 168.0))) : 0.36 + Math.abs(0.4 * Math.cos(Math.toRadians(H1 + 35.0)));
        double SH = SC * (F * T + 1.0 - F);
        double p1 = deltaL / (lightness * SL);
        double p2 = deltaC / (chroma * SC);
        double p3 = 1.0 / SH;
        return Math.sqrt(p1 * p1 + p2 * p2 + deltaH * p3 * p3);
    }

    public static double deltaECMC(double[] lab1, double[] lab2) {
        return ColorDifference.deltaECMC(lab1[0], lab1[1], lab1[2], lab2[0], lab2[1], lab2[2]);
    }

    public static double deltaECMC(double l1, double a1, double b1, double l2, double a2, double b2) {
        return ColorDifference.deltaECMC(l1, a1, b1, l2, a2, b2, 1.0, 1.0);
    }
}

