/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.geometry;

import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.biojava.nbio.structure.geometry.CalcPoint;
import org.biojava.nbio.structure.geometry.Matrices;
import org.biojava.nbio.structure.geometry.SuperPositionAbstract;
import org.biojava.nbio.structure.jama.Matrix;
import org.biojava.nbio.structure.jama.SingularValueDecomposition;

public class SuperPositionSVD
extends SuperPositionAbstract {
    public SuperPositionSVD(boolean centered) {
        super(centered);
    }

    @Override
    public Matrix4d superpose(Point3d[] fixed, Point3d[] moved) {
        this.checkInput(fixed, moved);
        Point3d cena = CalcPoint.centroid(fixed);
        Point3d cenb = CalcPoint.centroid(moved);
        double[][] centAcoords = new double[][]{{cena.x, cena.y, cena.z}};
        Matrix centroidA = new Matrix(centAcoords);
        double[][] centBcoords = new double[][]{{cenb.x, cenb.y, cenb.z}};
        Matrix centroidB = new Matrix(centBcoords);
        cena.negate();
        cenb.negate();
        Point3d[] ats1 = CalcPoint.clonePoint3dArray(fixed);
        CalcPoint.translate(new Vector3d((Tuple3d)cena), ats1);
        Point3d[] ats2 = CalcPoint.clonePoint3dArray(moved);
        CalcPoint.translate(new Vector3d((Tuple3d)cenb), ats2);
        double[][] coordSet1 = new double[ats1.length][3];
        double[][] coordSet2 = new double[ats2.length][3];
        for (int i = 0; i < ats1.length; ++i) {
            coordSet1[i] = new double[3];
            ats1[i].get(coordSet1[i]);
            coordSet2[i] = new double[3];
            ats2[i].get(coordSet2[i]);
        }
        Matrix a = new Matrix(coordSet1);
        Matrix b = new Matrix(coordSet2);
        Matrix b_trans = b.transpose();
        Matrix corr = b_trans.times(a);
        SingularValueDecomposition svd = corr.svd();
        Matrix u = svd.getU();
        Matrix vt = svd.getV();
        Matrix vt_orig = (Matrix)vt.clone();
        Matrix u_transp = u.transpose();
        Matrix rot_nottrans = vt.times(u_transp);
        Matrix rot = rot_nottrans.transpose();
        double det = rot.det();
        if (det < 0.0) {
            vt = vt_orig.transpose();
            vt.set(2, 0, 0.0 - vt.get(2, 0));
            vt.set(2, 1, 0.0 - vt.get(2, 1));
            vt.set(2, 2, 0.0 - vt.get(2, 2));
            Matrix nv_transp = vt.transpose();
            rot_nottrans = nv_transp.times(u_transp);
            rot = rot_nottrans.transpose();
        }
        Matrix cb_tmp = centroidB.times(rot);
        Matrix tran = centroidA.minus(cb_tmp);
        return Matrices.getTransformation(rot, tran);
    }

    @Override
    public double getRmsd(Point3d[] x, Point3d[] y) {
        Point3d[] yclone = CalcPoint.clonePoint3dArray(y);
        this.superposeAndTransform(x, yclone);
        return CalcPoint.rmsd(x, yclone);
    }
}

