/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.common.model.multipart;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.ws.rs.ext.Providers;
import org.apache.wink.common.RestException;
import org.apache.wink.common.internal.providers.multipart.MultiPartParser;
import org.apache.wink.common.model.multipart.InPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InMultiPart
implements Iterator<InPart> {
    public static final String SEP = "\n";
    private MultiPartParser MPParser;
    int index = -1;
    boolean moved = false;
    boolean lastMoveResult = true;
    private Providers providers;

    public Providers getProviders() {
        return this.providers;
    }

    public void setProviders(Providers providers) {
        this.providers = providers;
    }

    public InMultiPart(MultiPartParser mim) {
        this.MPParser = mim;
    }

    @Override
    public boolean hasNext() {
        if (!this.moved) {
            try {
                this.lastMoveResult = this.MPParser.nextPart();
            }
            catch (IOException e) {
                throw new RestException(e);
            }
            this.moved = true;
            ++this.index;
        }
        return this.lastMoveResult;
    }

    @Override
    public InPart next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.moved = false;
        InPart ip = new InPart();
        ip.setHeaders(this.MPParser.getPartHeaders());
        ip.setInputStream(this.MPParser.getPartBodyStream());
        ip.setProviders(this.providers);
        return ip;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

