/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.common.internal.providers.entity.xml;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.SoftReference;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Providers;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRegistry;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.wink.common.RuntimeContext;
import org.apache.wink.common.internal.WinkConfiguration;
import org.apache.wink.common.internal.i18n.Messages;
import org.apache.wink.common.internal.runtime.RuntimeContextTLS;
import org.apache.wink.common.internal.utils.JAXBUtils;
import org.apache.wink.common.internal.utils.MediaTypeUtils;
import org.apache.wink.common.internal.utils.SoftConcurrentMap;
import org.apache.wink.common.model.JAXBUnmarshalOptions;
import org.apache.wink.common.model.XmlFormattingOptions;
import org.apache.wink.common.utils.ProviderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJAXBProvider {
    private static final Logger logger = LoggerFactory.getLogger(AbstractJAXBProvider.class);
    private static final SoftConcurrentMap<Class<?>, JAXBContext> jaxbDefaultContexts = new SoftConcurrentMap();
    @Context
    protected Providers providers;
    private static final SoftConcurrentMap<Class<?>, Boolean> jaxbIsXMLRootElementCache = new SoftConcurrentMap();
    private static final SoftConcurrentMap<Class<?>, Boolean> jaxbIsXMLTypeCache = new SoftConcurrentMap();
    private Pool<JAXBContext, Marshaller> mpool = new Pool();
    private Pool<JAXBContext, Unmarshaller> upool = new Pool();
    private static ThreadLocal<XMLInputFactory> xmlInputFactory = new ThreadLocal();
    private final SoftConcurrentMap<JAXBContextResolverKey, JAXBContext> jaxbContextCache = new SoftConcurrentMap();
    private static final String propVal = System.getProperty("org.apache.wink.jaxbcontextcache");
    protected static boolean contextCacheOn = propVal == null || !propVal.equalsIgnoreCase("off");

    protected final Unmarshaller getJAXBUnmarshaller(Class<?> type, JAXBContext context, MediaType mediaType) throws JAXBException {
        Unmarshaller unm = this.upool.get(context);
        if (unm == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Unmarshaller created [not in pool]");
            }
            unm = AbstractJAXBProvider.internalCreateUnmarshaller(context);
        } else if (logger.isDebugEnabled()) {
            logger.debug("Unmarshaller obtained [from  pool]");
        }
        if (this.providers != null) {
            ContextResolver contextResolver = this.providers.getContextResolver(JAXBUnmarshalOptions.class, mediaType);
            JAXBUnmarshalOptions options = null;
            if (contextResolver != null) {
                options = (JAXBUnmarshalOptions)contextResolver.getContext(type);
            }
            if (options != null) {
                JAXBUtils.setJAXBUnmarshalOptions(unm, options);
            }
        }
        return unm;
    }

    private static void checkForDTD(XMLStreamReader reader) throws XMLStreamException {
        boolean supportDTD = false;
        int event = reader.getEventType();
        if (event != 7) {
            throw new XMLStreamException(Messages.getMessage("badXMLReaderInitialStart"));
        }
        while (event != 1) {
            Properties props;
            event = reader.next();
            if (event != 11) continue;
            RuntimeContext runtimeContext = RuntimeContextTLS.getRuntimeContext();
            WinkConfiguration winkConfig = runtimeContext.getAttribute(WinkConfiguration.class);
            if (winkConfig != null && (props = winkConfig.getProperties()) != null) {
                supportDTD = Boolean.valueOf(props.getProperty("wink.supportDTDEntityExpansion"));
            }
            if (!supportDTD) {
                throw new XMLStreamException(Messages.getMessage("entityRefsNotSupported"));
            }
            logger.debug("DTD entity reference expansion is enabled.  This may present a security risk.");
        }
    }

    private static XMLInputFactory getXMLInputFactory() {
        XMLInputFactory factory = xmlInputFactory.get();
        if (factory == null) {
            factory = XMLInputFactory.newInstance();
            xmlInputFactory.set(factory);
        }
        return factory;
    }

    protected static XMLStreamReader getXMLStreamReader(InputStream entityStream) throws XMLStreamException {
        XMLStreamReader reader = AbstractJAXBProvider.getXMLInputFactory().createXMLStreamReader(entityStream);
        AbstractJAXBProvider.checkForDTD(reader);
        return reader;
    }

    protected static XMLStreamReader getXMLStreamReader(InputStreamReader entityStreamReader) throws XMLStreamException {
        XMLStreamReader reader = AbstractJAXBProvider.getXMLInputFactory().createXMLStreamReader(entityStreamReader);
        AbstractJAXBProvider.checkForDTD(reader);
        return reader;
    }

    protected static void closeXMLStreamReader(XMLStreamReader xmlStreamReader) {
        if (xmlStreamReader != null) {
            try {
                xmlStreamReader.close();
            }
            catch (XMLStreamException e) {
                logger.debug("XMLStreamReader already closed.", (Throwable)e);
            }
            catch (RuntimeException e) {
                logger.debug("RuntimeException occurred: ", (Throwable)e);
            }
        }
    }

    private static Unmarshaller internalCreateUnmarshaller(final JAXBContext context) throws JAXBException {
        Unmarshaller unm;
        try {
            unm = AccessController.doPrivileged(new PrivilegedExceptionAction<Unmarshaller>(){

                @Override
                public Unmarshaller run() throws JAXBException {
                    return context.createUnmarshaller();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (JAXBException)e.getCause();
        }
        return unm;
    }

    protected void releaseJAXBUnmarshaller(JAXBContext context, Unmarshaller unmarshaller) {
        if (logger.isDebugEnabled()) {
            logger.debug("Unmarshaller placed back into pool");
        }
        unmarshaller.setAttachmentUnmarshaller(null);
        this.upool.put(context, unmarshaller);
    }

    private static Marshaller internalCreateMarshaller(final JAXBContext context) throws JAXBException {
        Marshaller marshaller;
        try {
            marshaller = AccessController.doPrivileged(new PrivilegedExceptionAction<Marshaller>(){

                @Override
                public Marshaller run() throws JAXBException {
                    return context.createMarshaller();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (JAXBException)e.getCause();
        }
        return marshaller;
    }

    protected Marshaller getJAXBMarshaller(Class<?> type, JAXBContext context, MediaType mediaType) throws JAXBException {
        Marshaller m = this.mpool.get(context);
        if (m == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Marshaller created [not in pool]");
            }
            m = AbstractJAXBProvider.internalCreateMarshaller(context);
        } else if (logger.isDebugEnabled()) {
            logger.debug("Marshaller obtained [from  pool]");
        }
        m.setProperty("jaxb.encoding", (Object)ProviderUtils.getCharset(mediaType));
        ContextResolver contextResolver = this.providers.getContextResolver(XmlFormattingOptions.class, mediaType);
        XmlFormattingOptions formatingOptions = null;
        if (contextResolver != null) {
            formatingOptions = (XmlFormattingOptions)contextResolver.getContext(type);
        }
        if (formatingOptions != null) {
            JAXBUtils.setXmlFormattingOptions(m, formatingOptions);
        }
        return m;
    }

    protected void releaseJAXBMarshaller(JAXBContext context, Marshaller marshaller) {
        if (logger.isDebugEnabled()) {
            logger.debug("Marshaller placed back into pool");
        }
        marshaller.setAttachmentMarshaller(null);
        this.mpool.put(context, marshaller);
    }

    protected boolean isSupportedMediaType(MediaType mediaType) {
        return MediaTypeUtils.isXmlType(mediaType);
    }

    public static boolean isJAXBObject(Class<?> type, Type genericType) {
        if (AbstractJAXBProvider.isJAXBObject(type)) {
            return true;
        }
        if (genericType instanceof Class) {
            return AbstractJAXBProvider.isJAXBObject((Class)genericType);
        }
        return false;
    }

    public static boolean isJAXBObject(Class<?> type) {
        return AbstractJAXBProvider.isXMLRootElement(type) || AbstractJAXBProvider.isXMLType(type);
    }

    private static boolean isXMLRootElement(Class<?> type) {
        Boolean isJAXBObject = jaxbIsXMLRootElementCache.get(type);
        if (isJAXBObject == null) {
            boolean isXmlRootElement = type.getAnnotation(XmlRootElement.class) != null;
            isJAXBObject = isXmlRootElement;
            jaxbIsXMLRootElementCache.put(type, isJAXBObject);
        }
        return isJAXBObject;
    }

    private static boolean isXMLType(Class<?> type) {
        Boolean isJAXBObject = jaxbIsXMLTypeCache.get(type);
        if (isJAXBObject == null) {
            boolean isXmlTypeElement = type.getAnnotation(XmlType.class) != null;
            isJAXBObject = isXmlTypeElement;
            jaxbIsXMLTypeCache.put(type, isJAXBObject);
        }
        return isJAXBObject;
    }

    public static boolean isJAXBElement(Class<?> type, Type genericType) {
        return type == JAXBElement.class;
    }

    protected JAXBContext getContext(Class<?> type, MediaType mediaType) throws JAXBException {
        return this.getContext(type, type, mediaType);
    }

    protected JAXBContext getContext(Class<?> type, Type genericType, MediaType mediaType) throws JAXBException {
        ContextResolver contextResolver = this.providers.getContextResolver(JAXBContext.class, mediaType);
        JAXBContext context = null;
        JAXBContextResolverKey key = null;
        if (contextCacheOn && (context = this.jaxbContextCache.get(key = new JAXBContextResolverKey((ContextResolver<JAXBContext>)contextResolver, type))) != null) {
            return context;
        }
        if (contextResolver != null) {
            context = (JAXBContext)contextResolver.getContext(type);
        }
        if (context == null) {
            context = this.getDefaultContext(type, genericType);
        }
        if (contextCacheOn) {
            this.jaxbContextCache.put(key, context);
        }
        return context;
    }

    private JAXBContext getDefaultContext(Class<?> type, Type genericType) throws JAXBException {
        JAXBContext context = jaxbDefaultContexts.get(type);
        if (context == null) {
            context = !AbstractJAXBProvider.isXMLRootElement(type) && !AbstractJAXBProvider.isXMLType(type) ? JAXBContext.newInstance((Class[])new Class[]{(Class)genericType}) : JAXBContext.newInstance((Class[])new Class[]{type});
            jaxbDefaultContexts.put(type, context);
        }
        return context;
    }

    protected Object getEntityToMarshal(Object jaxbObject, Class<?> type) {
        if (!AbstractJAXBProvider.isXMLRootElement(type) && AbstractJAXBProvider.isXMLType(type)) {
            JAXBElement<?> wrappedJAXBElement = this.wrapInJAXBElement(jaxbObject, type);
            if (wrappedJAXBElement == null) {
                if (logger.isErrorEnabled()) {
                    logger.error(Messages.getMessage("jaxbObjectFactoryNotFound", type.getName()));
                }
                throw new WebApplicationException();
            }
            return wrappedJAXBElement;
        }
        return jaxbObject;
    }

    private JAXBElement<?> wrapInJAXBElement(Object jaxbObject, Class<?> type) {
        try {
            Object factory = null;
            Class<?> factoryClass = this.findDefaultObjectFactoryClass(type);
            if (factoryClass != null) {
                factory = factoryClass.newInstance();
                Method[] method = factory.getClass().getDeclaredMethods();
                for (int i = 0; i < method.length; ++i) {
                    Method current = method[i];
                    if (current.getParameterTypes().length != 1 || !current.getParameterTypes()[0].equals(type) || !current.getName().startsWith("create")) continue;
                    Object result = current.invoke(factory, jaxbObject);
                    return (JAXBElement)JAXBElement.class.cast(result);
                }
                return null;
            }
            if (logger.isWarnEnabled()) {
                logger.warn(Messages.getMessage("jaxbObjectFactoryInstantiate", type.getName()));
            }
            return this.defaultWrapInJAXBElement(jaxbObject, type);
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error(Messages.getMessage("jaxbElementFailToBuild", type.getName()));
            }
            return null;
        }
    }

    private Class<?> findDefaultObjectFactoryClass(Class<?> type) {
        StringBuilder b = new StringBuilder(type.getPackage().getName());
        b.append(".ObjectFactory");
        Class<?> factoryClass = null;
        try {
            factoryClass = Thread.currentThread().getContextClassLoader().loadClass(b.toString());
        }
        catch (ClassNotFoundException e) {
            if (logger.isErrorEnabled()) {
                logger.error(Messages.getMessage("jaxbObjectFactoryNotFound", type.getName()));
            }
            return null;
        }
        if (!factoryClass.isAnnotationPresent(XmlRegistry.class)) {
            if (logger.isErrorEnabled()) {
                logger.error(Messages.getMessage("jaxbObjectFactoryNotAnnotatedXMLRegistry", type.getName()));
            }
            return null;
        }
        return factoryClass;
    }

    private JAXBElement<?> defaultWrapInJAXBElement(Object jaxbObject, Class<?> type) {
        if (logger.isInfoEnabled()) {
            logger.info(Messages.getMessage("jaxbCreateDefaultJAXBElement", type.getName()));
        }
        String typeStr = type.getAnnotation(XmlType.class).name();
        return new JAXBElement(new QName(typeStr), type, jaxbObject);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Pool<K, V> {
        private SoftReference<ConcurrentHashMap<K, ArrayList<V>>> softMap = new SoftReference(new ConcurrentHashMap());
        private static int MAX_LOAD_FACTOR = 32;
        private static int MAX_LIST_FACTOR = 50;

        private Pool() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public V get(K key) {
            List<V> values;
            List<V> list = values = this.getValues(key);
            synchronized (list) {
                if (values.size() > 0) {
                    V v = values.remove(values.size() - 1);
                    return v;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(K key, V value) {
            List<V> values;
            this.adjustSize();
            List<V> list = values = this.getValues(key);
            synchronized (list) {
                if (values.size() < MAX_LIST_FACTOR) {
                    values.add(value);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<V> getValues(K key) {
            ConcurrentHashMap<K, ArrayList<ArrayList<V>>> map = this.softMap.get();
            ArrayList<Object> values = null;
            if (map != null && (values = map.get(key)) != null) {
                return values;
            }
            Pool pool = this;
            synchronized (pool) {
                if (map != null) {
                    values = map.get(key);
                }
                if (values == null) {
                    if (map == null) {
                        map = new ConcurrentHashMap();
                        this.softMap = new SoftReference<ConcurrentHashMap<K, ArrayList<V>>>(map);
                    }
                    values = new ArrayList();
                    map.put(key, values);
                }
                return values;
            }
        }

        private void adjustSize() {
            ConcurrentHashMap<K, ArrayList<V>> map = this.softMap.get();
            if (map != null && map.size() > MAX_LOAD_FACTOR) {
                Iterator<Map.Entry<K, ArrayList<V>>> it = map.entrySet().iterator();
                boolean removeIt = false;
                while (it.hasNext()) {
                    it.next();
                    if (removeIt) {
                        it.remove();
                    }
                    removeIt = !removeIt;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JAXBContextResolverKey {
        protected ContextResolver<JAXBContext> _resolver;
        protected Type _type;
        private int hashCode = -1;

        public JAXBContextResolverKey(ContextResolver<JAXBContext> resolver, Type type) {
            this._resolver = resolver;
            this._type = type;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof JAXBContextResolverKey)) {
                return false;
            }
            JAXBContextResolverKey obj = (JAXBContextResolverKey)o;
            boolean result = obj._resolver == null && this._resolver == null || obj._resolver != null && this._resolver != null;
            return result && obj.hashCode() == this.hashCode() && obj._type.equals(this._type);
        }

        public int hashCode() {
            if (this.hashCode != -1) {
                return this.hashCode;
            }
            if (this._resolver == null) {
                this.hashCode = 0;
                return this.hashCode;
            }
            String resolverName = this._resolver.getClass().getName();
            byte[] bytes = resolverName.getBytes();
            for (int i = 0; i < bytes.length; ++i) {
                this.hashCode += bytes[i];
            }
            return this.hashCode;
        }
    }
}

