/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.common.internal.providers.entity.csv;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.Iterator;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.RuntimeDelegate;
import org.apache.wink.common.internal.http.ContentDispositionHeader;
import org.apache.wink.common.internal.providers.entity.csv.CsvWriter;
import org.apache.wink.common.internal.utils.MediaTypeUtils;
import org.apache.wink.common.model.csv.CsvSerializer;
import org.apache.wink.common.utils.ProviderUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@Produces(value={"text/csv"})
public class CsvSerializerProvider
implements MessageBodyWriter<CsvSerializer> {
    public static final String CONTENT_DISPOSITION_HEADER = "Content-Disposition";
    private static final RuntimeDelegate.HeaderDelegate<ContentDispositionHeader> header = RuntimeDelegate.getInstance().createHeaderDelegate(ContentDispositionHeader.class);

    public long getSize(CsvSerializer t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return CsvSerializer.class.isAssignableFrom(type);
    }

    public void writeTo(CsvSerializer t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        ContentDispositionHeader contentDispositionHeader = ContentDispositionHeader.createContentDispositionHeader(MediaTypeUtils.CSV);
        contentDispositionHeader.setFileName("representation");
        httpHeaders.putSingle((Object)CONTENT_DISPOSITION_HEADER, (Object)header.toString((Object)contentDispositionHeader));
        Charset charset = Charset.forName(ProviderUtils.getCharset(mediaType));
        OutputStreamWriter writer = new OutputStreamWriter(entityStream, charset);
        PrintWriter printWriter = new PrintWriter(writer);
        Iterator<String[]> rows = t.getEntities();
        while (rows.hasNext()) {
            printWriter.println(CsvWriter.getCSVRow(rows.next()));
        }
        printWriter.flush();
    }
}

