/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.wizard;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.IClusterable;
import org.apache.wicket.extensions.wizard.AbstractWizardModel;
import org.apache.wicket.extensions.wizard.IWizardStep;
import org.apache.wicket.util.collections.ArrayListStack;

public class WizardModel
extends AbstractWizardModel {
    public static final ICondition TRUE = new ICondition(){
        private static final long serialVersionUID = 1L;

        public boolean evaluate() {
            return true;
        }
    };
    private static final long serialVersionUID = 1L;
    private IWizardStep activeStep;
    private List conditions = new ArrayList();
    private final ArrayListStack history = new ArrayListStack();
    private List steps = new ArrayList();

    public void add(IWizardStep step) {
        if (step instanceof ICondition) {
            this.add(step, (ICondition)((Object)step));
        } else {
            this.add(step, TRUE);
        }
    }

    public void add(IWizardStep step, ICondition condition) {
        this.steps.add(step);
        this.conditions.add(condition);
    }

    public final IWizardStep getActiveStep() {
        return this.activeStep;
    }

    public boolean isLastAvailable() {
        return this.allStepsComplete() && !this.isLastStep(this.activeStep);
    }

    public boolean isLastStep(IWizardStep step) {
        return this.findLastStep().equals(step);
    }

    public boolean isNextAvailable() {
        return this.activeStep.isComplete() && !this.isLastStep(this.activeStep);
    }

    public boolean isPreviousAvailable() {
        return !this.history.isEmpty();
    }

    public void last() {
        this.history.push((Object)this.getActiveStep());
        IWizardStep lastStep = this.findLastStep();
        this.setActiveStep(lastStep);
    }

    public void next() {
        this.history.push((Object)this.getActiveStep());
        IWizardStep step = this.findNextVisibleStep();
        this.setActiveStep(step);
    }

    public void previous() {
        IWizardStep step = (IWizardStep)this.history.pop();
        this.setActiveStep(step);
    }

    public void reset() {
        this.history.clear();
        this.activeStep = null;
        this.setActiveStep(this.findNextVisibleStep());
    }

    public void setActiveStep(IWizardStep step) {
        if (this.activeStep != null && step != null && this.activeStep.equals(step)) {
            return;
        }
        this.activeStep = step;
        this.fireActiveStepChanged(step);
    }

    public final Iterator stepIterator() {
        return this.steps.iterator();
    }

    protected final boolean allStepsComplete() {
        Iterator iterator = this.stepIterator();
        while (iterator.hasNext()) {
            if (((IWizardStep)iterator.next()).isComplete()) continue;
            return false;
        }
        return true;
    }

    protected final IWizardStep findLastStep() {
        for (int i = this.conditions.size() - 1; i >= 0; --i) {
            ICondition condition = (ICondition)this.conditions.get(i);
            if (!condition.evaluate()) continue;
            return (IWizardStep)this.steps.get(i);
        }
        throw new IllegalStateException("Wizard contains no visible steps");
    }

    protected final IWizardStep findNextVisibleStep() {
        int startIndex;
        for (int i = startIndex = this.activeStep == null ? 0 : this.steps.indexOf(this.activeStep) + 1; i < this.conditions.size(); ++i) {
            ICondition condition = (ICondition)this.conditions.get(i);
            if (!condition.evaluate()) continue;
            return (IWizardStep)this.steps.get(i);
        }
        throw new IllegalStateException("Wizard contains no more visible steps");
    }

    public static interface ICondition
    extends IClusterable {
        public boolean evaluate();
    }
}

