/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.breadcrumb;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.breadcrumb.BreadCrumbLink;
import org.apache.wicket.extensions.breadcrumb.DefaultBreadCrumbsModel;
import org.apache.wicket.extensions.breadcrumb.IBreadCrumbModel;
import org.apache.wicket.extensions.breadcrumb.IBreadCrumbModelListener;
import org.apache.wicket.extensions.breadcrumb.IBreadCrumbParticipant;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IDetachable;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;

public class BreadCrumbBar
extends Panel
implements IBreadCrumbModel {
    private static final long serialVersionUID = 1L;
    private final IBreadCrumbModel decorated = new DefaultBreadCrumbsModel();

    public BreadCrumbBar(String id) {
        super(id);
        BreadCrumbsListView breadCrumbsListView = new BreadCrumbsListView("crumbs");
        this.addListener(breadCrumbsListView);
        this.add((Component)breadCrumbsListView);
    }

    public void addListener(IBreadCrumbModelListener listener) {
        this.decorated.addListener(listener);
    }

    public List allBreadCrumbParticipants() {
        return this.decorated.allBreadCrumbParticipants();
    }

    public IBreadCrumbParticipant getActive() {
        return this.decorated.getActive();
    }

    public void removeListener(IBreadCrumbModelListener listener) {
        this.decorated.removeListener(listener);
    }

    public void setActive(IBreadCrumbParticipant breadCrumbParticipant) {
        this.decorated.setActive(breadCrumbParticipant);
    }

    protected boolean getEnableLinkToCurrent() {
        return false;
    }

    protected Component newBreadCrumbComponent(String id, int index, int total, IBreadCrumbParticipant breadCrumbParticipant) {
        boolean enableLink = this.getEnableLinkToCurrent() || index < total - 1;
        return new BreadCrumbComponent(id, index, this, breadCrumbParticipant, enableLink);
    }

    protected void onDetach() {
        super.onDetach();
        Iterator i = this.decorated.allBreadCrumbParticipants().iterator();
        while (i.hasNext()) {
            IBreadCrumbParticipant crumb = (IBreadCrumbParticipant)i.next();
            if (crumb instanceof Component) {
                ((Component)crumb).detach();
                continue;
            }
            if (!(crumb instanceof IDetachable)) continue;
            ((IDetachable)crumb).detach();
        }
    }

    protected class BreadCrumbsListView
    extends ListView
    implements IBreadCrumbModelListener {
        private static final long serialVersionUID = 1L;
        private transient boolean dirty;
        private transient int size;

        public BreadCrumbsListView(String id) {
            super(id);
            this.dirty = false;
            this.setReuseItems(false);
            this.setModel((IModel)new LoadableDetachableModel(this){
                private static final long serialVersionUID = 1L;
                private final /* synthetic */ BreadCrumbsListView this$1;
                {
                    this.this$1 = this$1;
                }

                protected Object load() {
                    ArrayList<E> l = new ArrayList<E>(BreadCrumbsListView.access$000(this.this$1).allBreadCrumbParticipants());
                    BreadCrumbsListView.access$102(this.this$1, l.size());
                    return l;
                }
            });
        }

        public void breadCrumbActivated(IBreadCrumbParticipant previousParticipant, IBreadCrumbParticipant breadCrumbParticipant) {
            this.signalModelChange();
        }

        public void breadCrumbAdded(IBreadCrumbParticipant breadCrumbParticipant) {
        }

        public void breadCrumbRemoved(IBreadCrumbParticipant breadCrumbParticipant) {
        }

        private void signalModelChange() {
            this.getModel().detach();
            super.internalOnAttach();
        }

        protected void onBeforeRender() {
            super.onBeforeRender();
            if (this.dirty) {
                this.dirty = false;
            }
        }

        protected void populateItem(ListItem item) {
            int index = item.getIndex();
            IBreadCrumbParticipant breadCrumbParticipant = (IBreadCrumbParticipant)item.getModelObject();
            item.add(BreadCrumbBar.this.newBreadCrumbComponent("crumb", index, this.size, breadCrumbParticipant));
        }

        static /* synthetic */ BreadCrumbBar access$000(BreadCrumbsListView x0) {
            return x0.BreadCrumbBar.this;
        }

        static /* synthetic */ int access$102(BreadCrumbsListView x0, int x1) {
            x0.size = x1;
            return x0.size;
        }
    }

    private static final class BreadCrumbComponent
    extends Panel {
        private static final long serialVersionUID = 1L;

        public BreadCrumbComponent(String id, int index, IBreadCrumbModel breadCrumbModel, IBreadCrumbParticipant breadCrumbParticipant, boolean enableLink) {
            super(id);
            this.add(new Label("sep", index > 0 ? "/" : "").setEscapeModelStrings(false).setRenderBodyOnly(true));
            BreadCrumbLink link = new BreadCrumbLink(this, "link", breadCrumbModel, breadCrumbParticipant){
                private static final long serialVersionUID = 1L;
                private final /* synthetic */ IBreadCrumbParticipant val$breadCrumbParticipant;
                private final /* synthetic */ BreadCrumbComponent this$0;
                {
                    this.this$0 = this$0;
                    this.val$breadCrumbParticipant = val$breadCrumbParticipant;
                    super(x0, x1);
                }

                protected IBreadCrumbParticipant getParticipant(String componentId) {
                    return this.val$breadCrumbParticipant;
                }
            };
            link.setEnabled(enableLink);
            this.add((Component)link);
            link.add(new Label("label", breadCrumbParticipant.getTitle()).setRenderBodyOnly(true));
        }
    }
}

