/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.ajax.markup.html.form.upload;

import org.apache.wicket.Application;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.IInitializer;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.Resource;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.behavior.HeaderContributor;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.ajax.markup.html.form.upload.UploadStatusResource;
import org.apache.wicket.extensions.ajax.markup.html.form.upload.UploadWebRequest;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadProgressBar
extends Panel {
    private static final Logger log = LoggerFactory.getLogger((Class)UploadProgressBar.class);
    private static final ResourceReference JS = new ResourceReference(UploadProgressBar.class, "progressbar.js");
    private static final ResourceReference CSS = new ResourceReference(UploadProgressBar.class, "UploadProgressBar.css");
    private static final String RESOURCE_NAME = UploadProgressBar.class.getName();
    private static final long serialVersionUID = 1L;

    public UploadProgressBar(String id, final Form form) {
        super(id);
        this.setOutputMarkupId(true);
        form.setOutputMarkupId(true);
        this.setRenderBodyOnly(true);
        this.add((IBehavior)HeaderContributor.forJavaScript((ResourceReference)JS));
        ResourceReference css = this.getCss();
        if (css != null) {
            this.add((IBehavior)HeaderContributor.forCss((ResourceReference)css));
        }
        final WebMarkupContainer barDiv = new WebMarkupContainer("bar");
        barDiv.setOutputMarkupId(true);
        this.add((Component)barDiv);
        final WebMarkupContainer statusDiv = new WebMarkupContainer("status");
        statusDiv.setOutputMarkupId(true);
        this.add((Component)statusDiv);
        if (!(RequestCycle.get().getRequest() instanceof UploadWebRequest)) {
            log.warn("UploadProgressBar will not work without an UploadWebRequest. See the javadoc for details.");
        }
        form.add((IBehavior)new AttributeModifier("onsubmit", true, (IModel)new Model(){
            private static final long serialVersionUID = 1L;

            public Object getObject() {
                ResourceReference ref = new ResourceReference(RESOURCE_NAME);
                return "var def=new Wicket.WUPB.Def('" + form.getMarkupId() + "', '" + statusDiv.getMarkupId() + "', '" + barDiv.getMarkupId() + "', '" + UploadProgressBar.this.getPage().urlFor(ref) + "'); Wicket.WUPB.start(def); return false;";
            }
        }));
    }

    protected ResourceReference getCss() {
        return CSS;
    }

    public static final class ComponentInitializer
    implements IInitializer {
        public void init(Application application) {
            Application.get().getSharedResources().add(RESOURCE_NAME, (Resource)new UploadStatusResource());
        }

        public String toString() {
            return "Ajax UploadProgressBar initializer";
        }
    }
}

