/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.maven.plugin.tomcat7.run;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Loader;
import org.apache.catalina.Realm;
import org.apache.catalina.Valve;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.loader.WebappLoader;
import org.apache.catalina.realm.MemoryRealm;
import org.apache.catalina.startup.Catalina;
import org.apache.catalina.startup.CatalinaProperties;
import org.apache.catalina.startup.Tomcat;
import org.apache.catalina.valves.AccessLogValve;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.tomcat.maven.common.run.EmbeddedRegistry;
import org.apache.tomcat.maven.common.run.ExternalRepositoriesReloadableWebappLoader;
import org.apache.tomcat.maven.plugin.tomcat7.AbstractTomcat7Mojo;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.classworlds.realm.DuplicateRealmException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRunMojo
extends AbstractTomcat7Mojo {
    private String packaging;
    private File configurationDir;
    private int port;
    private int ajpPort;
    private String ajpProtocol;
    private int httpsPort;
    private String uriEncoding;
    private Map<String, String> systemProperties;
    private File additionalConfigFilesDir;
    private File serverXml;
    private File tomcatWebXml;
    private boolean fork;
    private boolean addContextWarDependencies;
    protected MavenProject project;
    private ArchiverManager archiverManager;
    protected boolean useSeparateTomcatClassLoader;
    private List pluginArtifacts;
    private boolean ignorePackaging;
    private String keystoreFile;
    private String keystorePass;
    private boolean useNaming;
    protected boolean contextReloadable;
    protected File contextFile;
    private String protocol;
    private File tomcatUsers;
    private File tomcatLoggingFile;
    private ClassRealm tomcatRealm;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.isWar()) {
            this.getLog().info((CharSequence)this.messagesProvider.getMessage("AbstractRunMojo.nonWar"));
            return;
        }
        ClassLoader originalClassLoaser = Thread.currentThread().getContextClassLoader();
        try {
            if (this.useSeparateTomcatClassLoader) {
                Thread.currentThread().setContextClassLoader((ClassLoader)this.getTomcatClassLoader());
            }
            this.getLog().info((CharSequence)this.messagesProvider.getMessage("AbstractRunMojo.runningWar", (Object)this.getWebappUrl()));
            this.initConfiguration();
            this.startContainer();
            if (!this.fork) {
                this.waitIndefinitely();
            }
        }
        catch (LifecycleException exception) {
            throw new MojoExecutionException(this.messagesProvider.getMessage("AbstractRunMojo.cannotStart"), (Exception)((Object)exception));
        }
        catch (IOException exception) {
            throw new MojoExecutionException(this.messagesProvider.getMessage("AbstractRunMojo.cannotCreateConfiguration"), (Exception)exception);
        }
        catch (ServletException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        finally {
            if (this.useSeparateTomcatClassLoader) {
                Thread.currentThread().setContextClassLoader(originalClassLoaser);
            }
        }
    }

    @Override
    protected String getPath() {
        return this.path;
    }

    protected Context createContext(Tomcat container) throws IOException, MojoExecutionException, ServletException {
        String contextPath = this.getPath();
        Context context = container.addWebapp(contextPath, this.getDocBase().getAbsolutePath());
        if (this.useSeparateTomcatClassLoader) {
            context.setParentClassLoader((ClassLoader)this.getTomcatClassLoader());
        }
        context.setLoader((Loader)this.createWebappLoader());
        File contextFile = this.getContextFile();
        if (contextFile != null) {
            context.setConfigFile(this.getContextFile().toURI().toURL());
        }
        return context;
    }

    protected WebappLoader createWebappLoader() throws IOException, MojoExecutionException {
        if (this.useSeparateTomcatClassLoader) {
            return this.isContextReloadable() ? new ExternalRepositoriesReloadableWebappLoader((ClassLoader)this.getTomcatClassLoader(), this.getLog()) : new WebappLoader((ClassLoader)this.getTomcatClassLoader());
        }
        return this.isContextReloadable() ? new ExternalRepositoriesReloadableWebappLoader(Thread.currentThread().getContextClassLoader(), this.getLog()) : new WebappLoader(Thread.currentThread().getContextClassLoader());
    }

    protected boolean isContextReloadable() throws MojoExecutionException {
        if (this.contextReloadable) {
            return true;
        }
        boolean reloadable = false;
        try {
            if (this.contextFile != null && this.contextFile.exists()) {
                DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = builderFactory.newDocumentBuilder();
                Document contextDoc = builder.parse(this.contextFile);
                contextDoc.getDocumentElement().normalize();
                NamedNodeMap nodeMap = contextDoc.getDocumentElement().getAttributes();
                Node reloadableAttribute = nodeMap.getNamedItem("reloadable");
                reloadable = reloadableAttribute != null ? Boolean.valueOf(reloadableAttribute.getNodeValue()) : false;
            }
            this.getLog().debug((CharSequence)("context reloadable: " + reloadable));
        }
        catch (IOException ioe) {
            this.getLog().error((CharSequence)("Could not parse file: [" + this.contextFile.getAbsolutePath() + "]"), (Throwable)ioe);
        }
        catch (ParserConfigurationException pce) {
            this.getLog().error((CharSequence)"Could not configure XML parser", (Throwable)pce);
        }
        catch (SAXException se) {
            this.getLog().error((CharSequence)("Could not parse file: [" + this.contextFile.getAbsolutePath() + "]"), (Throwable)se);
        }
        return reloadable;
    }

    protected abstract File getDocBase();

    protected abstract File getContextFile() throws MojoExecutionException;

    protected boolean isWar() {
        return "war".equals(this.packaging) || this.ignorePackaging;
    }

    private URL getWebappUrl() throws MalformedURLException {
        return new URL("http", "localhost", this.port, this.getPath());
    }

    private void initConfiguration() throws IOException, MojoExecutionException {
        if (this.configurationDir.exists()) {
            this.getLog().info((CharSequence)this.messagesProvider.getMessage("AbstractRunMojo.usingConfiguration", (Object)this.configurationDir));
        } else {
            this.getLog().info((CharSequence)this.messagesProvider.getMessage("AbstractRunMojo.creatingConfiguration", (Object)this.configurationDir));
            this.configurationDir.mkdirs();
            File confDir = new File(this.configurationDir, "conf");
            confDir.mkdir();
            if (this.tomcatLoggingFile != null) {
                FileUtils.copyFile((File)this.tomcatLoggingFile, (File)new File(confDir, "logging.properties"));
            } else {
                this.copyFile("/conf/logging.properties", new File(confDir, "logging.properties"));
            }
            this.copyFile("/conf/tomcat-users.xml", new File(confDir, "tomcat-users.xml"));
            if (this.tomcatWebXml != null) {
                if (!this.tomcatWebXml.exists()) {
                    throw new MojoExecutionException(" tomcatWebXml " + this.tomcatWebXml.getPath() + " not exists");
                }
                FileUtils.copyFile((File)this.tomcatWebXml, (File)new File(confDir, "web.xml"));
            } else {
                this.copyFile("/conf/web.xml", new File(confDir, "web.xml"));
            }
            File logDir = new File(this.configurationDir, "logs");
            logDir.mkdir();
            File webappsDir = new File(this.configurationDir, "webapps");
            webappsDir.mkdir();
            if (this.additionalConfigFilesDir != null && this.additionalConfigFilesDir.exists()) {
                DirectoryScanner scanner = new DirectoryScanner();
                scanner.addDefaultExcludes();
                scanner.setBasedir(this.additionalConfigFilesDir.getPath());
                scanner.scan();
                String[] files = scanner.getIncludedFiles();
                if (files != null && files.length > 0) {
                    this.getLog().info((CharSequence)"Coping additional tomcat config files");
                    for (int i = 0; i < files.length; ++i) {
                        File file = new File(this.additionalConfigFilesDir, files[i]);
                        this.getLog().info((CharSequence)(" copy " + file.getName()));
                        FileUtils.copyFileToDirectory((File)file, (File)confDir);
                    }
                }
            }
        }
    }

    private void copyFile(String fromPath, File toFile) throws IOException {
        URL fromURL = ((Object)((Object)this)).getClass().getResource(fromPath);
        if (fromURL == null) {
            throw new FileNotFoundException(fromPath);
        }
        FileUtils.copyURLToFile((URL)fromURL, (File)toFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startContainer() throws IOException, LifecycleException, MojoExecutionException, ServletException {
        String previousCatalinaBase = System.getProperty("catalina.base");
        try {
            this.setupSystemProperties();
            System.setProperty("catalina.base", this.configurationDir.getAbsolutePath());
            if (this.serverXml != null) {
                if (!this.serverXml.exists()) {
                    throw new MojoExecutionException(this.serverXml.getPath() + " not exists");
                }
                Catalina container = new Catalina();
                container.setUseNaming(this.useNaming);
                container.setConfig(this.serverXml.getAbsolutePath());
                container.start();
                EmbeddedRegistry.getInstance().register((Object)container);
            } else {
                System.setProperty("java.util.logging.manager", "org.apache.juli.ClassLoaderLogManager");
                System.setProperty("java.util.logging.config.file", new File(this.configurationDir, "conf/logging.properties").toString());
                CatalinaProperties.getProperty((String)"foo");
                Tomcat embeddedTomcat = new Tomcat();
                if (this.useNaming) {
                    embeddedTomcat.enableNaming();
                }
                embeddedTomcat.setBaseDir(this.configurationDir.getAbsolutePath());
                MemoryRealm memoryRealm = new MemoryRealm();
                if (this.tomcatUsers != null) {
                    if (!this.tomcatUsers.exists()) {
                        throw new MojoExecutionException(" tomcatUsers " + this.tomcatUsers.getPath() + " not exists");
                    }
                    this.getLog().info((CharSequence)("use tomcat-users.xml from " + this.tomcatUsers.getAbsolutePath()));
                    memoryRealm.setPathname(this.tomcatUsers.getAbsolutePath());
                }
                embeddedTomcat.setDefaultRealm((Realm)memoryRealm);
                embeddedTomcat.getHost().setAppBase(new File(this.configurationDir, "webapps").getAbsolutePath());
                Connector connector = new Connector(this.protocol);
                connector.setPort(this.port);
                if (this.httpsPort > 0) {
                    connector.setRedirectPort(this.httpsPort);
                }
                connector.setURIEncoding(this.uriEncoding);
                embeddedTomcat.getService().addConnector(connector);
                embeddedTomcat.setConnector(connector);
                if (this.useSeparateTomcatClassLoader) {
                    embeddedTomcat.getEngine().setParentClassLoader((ClassLoader)this.getTomcatClassLoader());
                }
                Context ctx = this.createContext(embeddedTomcat);
                AccessLogValve alv = new AccessLogValve();
                alv.setDirectory(new File(this.configurationDir, "logs").getAbsolutePath());
                alv.setPattern("%h %l %u %t \"%r\" %s %b %I %D");
                embeddedTomcat.getHost().getPipeline().addValve((Valve)alv);
                if (this.httpsPort > 0) {
                    Connector httpsConnector = new Connector(this.protocol);
                    httpsConnector.setPort(this.httpsPort);
                    httpsConnector.setSecure(true);
                    httpsConnector.setProperty("SSLEnabled", "true");
                    httpsConnector.setProperty("sslProtocol", "TLS");
                    if (this.keystoreFile != null) {
                        httpsConnector.setAttribute("keystoreFile", (Object)this.keystoreFile);
                    }
                    if (this.keystorePass != null) {
                        httpsConnector.setAttribute("keystorePass", (Object)this.keystorePass);
                    }
                    embeddedTomcat.getEngine().getService().addConnector(httpsConnector);
                }
                if (this.ajpPort > 0) {
                    Connector ajpConnector = new Connector(this.ajpProtocol);
                    ajpConnector.setPort(this.ajpPort);
                    ajpConnector.setURIEncoding(this.uriEncoding);
                    embeddedTomcat.getEngine().getService().addConnector(ajpConnector);
                }
                if (this.useSeparateTomcatClassLoader) {
                    embeddedTomcat.getEngine().setParentClassLoader((ClassLoader)this.getTomcatClassLoader());
                }
                if (this.addContextWarDependencies) {
                    this.createDependencyContexts(embeddedTomcat);
                }
                embeddedTomcat.start();
                EmbeddedRegistry.getInstance().register((Object)embeddedTomcat);
            }
        }
        finally {
            if (previousCatalinaBase != null) {
                System.setProperty("catalina.base", previousCatalinaBase);
            }
        }
    }

    protected ClassRealm getTomcatClassLoader() throws MojoExecutionException {
        if (this.tomcatRealm != null) {
            return this.tomcatRealm;
        }
        try {
            ClassWorld world = new ClassWorld();
            ClassRealm root = world.newRealm("tomcat", Thread.currentThread().getContextClassLoader());
            for (Artifact pluginArtifact : this.pluginArtifacts) {
                if (!"org.apache.tomcat".equals(pluginArtifact.getGroupId()) || pluginArtifact.getFile() == null) continue;
                root.addURL(pluginArtifact.getFile().toURI().toURL());
            }
            this.tomcatRealm = root;
            return root;
        }
        catch (DuplicateRealmException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    public Set<Artifact> getProjectArtifacts() {
        return this.project.getArtifacts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitIndefinitely() {
        Object lock;
        Object object = lock = new Object();
        synchronized (object) {
            try {
                lock.wait();
            }
            catch (InterruptedException exception) {
                this.getLog().warn((CharSequence)this.messagesProvider.getMessage("AbstractRunMojo.interrupted"), (Throwable)exception);
            }
        }
    }

    private void setupSystemProperties() {
        if (this.systemProperties != null && !this.systemProperties.isEmpty()) {
            this.getLog().info((CharSequence)"setting SystemProperties:");
            for (String key : this.systemProperties.keySet()) {
                String value = this.systemProperties.get(key);
                if (value != null) {
                    this.getLog().info((CharSequence)(" " + key + "=" + value));
                    System.setProperty(key, value);
                    continue;
                }
                this.getLog().info((CharSequence)("skip sysProps " + key + " with empty value"));
            }
        }
    }

    private Collection<Context> createDependencyContexts(Tomcat container) throws MojoExecutionException, MalformedURLException {
        this.getLog().info((CharSequence)"Deploying dependency wars");
        ArrayList<Context> contexts = new ArrayList<Context>();
        ScopeArtifactFilter filter = new ScopeArtifactFilter("tomcat");
        Set artifacts = this.project.getArtifacts();
        for (Artifact artifact : artifacts) {
            if (!"war".equals(artifact.getType()) || artifact.isOptional() || !filter.include(artifact)) continue;
            this.getLog().info((CharSequence)("Deploy warfile: " + String.valueOf(artifact.getFile())));
            File webapps = new File(this.configurationDir, "webapps");
            File artifactWarDir = new File(webapps, artifact.getArtifactId());
            if (!artifactWarDir.exists()) {
                artifactWarDir.mkdir();
                try {
                    UnArchiver unArchiver = this.archiverManager.getUnArchiver("zip");
                    unArchiver.setSourceFile(artifact.getFile());
                    unArchiver.setDestDirectory(artifactWarDir);
                    unArchiver.extract();
                }
                catch (NoSuchArchiverException e) {
                    this.getLog().error((Throwable)e);
                    continue;
                }
                catch (ArchiverException e) {
                    this.getLog().error((Throwable)e);
                    continue;
                }
            }
            WebappLoader webappLoader = new WebappLoader(Thread.currentThread().getContextClassLoader());
            Context context = container.addContext("/" + artifact.getArtifactId(), artifactWarDir.getAbsolutePath());
            context.setLoader((Loader)webappLoader);
            context.setName(artifact.getArtifactId());
            File contextFile = this.getContextFile();
            if (contextFile != null) {
                context.setConfigFile(this.getContextFile().toURI().toURL());
            }
            contexts.add(context);
        }
        return contexts;
    }
}

