/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.maven.plugin.tomcat7.run;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.jar.JarArchiveEntry;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.tomcat.maven.plugin.tomcat7.AbstractTomcat7Mojo;
import org.apache.tomcat.maven.plugin.tomcat7.run.ExtraDependency;
import org.apache.tomcat.maven.plugin.tomcat7.run.ExtraResource;
import org.apache.tomcat.maven.plugin.tomcat7.run.WarRunDependency;
import org.codehaus.plexus.archiver.jar.Manifest;
import org.codehaus.plexus.archiver.jar.ManifestException;
import org.codehaus.plexus.util.DirectoryScanner;

public abstract class AbstractExecWarMojo
extends AbstractTomcat7Mojo {
    private Artifact projectArtifact;
    protected MavenProject project;
    private List<Artifact> pluginArtifacts;
    private File buildDirectory;
    private File tomcatConfigurationFilesDirectory;
    private File serverXml;
    private String finalName;
    protected String path;
    protected List<WarRunDependency> warRunDependencies;
    protected ArtifactResolver artifactResolver;
    private ArtifactFactory artifactFactory;
    private ArtifactRepository local;
    protected List<ArtifactRepository> remoteRepos;
    private MavenProjectHelper projectHelper;
    private boolean attachArtifact;
    private String attachArtifactClassifier;
    private String attachArtifactClassifierType;
    private boolean enableNaming;
    private String accessLogValveFormat;
    private List<ExtraDependency> extraDependencies;
    private List<ExtraResource> extraResources;
    private String mainClass;
    private String connectorHttpProtocol;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        File warExecFile = new File(this.buildDirectory, this.finalName);
        if (warExecFile.exists()) {
            warExecFile.delete();
        }
        File execWarJar = new File(this.buildDirectory, this.finalName);
        FileOutputStream execWarJarOutputStream = null;
        ArchiveOutputStream os = null;
        File tmpPropertiesFile = null;
        File tmpManifestFile = null;
        FileOutputStream tmpPropertiesFileOutputStream = null;
        PrintWriter tmpManifestWriter = null;
        try {
            tmpPropertiesFile = new File(this.buildDirectory, "war-exec.properties");
            if (tmpPropertiesFile.exists()) {
                tmpPropertiesFile.delete();
            }
            tmpPropertiesFile.getParentFile().mkdirs();
            tmpManifestFile = new File(this.buildDirectory, "war-exec.manifest");
            if (tmpManifestFile.exists()) {
                tmpManifestFile.delete();
            }
            tmpPropertiesFileOutputStream = new FileOutputStream(tmpPropertiesFile);
            execWarJar.getParentFile().mkdirs();
            execWarJar.createNewFile();
            execWarJarOutputStream = new FileOutputStream(execWarJar);
            tmpManifestWriter = new PrintWriter(tmpManifestFile);
            Properties properties = new Properties();
            properties.put("enableNaming", Boolean.toString(this.enableNaming));
            properties.put("accessLogValveFormat", this.accessLogValveFormat);
            properties.put("connectorhttpProtocol", this.connectorHttpProtocol);
            os = new ArchiveStreamFactory().createArchiveOutputStream("jar", (OutputStream)execWarJarOutputStream);
            if ("war".equals(this.project.getPackaging())) {
                os.putArchiveEntry((ArchiveEntry)new JarArchiveEntry(StringUtils.removeStart((String)this.path, (String)"/") + ".war"));
                IOUtils.copy((InputStream)new FileInputStream(this.projectArtifact.getFile()), (OutputStream)os);
                os.closeArchiveEntry();
                properties.put("wars", StringUtils.removeStart((String)this.path, (String)"/") + ".war|" + this.path);
            }
            if ("pom".equals(this.project.getPackaging()) && this.warRunDependencies != null && !this.warRunDependencies.isEmpty()) {
                for (WarRunDependency warRunDependency : this.warRunDependencies) {
                    String contextPath;
                    if (warRunDependency.dependency == null) continue;
                    Dependency dependency = warRunDependency.dependency;
                    Artifact artifact = this.artifactFactory.createArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getScope(), dependency.getType());
                    this.artifactResolver.resolve(artifact, this.remoteRepos, this.local);
                    File warFile = new File(this.buildDirectory, artifact.getFile().getName());
                    String warFileName = artifact.getFile().getName();
                    FileUtils.copyFile((File)artifact.getFile(), (File)warFile);
                    if (warRunDependency.contextXml != null) {
                        warFile = this.addContextXmlToWar(warRunDependency.contextXml, warFile);
                    }
                    os.putArchiveEntry((ArchiveEntry)new JarArchiveEntry(warFileName));
                    IOUtils.copy((InputStream)new FileInputStream(warFile), (OutputStream)os);
                    os.closeArchiveEntry();
                    String propertyWarValue = properties.getProperty("wars");
                    String string = contextPath = StringUtils.isEmpty((String)warRunDependency.contextPath) ? "/" : warRunDependency.contextPath;
                    if (propertyWarValue != null) {
                        properties.put("wars", propertyWarValue + ";" + warFileName + "|" + contextPath);
                        continue;
                    }
                    properties.put("wars", warFileName + "|" + contextPath);
                }
            }
            if (this.serverXml != null && this.serverXml.exists()) {
                os.putArchiveEntry((ArchiveEntry)new JarArchiveEntry("conf/server.xml"));
                IOUtils.copy((InputStream)new FileInputStream(this.serverXml), (OutputStream)os);
                os.closeArchiveEntry();
                properties.put("useServerXml", Boolean.TRUE.toString());
            } else {
                properties.put("useServerXml", Boolean.FALSE.toString());
            }
            properties.store(tmpPropertiesFileOutputStream, "created by Apache Tomcat Maven plugin");
            tmpPropertiesFileOutputStream.flush();
            tmpPropertiesFileOutputStream.close();
            os.putArchiveEntry((ArchiveEntry)new JarArchiveEntry("tomcat.standalone.properties"));
            IOUtils.copy((InputStream)new FileInputStream(tmpPropertiesFile), (OutputStream)os);
            os.closeArchiveEntry();
            for (Artifact pluginArtifact : this.pluginArtifacts) {
                if (!StringUtils.equals((String)"org.apache.tomcat", (String)pluginArtifact.getGroupId()) && !StringUtils.equals((String)"org.apache.tomcat.embed", (String)pluginArtifact.getGroupId()) && !StringUtils.equals((String)"org.eclipse.jdt.core.compiler", (String)pluginArtifact.getGroupId()) && !StringUtils.equals((String)"commons-cli", (String)pluginArtifact.getArtifactId()) && !StringUtils.equals((String)"tomcat7-war-runner", (String)pluginArtifact.getArtifactId())) continue;
                JarFile jarFile = new JarFile(pluginArtifact.getFile());
                Enumeration<JarEntry> jarEntries = jarFile.entries();
                while (jarEntries.hasMoreElements()) {
                    JarEntry jarEntry = jarEntries.nextElement();
                    InputStream jarEntryIs = jarFile.getInputStream(jarEntry);
                    os.putArchiveEntry((ArchiveEntry)new JarArchiveEntry(jarEntry.getName()));
                    IOUtils.copy((InputStream)jarEntryIs, (OutputStream)os);
                    os.closeArchiveEntry();
                }
            }
            if (this.extraDependencies != null && !this.extraDependencies.isEmpty()) {
                for (ExtraDependency dependency : this.extraDependencies) {
                    Artifact artifact = this.artifactFactory.createArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getScope(), dependency.getType());
                    this.artifactResolver.resolve(artifact, this.remoteRepos, this.local);
                    JarFile jarFile = new JarFile(artifact.getFile());
                    Enumeration<JarEntry> jarEntries = jarFile.entries();
                    while (jarEntries.hasMoreElements()) {
                        JarEntry jarEntry = jarEntries.nextElement();
                        InputStream jarEntryIs = jarFile.getInputStream(jarEntry);
                        os.putArchiveEntry((ArchiveEntry)new JarArchiveEntry(jarEntry.getName()));
                        IOUtils.copy((InputStream)jarEntryIs, (OutputStream)os);
                        os.closeArchiveEntry();
                    }
                }
            }
            Manifest manifest = new Manifest();
            Manifest.Attribute mainClassAtt = new Manifest.Attribute();
            mainClassAtt.setName("Main-Class");
            mainClassAtt.setValue(this.mainClass);
            manifest.addConfiguredAttribute(mainClassAtt);
            manifest.write(tmpManifestWriter);
            tmpManifestWriter.flush();
            tmpManifestWriter.close();
            os.putArchiveEntry((ArchiveEntry)new JarArchiveEntry("META-INF/MANIFEST.MF"));
            IOUtils.copy((InputStream)new FileInputStream(tmpManifestFile), (OutputStream)os);
            os.closeArchiveEntry();
            if (this.attachArtifact) {
                this.projectHelper.attachArtifact(this.project, this.attachArtifactClassifierType, this.attachArtifactClassifier, execWarJar);
            }
            if (this.extraResources != null) {
                for (ExtraResource extraResource : this.extraResources) {
                    DirectoryScanner directoryScanner = new DirectoryScanner();
                    directoryScanner.setBasedir(extraResource.getDirectory());
                    directoryScanner.addDefaultExcludes();
                    directoryScanner.setExcludes(this.toStringArray(extraResource.getExcludes()));
                    directoryScanner.setIncludes(this.toStringArray(extraResource.getIncludes()));
                    directoryScanner.scan();
                    for (String includeFile : directoryScanner.getIncludedFiles()) {
                        this.getLog().debug((CharSequence)("include file:" + includeFile));
                        os.putArchiveEntry((ArchiveEntry)new JarArchiveEntry(includeFile));
                        IOUtils.copy((InputStream)new FileInputStream(new File(extraResource.getDirectory(), includeFile)), (OutputStream)os);
                        os.closeArchiveEntry();
                    }
                }
            }
        }
        catch (ManifestException e) {
            try {
                throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
                catch (IOException e2) {
                    throw new MojoExecutionException(e2.getMessage(), (Exception)e2);
                }
                catch (ArchiveException e3) {
                    throw new MojoExecutionException(e3.getMessage(), (Exception)((Object)e3));
                }
                catch (ArtifactNotFoundException e4) {
                    throw new MojoExecutionException(e4.getMessage(), (Exception)((Object)e4));
                }
                catch (ArtifactResolutionException e5) {
                    throw new MojoExecutionException(e5.getMessage(), (Exception)((Object)e5));
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(os);
                IOUtils.closeQuietly(tmpManifestWriter);
                IOUtils.closeQuietly(execWarJarOutputStream);
                IOUtils.closeQuietly(tmpPropertiesFileOutputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)os);
        IOUtils.closeQuietly((Writer)tmpManifestWriter);
        IOUtils.closeQuietly((OutputStream)execWarJarOutputStream);
        IOUtils.closeQuietly((OutputStream)tmpPropertiesFileOutputStream);
    }

    private String[] toStringArray(List list) {
        if (list == null || list.isEmpty()) {
            return new String[0];
        }
        ArrayList<String> res = new ArrayList<String>(list.size());
        Iterator ite = list.iterator();
        while (ite.hasNext()) {
            res.add((String)ite.next());
        }
        return res.toArray(new String[res.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File addContextXmlToWar(File contextXmlFile, File warFile) throws IOException, ArchiveException {
        ArchiveOutputStream os = null;
        FileOutputStream warOutputStream = null;
        File tmpWar = File.createTempFile("tomcat", "war-exec");
        tmpWar.deleteOnExit();
        try {
            warOutputStream = new FileOutputStream(tmpWar);
            os = new ArchiveStreamFactory().createArchiveOutputStream("jar", (OutputStream)warOutputStream);
            os.putArchiveEntry((ArchiveEntry)new JarArchiveEntry("META-INF/context.xml"));
            IOUtils.copy((InputStream)new FileInputStream(contextXmlFile), (OutputStream)os);
            os.closeArchiveEntry();
            JarFile jarFile = new JarFile(warFile);
            Enumeration<JarEntry> jarEntries = jarFile.entries();
            while (jarEntries.hasMoreElements()) {
                JarEntry jarEntry = jarEntries.nextElement();
                os.putArchiveEntry((ArchiveEntry)new JarArchiveEntry(jarEntry.getName()));
                IOUtils.copy((InputStream)jarFile.getInputStream(jarEntry), (OutputStream)os);
                os.closeArchiveEntry();
            }
            os.flush();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(os);
            IOUtils.closeQuietly((OutputStream)warOutputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)os);
        IOUtils.closeQuietly((OutputStream)warOutputStream);
        return tmpWar;
    }
}

