/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.ServletException;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.valves.ValveBase;

public abstract class RequestFilterValve
extends ValveBase
implements Lifecycle {
    private static final String info = "org.apache.catalina.valves.RequestFilterValve/1.0";
    protected static StringManager sm = StringManager.getManager("org.apache.catalina.valves");
    protected volatile String allow = null;
    protected volatile boolean allowValid = true;
    protected volatile Pattern[] allows = new Pattern[0];
    protected volatile Pattern[] denies = new Pattern[0];
    protected volatile String deny = null;
    protected volatile boolean denyValid = true;
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    protected boolean started = false;

    public String getAllow() {
        return this.allow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAllow(String allow) {
        boolean success = false;
        try {
            this.allow = allow;
            this.allows = this.precalculate(allow);
            success = true;
            Object var4_3 = null;
            this.allowValid = success;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.allowValid = success;
            throw throwable;
        }
    }

    public String getDeny() {
        return this.deny;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDeny(String deny) {
        boolean success = false;
        try {
            this.deny = deny;
            this.denies = this.precalculate(deny);
            success = true;
            Object var4_3 = null;
            this.denyValid = success;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.denyValid = success;
            throw throwable;
        }
    }

    public final boolean isAllowValid() {
        return this.allowValid;
    }

    public final boolean isDenyValid() {
        return this.denyValid;
    }

    public String getInfo() {
        return info;
    }

    public abstract void invoke(Request var1, Response var2) throws IOException, ServletException;

    protected Pattern[] precalculate(String list) {
        int comma;
        if (list == null) {
            return new Pattern[0];
        }
        if ((list = list.trim()).length() < 1) {
            return new Pattern[0];
        }
        list = list + ",";
        ArrayList<Pattern> reList = new ArrayList<Pattern>();
        while (list.length() > 0 && (comma = list.indexOf(44)) >= 0) {
            String pattern = list.substring(0, comma).trim();
            try {
                reList.add(Pattern.compile(pattern));
            }
            catch (PatternSyntaxException e) {
                IllegalArgumentException iae = new IllegalArgumentException(sm.getString("requestFilterValve.syntax", pattern));
                iae.initCause(e);
                throw iae;
            }
            list = list.substring(comma + 1);
        }
        Pattern[] reArray = new Pattern[reList.size()];
        return reList.toArray(reArray);
    }

    protected void process(String property, Request request, Response response) throws IOException, ServletException {
        if (this.isAllowed(property)) {
            this.getNext().invoke(request, response);
            return;
        }
        response.sendError(403);
    }

    public boolean isAllowed(String property) {
        int i;
        Pattern[] denies = this.denies;
        Pattern[] allows = this.allows;
        for (i = 0; i < denies.length; ++i) {
            if (!denies[i].matcher(property).matches()) continue;
            return false;
        }
        for (i = 0; i < allows.length; ++i) {
            if (!allows[i].matcher(property).matches()) continue;
            return true;
        }
        return denies.length > 0 && allows.length == 0;
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(sm.getString("requestFilterValve.alreadyStarted"));
        }
        if (!this.allowValid || !this.denyValid) {
            throw new LifecycleException(sm.getString("requestFilterValve.configInvalid"));
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            return;
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
    }
}

