/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.segment.combine;

import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.segment.from.TableSegmentBinderContext;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementBinderContext;
import org.apache.shardingsphere.infra.binder.statement.dml.SelectStatementBinder;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.combine.CombineSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.subquery.SubquerySegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;

public final class CombineSegmentBinder {
    public static CombineSegment bind(CombineSegment segment, SQLStatementBinderContext statementBinderContext) {
        ShardingSphereMetaData metaData = statementBinderContext.getMetaData();
        String defaultDatabaseName = statementBinderContext.getDefaultDatabaseName();
        Map<String, TableSegmentBinderContext> externalTableBinderContexts = statementBinderContext.getExternalTableBinderContexts();
        SelectStatement boundedLeftSelect = new SelectStatementBinder().bindWithExternalTableContexts(segment.getLeft().getSelect(), metaData, defaultDatabaseName, externalTableBinderContexts);
        SelectStatement boundedRightSelect = new SelectStatementBinder().bindWithExternalTableContexts(segment.getRight().getSelect(), metaData, defaultDatabaseName, externalTableBinderContexts);
        SubquerySegment boundedLeft = new SubquerySegment(segment.getLeft().getStartIndex(), segment.getLeft().getStopIndex(), segment.getLeft().getText());
        boundedLeft.setSelect(boundedLeftSelect);
        boundedLeft.setSubqueryType(segment.getLeft().getSubqueryType());
        SubquerySegment boundedRight = new SubquerySegment(segment.getRight().getStartIndex(), segment.getRight().getStopIndex(), segment.getRight().getText());
        boundedRight.setSelect(boundedRightSelect);
        boundedRight.setSubqueryType(segment.getRight().getSubqueryType());
        return new CombineSegment(segment.getStartIndex(), segment.getStopIndex(), boundedLeft, segment.getCombineType(), boundedRight);
    }

    @Generated
    private CombineSegmentBinder() {
    }
}

