/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.testsuite.test;

import java.io.IOException;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.pluto.testsuite.TestResult;
import org.apache.pluto.testsuite.test.AbstractReflectivePortletTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DispatcherRequestTest
extends AbstractReflectivePortletTest {
    private static final Logger LOG = LoggerFactory.getLogger(DispatcherRequestTest.class);
    private static final String SERVLET_PATH = "/test/DispatcherRequestTest_Servlet";
    private static final String CHECK_PATH_INFO = "/checkPathInfo";
    private static final String CHECK_REQUEST_URI = "/checkRequestURI";
    private static final String CHECK_CONTEXT_PATH = "/checkContextPath";
    private static final String CHECK_SERVLET_PATH = "/checkServletPath";
    private static final String CHECK_QUERY_STRING = "/checkQueryString";
    private static final String GET_REQUEST_URI = "/getRequestURI";
    private static final String GET_CONTEXT_PATH = "/getContextPath";
    private static final String GET_SERVLET_PATH = "/getServletPath";
    private static final String GET_QUERY_STRING = "/getQueryString";
    private static final String QUERY_STRING = "paramName=paramValue";
    private static final String RESULT_KEY = DispatcherRequestTest.class.getName() + ".RESULT_KEY";
    private static final String EXPECTED_REQUEST_URI = DispatcherRequestTest.class.getName() + ".REQUEST_URI";
    private static final String EXPECTED_CONTEXT_PATH = DispatcherRequestTest.class.getName() + ".CONTEXT_PATH";

    protected TestResult checkPathInfo(PortletContext context, PortletRequest request, PortletResponse response) throws IOException, PortletException {
        return this.doCheckIncludedAttribute(context, request, response, CHECK_PATH_INFO);
    }

    protected TestResult checkRequestURI(PortletContext context, PortletRequest request, PortletResponse response) throws IOException, PortletException {
        return this.doCheckIncludedAttribute(context, request, response, CHECK_REQUEST_URI);
    }

    protected TestResult checkGetRequestURI(PortletContext context, PortletRequest request, PortletResponse response) throws IOException, PortletException {
        return this.doCheckIncludedAttribute(context, request, response, GET_REQUEST_URI);
    }

    protected TestResult checkContextPath(PortletContext context, PortletRequest request, PortletResponse response) throws IOException, PortletException {
        return this.doCheckIncludedAttribute(context, request, response, CHECK_CONTEXT_PATH);
    }

    protected TestResult checkGetContextPath(PortletContext context, PortletRequest request, PortletResponse response) throws IOException, PortletException {
        return this.doCheckIncludedAttribute(context, request, response, GET_CONTEXT_PATH);
    }

    protected TestResult checkServletPath(PortletContext context, PortletRequest request, PortletResponse response) throws IOException, PortletException {
        return this.doCheckIncludedAttribute(context, request, response, CHECK_SERVLET_PATH);
    }

    protected TestResult checkGetServletPath(PortletContext context, PortletRequest request, PortletResponse response) throws IOException, PortletException {
        return this.doCheckIncludedAttribute(context, request, response, GET_SERVLET_PATH);
    }

    protected TestResult checkQueryString(PortletContext context, PortletRequest request, PortletResponse response) throws IOException, PortletException {
        return this.doCheckIncludedAttribute(context, request, response, CHECK_QUERY_STRING);
    }

    protected TestResult checkGetQueryString(PortletContext context, PortletRequest request, PortletResponse response) throws IOException, PortletException {
        return this.doCheckIncludedAttribute(context, request, response, GET_QUERY_STRING);
    }

    private TestResult doCheckIncludedAttribute(PortletContext context, PortletRequest request, PortletResponse response, String pathInfo) throws IOException, PortletException {
        String contextPath = request.getContextPath();
        String requestUri = contextPath + SERVLET_PATH + pathInfo;
        request.setAttribute(EXPECTED_REQUEST_URI, (Object)requestUri);
        request.setAttribute(EXPECTED_CONTEXT_PATH, (Object)contextPath);
        StringBuffer buffer = new StringBuffer();
        buffer.append(SERVLET_PATH).append(pathInfo).append("?").append(QUERY_STRING);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Dispatching to: " + buffer.toString());
        }
        PortletRequestDispatcher dispatcher = context.getRequestDispatcher(buffer.toString());
        dispatcher.include((RenderRequest)request, (RenderResponse)response);
        TestResult result = (TestResult)request.getAttribute(RESULT_KEY);
        request.removeAttribute(RESULT_KEY);
        request.removeAttribute(EXPECTED_REQUEST_URI);
        request.removeAttribute(EXPECTED_CONTEXT_PATH);
        return result;
    }

    static /* synthetic */ String access$000() {
        return RESULT_KEY;
    }

    static /* synthetic */ String access$100() {
        return EXPECTED_REQUEST_URI;
    }

    static /* synthetic */ String access$200() {
        return EXPECTED_CONTEXT_PATH;
    }
}

