/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.util.install.file;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.io.FileUtils;
import org.apache.pluto.util.UtilityException;
import org.apache.pluto.util.install.InstallationConfig;
import org.apache.pluto.util.install.PortalInstaller;

public abstract class FileSystemInstaller
implements PortalInstaller {
    protected void copyFilesToDirectory(Collection dependencies, File destination) throws IOException {
        Iterator it = dependencies.iterator();
        while (it.hasNext()) {
            File from = (File)it.next();
            FileUtils.copyFileToDirectory((File)from, (File)destination);
        }
    }

    protected void removeFilesFromDirectory(Collection dependencies, File destination) throws IOException {
        Iterator it = dependencies.iterator();
        while (it.hasNext()) {
            File from = (File)it.next();
            File delete = new File(destination, from.getName());
            delete.delete();
        }
    }

    protected void copyFileToDirectory(File file, File destination) throws IOException {
        FileUtils.copyFileToDirectory((File)file, (File)destination);
    }

    public void install(InstallationConfig config) throws UtilityException {
        File endorsedDir = this.getEndorsedDir(config);
        File sharedDir = this.getSharedDir(config);
        File domainDir = this.getWebAppDir(config);
        endorsedDir.mkdirs();
        sharedDir.mkdirs();
        domainDir.mkdirs();
        try {
            this.copyFilesToDirectory(config.getEndorsedDependencies(), endorsedDir);
            this.copyFilesToDirectory(config.getSharedDependencies(), sharedDir);
            this.copyFilesToDirectory(config.getPortletApplications().values(), domainDir);
            this.copyFileToDirectory(config.getPortalApplication(), domainDir);
            this.writeConfiguration(config);
        }
        catch (IOException io) {
            throw new UtilityException("Unable to install portal to Tomcat", io, config.getInstallationDirectory());
        }
    }

    public abstract void writeConfiguration(InstallationConfig var1) throws IOException;

    protected abstract File getEndorsedDir(InstallationConfig var1);

    protected abstract File getSharedDir(InstallationConfig var1);

    protected abstract File getWebAppDir(InstallationConfig var1);

    public void uninstall(InstallationConfig config) throws UtilityException {
        File endorsedDir = this.getEndorsedDir(config);
        File sharedDir = this.getSharedDir(config);
        File domainDir = this.getWebAppDir(config);
        endorsedDir.mkdirs();
        sharedDir.mkdirs();
        domainDir.mkdirs();
        try {
            this.removeFilesFromDirectory(config.getEndorsedDependencies(), endorsedDir);
            this.removeFilesFromDirectory(config.getSharedDependencies(), sharedDir);
            this.removeFilesFromDirectory(config.getPortletApplications().values(), domainDir);
            File delete = new File(domainDir, config.getPortalApplication().getName());
            delete.delete();
        }
        catch (IOException io) {
            throw new UtilityException("Unable to remove files. ", io, config.getInstallationDirectory());
        }
    }

    public abstract boolean isValidInstallationDirectory(File var1);
}

