/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.sentdetect;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.sentdetect.EndOfSentenceScanner;
import opennlp.tools.sentdetect.SDContextGenerator;
import opennlp.tools.sentdetect.lang.Factory;
import opennlp.tools.util.BaseToolFactory;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.ext.ExtensionLoader;

public class SentenceDetectorFactory
extends BaseToolFactory {
    private String languageCode;
    private char[] eosCharacters;
    private Dictionary abbreviationDictionary;
    private Boolean useTokenEnd = null;
    private static final String ABBREVIATIONS_ENTRY_NAME = "abbreviations.dictionary";
    private static final String EOS_CHARACTERS_PROPERTY = "eosCharacters";
    private static final String TOKEN_END_PROPERTY = "useTokenEnd";

    public SentenceDetectorFactory() {
    }

    public SentenceDetectorFactory(String languageCode, boolean useTokenEnd, Dictionary abbreviationDictionary, char[] eosCharacters) {
        this.init(languageCode, useTokenEnd, abbreviationDictionary, eosCharacters);
    }

    protected void init(String languageCode, boolean useTokenEnd, Dictionary abbreviationDictionary, char[] eosCharacters) {
        this.languageCode = languageCode;
        this.useTokenEnd = useTokenEnd;
        this.eosCharacters = eosCharacters;
        this.abbreviationDictionary = abbreviationDictionary;
    }

    @Override
    public void validateArtifactMap() throws InvalidFormatException {
        if (this.artifactProvider.getManifestProperty(TOKEN_END_PROPERTY) == null) {
            throw new InvalidFormatException("useTokenEnd is a mandatory property!");
        }
        Object abbreviationsEntry = this.artifactProvider.getArtifact(ABBREVIATIONS_ENTRY_NAME);
        if (abbreviationsEntry != null && !(abbreviationsEntry instanceof Dictionary)) {
            throw new InvalidFormatException("Abbreviations dictionary '" + abbreviationsEntry + "' has wrong type, needs to be of type Dictionary!");
        }
    }

    @Override
    public Map<String, Object> createArtifactMap() {
        Map<String, Object> artifactMap = super.createArtifactMap();
        if (this.abbreviationDictionary != null) {
            artifactMap.put(ABBREVIATIONS_ENTRY_NAME, this.abbreviationDictionary);
        }
        return artifactMap;
    }

    @Override
    public Map<String, String> createManifestEntries() {
        Map<String, String> manifestEntries = super.createManifestEntries();
        manifestEntries.put(TOKEN_END_PROPERTY, Boolean.toString(this.isUseTokenEnd()));
        if (this.getEOSCharacters() != null) {
            manifestEntries.put(EOS_CHARACTERS_PROPERTY, this.eosCharArrayToString(this.getEOSCharacters()));
        }
        return manifestEntries;
    }

    public static SentenceDetectorFactory create(String subclassName, String languageCode, boolean useTokenEnd, Dictionary abbreviationDictionary, char[] eosCharacters) throws InvalidFormatException {
        if (subclassName == null) {
            return new SentenceDetectorFactory(languageCode, useTokenEnd, abbreviationDictionary, eosCharacters);
        }
        try {
            SentenceDetectorFactory theFactory = ExtensionLoader.instantiateExtension(SentenceDetectorFactory.class, subclassName);
            theFactory.init(languageCode, useTokenEnd, abbreviationDictionary, eosCharacters);
            return theFactory;
        }
        catch (Exception e) {
            String msg = "Could not instantiate the " + subclassName + ". The initialization throw an exception.";
            System.err.println(msg);
            e.printStackTrace();
            throw new InvalidFormatException(msg, e);
        }
    }

    public char[] getEOSCharacters() {
        if (this.eosCharacters == null) {
            if (this.artifactProvider != null) {
                String prop = this.artifactProvider.getManifestProperty(EOS_CHARACTERS_PROPERTY);
                if (prop != null) {
                    this.eosCharacters = this.eosStringToCharArray(prop);
                }
            } else {
                Factory f = new Factory();
                this.eosCharacters = f.getEOSCharacters(this.languageCode);
            }
        }
        return this.eosCharacters;
    }

    public boolean isUseTokenEnd() {
        if (this.useTokenEnd == null && this.artifactProvider != null) {
            this.useTokenEnd = Boolean.valueOf(this.artifactProvider.getManifestProperty(TOKEN_END_PROPERTY));
        }
        return this.useTokenEnd;
    }

    public Dictionary getAbbreviationDictionary() {
        if (this.abbreviationDictionary == null && this.artifactProvider != null) {
            this.abbreviationDictionary = (Dictionary)this.artifactProvider.getArtifact(ABBREVIATIONS_ENTRY_NAME);
        }
        return this.abbreviationDictionary;
    }

    public String getLanguageCode() {
        if (this.languageCode == null && this.artifactProvider != null) {
            this.languageCode = this.artifactProvider.getLanguage();
        }
        return this.languageCode;
    }

    public EndOfSentenceScanner getEndOfSentenceScanner() {
        Factory f = new Factory();
        char[] eosChars = this.getEOSCharacters();
        if (eosChars != null && eosChars.length > 0) {
            return f.createEndOfSentenceScanner(eosChars);
        }
        return f.createEndOfSentenceScanner(this.languageCode);
    }

    public SDContextGenerator getSDContextGenerator() {
        Factory f = new Factory();
        char[] eosChars = this.getEOSCharacters();
        Dictionary abbDict = this.getAbbreviationDictionary();
        Set<String> abbs = abbDict != null ? abbDict.asStringSet() : Collections.emptySet();
        if (eosChars != null && eosChars.length > 0) {
            return f.createSentenceContextGenerator(abbs, eosChars);
        }
        return f.createSentenceContextGenerator(this.languageCode, abbs);
    }

    private String eosCharArrayToString(char[] eosCharacters) {
        return String.valueOf(eosCharacters);
    }

    private char[] eosStringToCharArray(String eosCharacters) {
        return eosCharacters.toCharArray();
    }
}

