/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc;

import java.security.AccessController;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.conf.OpenJPAProductDerivation;
import org.apache.openjpa.conf.Specification;
import org.apache.openjpa.jdbc.conf.JDBCConfigurationImpl;
import org.apache.openjpa.jdbc.kernel.JDBCStoreManager;
import org.apache.openjpa.lib.conf.AbstractProductDerivation;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.persistence.FetchPlan;
import org.apache.openjpa.persistence.PersistenceProductDerivation;
import org.apache.openjpa.persistence.jdbc.JDBCFetchPlanImpl;
import org.apache.openjpa.persistence.jdbc.PersistenceMappingDefaults;
import org.apache.openjpa.persistence.jdbc.PersistenceMappingFactory;

public class JDBCPersistenceProductDerivation
extends AbstractProductDerivation
implements OpenJPAProductDerivation {
    public void putBrokerFactoryAliases(Map m) {
    }

    public int getType() {
        return 300;
    }

    public void validate() throws Exception {
        AccessController.doPrivileged(J2DoPrivHelper.getClassLoaderAction(EntityManagerFactory.class));
    }

    public boolean beforeConfigurationLoad(Configuration c) {
        if (c instanceof OpenJPAConfiguration) {
            ((OpenJPAConfiguration)c).getStoreFacadeTypeRegistry().registerImplementation(FetchPlan.class, JDBCStoreManager.class, JDBCFetchPlanImpl.class);
        }
        if (!(c instanceof JDBCConfigurationImpl)) {
            return false;
        }
        JDBCConfigurationImpl conf = (JDBCConfigurationImpl)c;
        Specification jpa = PersistenceProductDerivation.SPEC_JPA;
        Specification ejb = PersistenceProductDerivation.ALIAS_EJB;
        conf.metaFactoryPlugin.setAlias(ejb.getName(), PersistenceMappingFactory.class.getName());
        conf.metaFactoryPlugin.setAlias(jpa.getName(), PersistenceMappingFactory.class.getName());
        conf.mappingFactoryPlugin.setAlias(ejb.getName(), PersistenceMappingFactory.class.getName());
        conf.mappingFactoryPlugin.setAlias(jpa.getName(), PersistenceMappingFactory.class.getName());
        conf.mappingDefaultsPlugin.setAlias(ejb.getName(), PersistenceMappingDefaults.class.getName());
        conf.mappingDefaultsPlugin.setAlias(jpa.getName(), PersistenceMappingDefaults.class.getName());
        return true;
    }

    public boolean afterSpecificationSet(Configuration c) {
        if (!(c instanceof JDBCConfigurationImpl)) {
            return false;
        }
        JDBCConfigurationImpl conf = (JDBCConfigurationImpl)c;
        Specification jpa = PersistenceProductDerivation.SPEC_JPA;
        if (!jpa.getName().equals(conf.getSpecificationInstance().getName())) {
            return false;
        }
        conf.mappingDefaultsPlugin.setDefault(jpa.getName());
        conf.mappingDefaultsPlugin.setString(jpa.getName());
        return true;
    }
}

