/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303.xml;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnnotationIgnores {
    private static final Logger log = LoggerFactory.getLogger(AnnotationIgnores.class);
    private final Map<Class<?>, Boolean> ignoreAnnotationDefaults = new HashMap();
    private final Map<Class<?>, List<Member>> ignoreAnnotationOnMember = new HashMap();
    private final Map<Class<?>, Boolean> ignoreAnnotationOnClass = new HashMap();

    public void setDefaultIgnoreAnnotation(Class<?> clazz, Boolean b) {
        this.ignoreAnnotationDefaults.put(clazz, b == null || b != false);
    }

    public boolean getDefaultIgnoreAnnotation(Class<?> clazz) {
        return this.ignoreAnnotationDefaults.containsKey(clazz) && this.ignoreAnnotationDefaults.get(clazz) != false;
    }

    public void setIgnoreAnnotationsOnMember(Member member) {
        Class<?> beanClass = member.getDeclaringClass();
        List<Member> memberList = this.ignoreAnnotationOnMember.get(beanClass);
        if (memberList == null) {
            memberList = new ArrayList<Member>();
            this.ignoreAnnotationOnMember.put(beanClass, memberList);
        }
        memberList.add(member);
    }

    public boolean isIgnoreAnnotations(Member member) {
        Class<?> clazz = member.getDeclaringClass();
        List<Member> ignoreAnnotationForMembers = this.ignoreAnnotationOnMember.get(clazz);
        boolean ignoreAnnotation = ignoreAnnotationForMembers == null || !ignoreAnnotationForMembers.contains(member) ? this.getDefaultIgnoreAnnotation(clazz) : ignoreAnnotationForMembers.contains(member);
        if (ignoreAnnotation) {
            this.logMessage(member, clazz);
        }
        return ignoreAnnotation;
    }

    private void logMessage(Member member, Class<?> clazz) {
        String type = member instanceof Field ? "Field" : "Property";
        log.debug("{} level annotations are getting ignored for {}.{}", new Object[]{type, clazz.getName(), member.getName()});
    }

    public void setIgnoreAnnotationsOnClass(Class<?> clazz, boolean b) {
        this.ignoreAnnotationOnClass.put(clazz, b);
    }

    public boolean isIgnoreAnnotations(Class<?> clazz) {
        boolean ignoreAnnotation = this.ignoreAnnotationOnClass.containsKey(clazz) ? this.ignoreAnnotationOnClass.get(clazz).booleanValue() : this.getDefaultIgnoreAnnotation(clazz);
        if (ignoreAnnotation) {
            log.debug("Class level annotation are getting ignored for {}", (Object)clazz.getName());
        }
        return ignoreAnnotation;
    }
}

