/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.listeners;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.quartz.JobDetail;
import org.quartz.SchedulerException;
import org.quartz.SchedulerListener;
import org.quartz.Trigger;

public class BroadcastSchedulerListener
implements SchedulerListener {
    private List listeners = new LinkedList();

    public BroadcastSchedulerListener() {
    }

    public BroadcastSchedulerListener(List listeners) {
        this();
        this.listeners.addAll(listeners);
    }

    public void addListener(SchedulerListener listener) {
        this.listeners.add(listener);
    }

    public boolean removeListener(SchedulerListener listener) {
        return this.listeners.remove(listener);
    }

    public List getListeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    public void jobAdded(JobDetail jobDetail) {
        for (SchedulerListener l : this.listeners) {
            l.jobAdded(jobDetail);
        }
    }

    public void jobDeleted(String jobName, String groupName) {
        for (SchedulerListener l : this.listeners) {
            l.jobDeleted(jobName, groupName);
        }
    }

    public void jobScheduled(Trigger trigger) {
        for (SchedulerListener l : this.listeners) {
            l.jobScheduled(trigger);
        }
    }

    public void jobUnscheduled(String triggerName, String triggerGroup) {
        for (SchedulerListener l : this.listeners) {
            l.jobUnscheduled(triggerName, triggerGroup);
        }
    }

    public void triggerFinalized(Trigger trigger) {
        for (SchedulerListener l : this.listeners) {
            l.triggerFinalized(trigger);
        }
    }

    public void triggersPaused(String triggerName, String triggerGroup) {
        for (SchedulerListener l : this.listeners) {
            l.triggersPaused(triggerName, triggerGroup);
        }
    }

    public void triggersResumed(String triggerName, String triggerGroup) {
        for (SchedulerListener l : this.listeners) {
            l.triggersResumed(triggerName, triggerGroup);
        }
    }

    public void jobsPaused(String jobName, String jobGroup) {
        for (SchedulerListener l : this.listeners) {
            l.jobsPaused(jobName, jobGroup);
        }
    }

    public void jobsResumed(String jobName, String jobGroup) {
        for (SchedulerListener l : this.listeners) {
            l.jobsResumed(jobName, jobGroup);
        }
    }

    public void schedulerError(String msg, SchedulerException cause) {
        for (SchedulerListener l : this.listeners) {
            l.schedulerError(msg, cause);
        }
    }

    public void schedulerStarted() {
        for (SchedulerListener l : this.listeners) {
            l.schedulerStarted();
        }
    }

    public void schedulerInStandbyMode() {
        for (SchedulerListener l : this.listeners) {
            l.schedulerInStandbyMode();
        }
    }

    public void schedulerShutdown() {
        for (SchedulerListener l : this.listeners) {
            l.schedulerShutdown();
        }
    }

    public void schedulerShuttingdown() {
        for (SchedulerListener l : this.listeners) {
            l.schedulerShuttingdown();
        }
    }
}

