/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.jobs.ee.jms;

import javax.jms.Message;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.naming.InitialContext;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.jobs.ee.jms.JmsHelper;
import org.quartz.jobs.ee.jms.JmsMessageFactory;

public final class SendTopicMessageJob
implements Job {
    public void execute(JobExecutionContext jobCtx) throws JobExecutionException {
        TopicConnection conn = null;
        TopicSession sess = null;
        TopicPublisher publisher = null;
        try {
            try {
                JobDetail detail = jobCtx.getJobDetail();
                JobDataMap dataMap = detail.getJobDataMap();
                InitialContext namingCtx = JmsHelper.getInitialContext(dataMap);
                TopicConnectionFactory connFactory = (TopicConnectionFactory)namingCtx.lookup(dataMap.getString("jms.connection.factory"));
                if (!JmsHelper.isDestinationSecure(dataMap)) {
                    conn = connFactory.createTopicConnection();
                } else {
                    String user = dataMap.getString("jms.user");
                    String password = dataMap.getString("jms.password");
                    conn = connFactory.createTopicConnection(user, password);
                }
                boolean useTransaction = JmsHelper.useTransaction(dataMap);
                int ackMode = dataMap.getInt("jms.acknowledge");
                sess = (TopicSession)conn.createSession(useTransaction, ackMode);
                Topic topic = (Topic)namingCtx.lookup(dataMap.getString("jms.destination"));
                publisher = sess.createPublisher(topic);
                String msgFactoryClassName = dataMap.getString("jms.message.factory.class.name");
                JmsMessageFactory messageFactory = JmsHelper.getMessageFactory(msgFactoryClassName);
                Message msg = messageFactory.createMessage(dataMap, sess);
                publisher.publish(msg);
            }
            catch (Exception e) {
                throw new JobExecutionException(e);
            }
            Object var16_18 = null;
        }
        catch (Throwable throwable) {
            Object var16_19 = null;
            JmsHelper.closeResource(publisher);
            JmsHelper.closeResource(sess);
            JmsHelper.closeResource(conn);
            throw throwable;
        }
        JmsHelper.closeResource(publisher);
        JmsHelper.closeResource(sess);
        JmsHelper.closeResource(conn);
    }
}

