/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.context.creational;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.enterprise.context.spi.Contextual;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.util.WebBeansUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependentCreationalContext<S>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Contextual<S> contextual;
    private DependentType dependentType;
    private Object instance;

    public Object getInstance() {
        return this.instance;
    }

    public void setInstance(Object instance) {
        this.instance = instance;
    }

    public DependentCreationalContext(Contextual<S> contextual) {
        this.contextual = contextual;
    }

    public DependentType getDependentType() {
        return this.dependentType;
    }

    public void setDependentType(DependentType dependentType) {
        this.dependentType = dependentType;
    }

    public Contextual<S> getContextual() {
        return this.contextual;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.writeObject((Object)this.dependentType);
        s.writeObject(this.instance);
        if (this.contextual != null) {
            String id = WebBeansUtil.isPassivationCapable(this.contextual);
            if (id == null) throw new NotSerializableException("cannot serialize " + this.contextual.toString());
            s.writeObject(id);
            return;
        } else {
            s.writeObject(null);
        }
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.dependentType = (DependentType)((Object)s.readObject());
        this.instance = s.readObject();
        String id = (String)s.readObject();
        if (id != null) {
            WebBeansContext webBeansContext = WebBeansContext.currentInstance();
            this.contextual = webBeansContext.getBeanManagerImpl().getPassivationCapableBean(id);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DependentType {
        DECORATOR,
        INTERCEPTOR,
        BEAN;

    }
}

