/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.kernel;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.openjpa.datacache.QueryCache;
import org.apache.openjpa.datacache.QueryCacheStoreQuery;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.event.OrphanedKeyAction;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.kernel.ConnectionInfo;
import org.apache.openjpa.jdbc.kernel.FinderQueryImpl;
import org.apache.openjpa.jdbc.kernel.InstanceResultObjectProvider;
import org.apache.openjpa.jdbc.kernel.JDBCFetchConfiguration;
import org.apache.openjpa.jdbc.kernel.JDBCFetchConfigurationImpl;
import org.apache.openjpa.jdbc.kernel.JDBCLockManager;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.kernel.JDBCStoreQuery;
import org.apache.openjpa.jdbc.kernel.PagingResultObjectProvider;
import org.apache.openjpa.jdbc.kernel.PreparedSQLStoreQuery;
import org.apache.openjpa.jdbc.kernel.SQLStoreQuery;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.Discriminator;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.meta.ValueMapping;
import org.apache.openjpa.jdbc.meta.strats.SuperclassDiscriminatorStrategy;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.Joins;
import org.apache.openjpa.jdbc.sql.Result;
import org.apache.openjpa.jdbc.sql.SQLExceptions;
import org.apache.openjpa.jdbc.sql.SQLFactory;
import org.apache.openjpa.jdbc.sql.Select;
import org.apache.openjpa.jdbc.sql.SelectExecutor;
import org.apache.openjpa.jdbc.sql.Union;
import org.apache.openjpa.kernel.BrokerImpl;
import org.apache.openjpa.kernel.FetchConfiguration;
import org.apache.openjpa.kernel.FinderCache;
import org.apache.openjpa.kernel.LockManager;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.kernel.PCState;
import org.apache.openjpa.kernel.QueryLanguages;
import org.apache.openjpa.kernel.Seq;
import org.apache.openjpa.kernel.StoreContext;
import org.apache.openjpa.kernel.StoreManager;
import org.apache.openjpa.kernel.StoreQuery;
import org.apache.openjpa.kernel.exps.ExpressionParser;
import org.apache.openjpa.lib.jdbc.DelegatingConnection;
import org.apache.openjpa.lib.jdbc.DelegatingPreparedStatement;
import org.apache.openjpa.lib.jdbc.DelegatingStatement;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.rop.MergedResultObjectProvider;
import org.apache.openjpa.lib.rop.ResultObjectProvider;
import org.apache.openjpa.lib.util.ConcreteClassGenerator;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.util.ApplicationIds;
import org.apache.openjpa.util.Exceptions;
import org.apache.openjpa.util.Id;
import org.apache.openjpa.util.ImplHelper;
import org.apache.openjpa.util.InvalidStateException;
import org.apache.openjpa.util.OpenJPAId;
import org.apache.openjpa.util.StoreException;
import org.apache.openjpa.util.UserException;

public class JDBCStoreManager
implements StoreManager,
JDBCStore {
    private static final Localizer _loc = Localizer.forPackage(JDBCStoreManager.class);
    private StoreContext _ctx = null;
    private JDBCConfiguration _conf = null;
    private DBDictionary _dict = null;
    private SQLFactory _sql = null;
    private JDBCLockManager _lm = null;
    private DataSource _ds = null;
    private RefCountConnection _conn = null;
    private boolean _active = false;
    private Log _log = null;
    private Set<Statement> _stmnts = Collections.synchronizedSet(new HashSet());
    private static final Constructor<ClientConnection> clientConnectionImpl;
    private static final Constructor<RefCountConnection> refCountConnectionImpl;
    private static final Constructor<CancelStatement> cancelStatementImpl;
    private static final Constructor<CancelPreparedStatement> cancelPreparedStatementImpl;

    @Override
    public StoreContext getContext() {
        return this._ctx;
    }

    @Override
    public void setContext(StoreContext ctx) {
        this.setContext(ctx, (JDBCConfiguration)ctx.getConfiguration());
    }

    public void setContext(StoreContext ctx, JDBCConfiguration conf) {
        this._ctx = ctx;
        this._conf = conf;
        this._dict = this._conf.getDBDictionaryInstance();
        this._sql = this._conf.getSQLFactoryInstance();
        this._log = this._conf.getLog("openjpa.jdbc.SQLDiag");
        LockManager lm = ctx.getLockManager();
        if (lm instanceof JDBCLockManager) {
            this._lm = (JDBCLockManager)lm;
        }
        this._ds = this.getDataSource(ctx);
        if (this._conf.getUpdateManagerInstance().orderDirty()) {
            ctx.setOrderDirtyObjects(true);
        }
    }

    private final boolean useConnectionFactory2(StoreContext ctx) {
        return !ctx.isManaged() && this._conf.isConnectionFactoryModeManaged();
    }

    private final DataSource getDataSource(StoreContext ctx) {
        DataSource ds = this.useConnectionFactory2(ctx) ? this._conf.getDataSource2(ctx) : this._conf.getDataSource(ctx);
        return ds;
    }

    @Override
    public JDBCConfiguration getConfiguration() {
        return this._conf;
    }

    @Override
    public DBDictionary getDBDictionary() {
        return this._dict;
    }

    @Override
    public SQLFactory getSQLFactory() {
        return this._sql;
    }

    @Override
    public JDBCLockManager getLockManager() {
        return this._lm;
    }

    @Override
    public JDBCFetchConfiguration getFetchConfiguration() {
        return (JDBCFetchConfiguration)this._ctx.getFetchConfiguration();
    }

    @Override
    public void beginOptimistic() {
    }

    @Override
    public void rollbackOptimistic() {
    }

    @Override
    public void begin() {
        this._active = true;
        try {
            if (!(this._ctx.isManaged() && this._conf.isConnectionFactoryModeManaged() || !this._conn.getAutoCommit())) {
                this._conn.setAutoCommit(false);
            }
        }
        catch (SQLException se) {
            this._active = false;
            throw SQLExceptions.getStore(se, this._dict);
        }
    }

    @Override
    public void commit() {
        try {
            if (!this._ctx.isManaged() || !this._conf.isConnectionFactoryModeManaged()) {
                this._conn.commit();
            }
        }
        catch (SQLException se) {
            try {
                this._conn.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw SQLExceptions.getStore(se, this._dict);
        }
        finally {
            this._active = false;
        }
    }

    @Override
    public void rollback() {
        if (!this._active) {
            return;
        }
        try {
            if (!(this._conn == null || this._ctx.isManaged() && this._conf.isConnectionFactoryModeManaged())) {
                this._conn.rollback();
            }
        }
        catch (SQLException se) {
            throw SQLExceptions.getStore(se, this._dict);
        }
        finally {
            this._active = false;
        }
    }

    @Override
    public void retainConnection() {
        this.connect(false);
        this._conn.setRetain(true);
    }

    @Override
    public void releaseConnection() {
        if (this._conn != null) {
            this._conn.setRetain(false);
        }
    }

    @Override
    public Object getClientConnection() {
        return ConcreteClassGenerator.newInstance(clientConnectionImpl, this.getConnection());
    }

    @Override
    public Connection getConnection() {
        this.connect(true);
        return this._conn;
    }

    protected DataSource getDataSource() {
        return this._ds;
    }

    @Override
    public boolean exists(OpenJPAStateManager sm, Object context) {
        ClassMapping mapping = (ClassMapping)sm.getMetaData();
        return this.exists(mapping, sm.getObjectId(), context);
    }

    @Override
    public boolean isCached(List<Object> oids, BitSet edata) {
        return false;
    }

    private boolean exists(ClassMapping mapping, Object oid, Object context) {
        Select sel = this._sql.newSelect();
        while (mapping.getJoinablePCSuperclassMapping() != null) {
            mapping = mapping.getJoinablePCSuperclassMapping();
        }
        sel.wherePrimaryKey(oid, mapping, this);
        if (this._log.isTraceEnabled()) {
            this._log.trace("exists: oid=" + oid + " " + mapping.getDescribedType());
        }
        try {
            return sel.getCount(this) != 0;
        }
        catch (SQLException se) {
            throw SQLExceptions.getStore(se, this._dict);
        }
    }

    @Override
    public boolean syncVersion(OpenJPAStateManager sm, Object context) {
        ClassMapping mapping = (ClassMapping)sm.getMetaData();
        try {
            return mapping.getVersion().checkVersion(sm, this, true);
        }
        catch (SQLException se) {
            throw SQLExceptions.getStore(se, this._dict, this.getReadLockLevel());
        }
    }

    private int getReadLockLevel() {
        JDBCFetchConfiguration fetch = this.getFetchConfiguration();
        if (fetch != null) {
            return fetch.getReadLockLevel();
        }
        return -1;
    }

    @Override
    public int compareVersion(OpenJPAStateManager state, Object v1, Object v2) {
        ClassMapping mapping = (ClassMapping)state.getMetaData();
        return mapping.getVersion().compareVersion(v1, v2);
    }

    @Override
    public boolean initialize(OpenJPAStateManager sm, PCState state, FetchConfiguration fetch, Object context) {
        ConnectionInfo info = (ConnectionInfo)context;
        try {
            return this.initializeState(sm, state, (JDBCFetchConfiguration)fetch, info);
        }
        catch (ClassNotFoundException cnfe) {
            throw new UserException(cnfe);
        }
        catch (SQLException se) {
            throw SQLExceptions.getStore(se, Exceptions.toString(sm.getPersistenceCapable()), this._dict, fetch.getReadLockLevel());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean initializeState(OpenJPAStateManager sm, PCState state, JDBCFetchConfiguration fetch, ConnectionInfo info) throws ClassNotFoundException, SQLException {
        Object oid = sm.getObjectId();
        ClassMapping mapping = (ClassMapping)sm.getMetaData();
        Result res = null;
        try {
            if (info != null && info.result != null) {
                res = info.result;
                info.sm = sm;
                if (info.mapping == null) {
                    info.mapping = mapping;
                }
                mapping = info.mapping;
            } else if (oid instanceof OpenJPAId && !((OpenJPAId)oid).hasSubclasses()) {
                Boolean custom = this.customLoad(sm, mapping, state, fetch);
                if (custom != null) {
                    boolean bl = custom;
                    return bl;
                }
                res = this.getInitializeStateResult(sm, mapping, fetch, 4);
                if (res == null && !this.selectPrimaryKey(sm, mapping, fetch)) {
                    boolean bl = false;
                    return bl;
                }
                if (this.isEmptyResult(res)) {
                    boolean bl = false;
                    return bl;
                }
            } else {
                ClassMapping[] mappings = mapping.getIndependentAssignableMappings();
                if (mappings.length == 1) {
                    mapping = mappings[0];
                    Boolean custom = this.customLoad(sm, mapping, state, fetch);
                    if (custom != null) {
                        boolean bl = custom;
                        return bl;
                    }
                    res = this.getInitializeStateResult(sm, mapping, fetch, 3);
                    if (res == null && !this.selectPrimaryKey(sm, mapping, fetch)) {
                        boolean bl = false;
                        return bl;
                    }
                } else {
                    res = this.getInitializeStateUnionResult(sm, mapping, mappings, fetch);
                }
                if (this.isEmptyResult(res)) {
                    boolean custom = false;
                    return custom;
                }
            }
            Class<?> type = this.getType(res, mapping);
            if (type == null) {
                if (res.getBaseMapping() != null) {
                    mapping = res.getBaseMapping();
                }
                res.startDataRequest(mapping.getDiscriminator());
                try {
                    type = mapping.getDiscriminator().getClass(this, mapping, res);
                }
                finally {
                    res.endDataRequest();
                }
            }
            sm.initialize(type, state);
            if (info != null && info.result != null) {
                FieldMapping mappedByFieldMapping = info.result.getMappedByFieldMapping();
                Object mappedByObject = info.result.getMappedByValue();
                if (mappedByFieldMapping != null && mappedByObject != null) {
                    if (mappedByObject instanceof OpenJPAId && mapping.getExtraFieldDataIndex(mappedByFieldMapping.getIndex()) != -1) {
                        int index = mappedByFieldMapping.getIndex();
                        if (sm.getLoaded().get(index)) {
                            sm.setImplData(index, mappedByObject);
                        } else {
                            sm.setIntermediate(index, mappedByObject);
                        }
                    } else {
                        this.setMappedBy(sm, mappedByFieldMapping, mappedByObject);
                    }
                }
            }
            if (res != null) {
                mapping = (ClassMapping)sm.getMetaData();
                this.load(mapping, sm, fetch, res);
                this.getVersion(mapping, sm, res);
                this.setInverseRelation(sm, mapping, res);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (res != null && (info == null || res != info.result)) {
                res.close();
            }
        }
    }

    private void setInverseRelation(OpenJPAStateManager owner, ClassMapping mapping, Result res) {
        FieldMapping[] fms = mapping.getFieldMappings();
        for (int i = 0; i < fms.length; ++i) {
            if (res.getEager(fms[i]) == null || !fms[i].getElement().isTypePC()) continue;
            Collection coll = owner.fetchObject(fms[i].getIndex());
            if (coll instanceof Map) {
                coll = ((Map)((Object)coll)).values();
            }
            if (!(coll instanceof Collection) || coll.size() <= 0) continue;
            block1: for (PersistenceCapable pc : coll) {
                if (pc == null) continue;
                OpenJPAStateManager sm = (OpenJPAStateManager)pc.pcGetStateManager();
                ClassMapping cm = (ClassMapping)this._conf.getMetaDataRepositoryInstance().getCachedMetaData(pc.getClass());
                FieldMapping[] fmd = cm.getFieldMappings();
                for (int j = 0; j < fmd.length; ++j) {
                    Object oid;
                    if (!fmd[j].isTypePC() || (oid = sm.getIntermediate(fmd[j].getIndex())) == null || !oid.equals(owner.getObjectId())) continue;
                    sm.storeObject(fmd[j].getIndex(), owner.getPersistenceCapable());
                    continue block1;
                }
            }
        }
    }

    protected void setMappedBy(OpenJPAStateManager sm, FieldMapping mappedByFieldMapping, Object mappedByObject) {
        ClassMapping mapping = (ClassMapping)sm.getMetaData();
        FieldMapping[] fms = mapping.getFieldMappings();
        for (int i = 0; i < fms.length; ++i) {
            if (fms[i] != mappedByFieldMapping) continue;
            sm.storeObject(fms[i].getIndex(), mappedByObject);
            return;
        }
    }

    protected void getVersion(ClassMapping mapping, OpenJPAStateManager sm, Result res) throws SQLException {
        mapping.getVersion().afterLoad(sm, this);
    }

    protected boolean isEmptyResult(Result res) throws SQLException {
        return res != null && !res.next();
    }

    protected Class<?> getType(Result res, ClassMapping mapping) {
        if (res == null) {
            return mapping.getDescribedType();
        }
        return null;
    }

    private Boolean customLoad(OpenJPAStateManager sm, ClassMapping mapping, PCState state, JDBCFetchConfiguration fetch) throws ClassNotFoundException, SQLException {
        if (!mapping.customLoad(sm, (JDBCStore)this, state, fetch)) {
            return null;
        }
        if (sm.getManagedInstance() != null) {
            mapping.getVersion().afterLoad(sm, this);
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private Result getInitializeStateResult(OpenJPAStateManager sm, ClassMapping mapping, JDBCFetchConfiguration fetch, int subs) throws SQLException {
        FinderQueryImpl fq = this.getFinder(mapping, fetch);
        if (fq != null) {
            return fq.execute(sm, this, fetch);
        }
        Select sel = this._sql.newSelect();
        if (!this.select(sel, mapping, subs, sm, null, fetch, 1, true, false)) {
            return null;
        }
        sel.wherePrimaryKey(sm.getObjectId(), mapping, this);
        sel.setExpectedResultCount(1, false);
        if (this._log.isTraceEnabled()) {
            this._log.trace("getInitializeStateResult: oid=" + sm.getObjectId() + " " + mapping.getDescribedType());
        }
        Result result = sel.execute(this, fetch);
        this.cacheFinder(mapping, sel, fetch);
        return result;
    }

    private Result getInitializeStateUnionResult(final OpenJPAStateManager sm, ClassMapping mapping, final ClassMapping[] mappings, final JDBCFetchConfiguration fetch) throws SQLException {
        FinderQueryImpl fq = this.getFinder(mapping, fetch);
        if (fq != null) {
            return fq.execute(sm, this, fetch);
        }
        final JDBCStoreManager store = this;
        final int eager = Math.min(fetch.getEagerFetchMode(), 1);
        Union union = this._sql.newUnion(mappings.length);
        union.setExpectedResultCount(1, false);
        if (fetch.getSubclassFetchMode(mapping) != 1) {
            union.abortUnion();
        }
        union.select(new Union.Selector(){

            @Override
            public void select(Select sel, int i) {
                sel.select(mappings[i], 3, store, fetch, eager);
                sel.wherePrimaryKey(sm.getObjectId(), mappings[i], store);
            }
        });
        Result result = union.execute(this, fetch);
        this.cacheFinder(mapping, union, fetch);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean selectPrimaryKey(OpenJPAStateManager sm, ClassMapping mapping, JDBCFetchConfiguration fetch) throws SQLException {
        ClassMapping base = mapping;
        while (base.getJoinablePCSuperclassMapping() != null) {
            base = base.getJoinablePCSuperclassMapping();
        }
        Select sel = this._sql.newSelect();
        sel.select(base.getPrimaryKeyColumns());
        sel.wherePrimaryKey(sm.getObjectId(), base, this);
        if (this._log.isTraceEnabled()) {
            this._log.trace("selectPrimaryKey: oid=" + sm.getObjectId() + " " + mapping.getDescribedType());
        }
        Result exists = sel.execute(this, fetch);
        try {
            if (this.isEmptyResult(exists)) {
                boolean bl = false;
                return bl;
            }
            if (this._active && this._lm != null && exists.isLocking()) {
                this._lm.loadedForUpdate(sm);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            exists.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean load(OpenJPAStateManager sm, BitSet fields, FetchConfiguration fetch, int lockLevel, Object context) {
        JDBCFetchConfiguration jfetch = (JDBCFetchConfiguration)fetch;
        ConnectionInfo info = (ConnectionInfo)context;
        Result res = null;
        if (info != null) {
            if (info.sm != sm) {
                res = info.result;
            }
            info.sm = null;
        }
        try {
            Select sel;
            ClassMapping mapping = (ClassMapping)sm.getMetaData();
            if (res != null) {
                this.load(mapping, sm, jfetch, res);
                this.removeLoadedFields(sm, fields);
            }
            if (sm.getLoaded().length() == 0 && mapping.customLoad(sm, (JDBCStore)this, null, jfetch)) {
                this.removeLoadedFields(sm, fields);
            }
            if (this.select(sel = this._sql.newSelect(), mapping, 4, sm, fields, jfetch, 1, true, false)) {
                sel.wherePrimaryKey(sm.getObjectId(), mapping, this);
                if (this._log.isTraceEnabled()) {
                    this._log.trace("load: " + mapping.getDescribedType() + " oid: " + sm.getObjectId());
                }
                res = sel.execute(this, jfetch, lockLevel);
                try {
                    if (this.isEmptyResult(res)) {
                        boolean bl = false;
                        return bl;
                    }
                    this.load(mapping, sm, jfetch, res);
                }
                finally {
                    res.close();
                }
            }
            FieldMapping[] fms = mapping.getFieldMappings();
            int i = 0;
            while (true) {
                if (i >= fms.length) {
                    mapping.getVersion().afterLoad(sm, this);
                    return true;
                }
                if (fields.get(i) && !sm.getLoaded().get(i)) {
                    if (this._log.isTraceEnabled()) {
                        this._log.trace("load field: '" + fms[i].getName() + "' for oid=" + sm.getObjectId() + " " + mapping.getDescribedType());
                    }
                    fms[i].load(sm, this, jfetch.traverseJDBC(fms[i]));
                }
                ++i;
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new StoreException(cnfe);
        }
        catch (SQLException se) {
            throw SQLExceptions.getStore(se, this._dict, lockLevel);
        }
    }

    private void removeLoadedFields(OpenJPAStateManager sm, BitSet fields) {
        int len = fields.length();
        for (int i = 0; i < len; ++i) {
            if (!fields.get(i) || !sm.getLoaded().get(i)) continue;
            fields.clear(i);
        }
    }

    public Collection loadAll(Collection sms, PCState state, int load, FetchConfiguration fetch, Object context) {
        return ImplHelper.loadAll(sms, this, state, load, fetch, context);
    }

    @Override
    public void beforeStateChange(OpenJPAStateManager sm, PCState fromState, PCState toState) {
    }

    public Collection flush(Collection sms) {
        try {
            if (this._conn != null && this._conn.getInnermostDelegate().isReadOnly()) {
                this._conn.setReadOnly(false);
            }
        }
        catch (SQLException e) {
            // empty catch block
        }
        if (this._log.isTraceEnabled()) {
            for (OpenJPAStateManager sm : sms) {
                this._log.trace("flush: " + sm.getPCState().getClass().getName() + " for oid=" + sm.getObjectId());
            }
        }
        return this._conf.getUpdateManagerInstance().flush(sms, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancelAll() {
        ArrayList<Statement> stmnts;
        Set<Statement> set = this._stmnts;
        synchronized (set) {
            if (this._stmnts.isEmpty()) {
                return false;
            }
            stmnts = new ArrayList<Statement>(this._stmnts);
        }
        try {
            Iterator itr = stmnts.iterator();
            while (itr.hasNext()) {
                ((Statement)itr.next()).cancel();
            }
            return true;
        }
        catch (SQLException se) {
            throw SQLExceptions.getStore(se, this._dict);
        }
    }

    @Override
    public boolean assignObjectId(OpenJPAStateManager sm, boolean preFlush) {
        ClassMetaData meta = sm.getMetaData();
        if (meta.getIdentityType() == 2) {
            return ApplicationIds.assign(sm, this, preFlush);
        }
        Object val = ImplHelper.generateIdentityValue(this._ctx, meta, 6);
        if (val == null && meta.getIdentityStrategy() != 1) {
            return false;
        }
        if (val == null) {
            val = this.getDataStoreIdSequence(meta).next(this._ctx, meta);
        }
        sm.setObjectId(this.newDataStoreId(val, meta));
        return true;
    }

    @Override
    public boolean assignField(OpenJPAStateManager sm, int field, boolean preFlush) {
        FieldMetaData fmd = sm.getMetaData().getField(field);
        Object val = ImplHelper.generateFieldValue(this._ctx, fmd);
        if (val == null) {
            return false;
        }
        sm.store(field, val);
        return true;
    }

    @Override
    public Class<?> getManagedType(Object oid) {
        if (oid instanceof Id) {
            return ((Id)oid).getType();
        }
        return null;
    }

    @Override
    public Class<?> getDataStoreIdType(ClassMetaData meta) {
        return Id.class;
    }

    @Override
    public Object copyDataStoreId(Object oid, ClassMetaData meta) {
        Id id = (Id)oid;
        return new Id(meta.getDescribedType(), id.getId(), id.hasSubclasses());
    }

    @Override
    public Object newDataStoreId(Object val, ClassMetaData meta) {
        return Id.newInstance(meta.getDescribedType(), val);
    }

    @Override
    public Id newDataStoreId(long id, ClassMapping mapping, boolean subs) {
        return new Id(mapping.getDescribedType(), id, subs);
    }

    @Override
    public ResultObjectProvider executeExtent(ClassMetaData meta, final boolean subclasses, FetchConfiguration fetch) {
        ClassMapping mapping = (ClassMapping)meta;
        final ClassMapping[] mappings = subclasses ? mapping.getIndependentAssignableMappings() : new ClassMapping[]{mapping};
        ResultObjectProvider[] rops = null;
        final JDBCFetchConfiguration jfetch = (JDBCFetchConfiguration)fetch;
        if (jfetch.getSubclassFetchMode(mapping) != 1) {
            rops = new ResultObjectProvider[mappings.length];
        }
        try {
            ResultObjectProvider rop;
            int i;
            for (i = 0; i < mappings.length; ++i) {
                rop = mappings[i].customLoad(this, subclasses, jfetch, 0L, Long.MAX_VALUE);
                if (rop == null) continue;
                if (rops == null) {
                    rops = new ResultObjectProvider[mappings.length];
                }
                rops[i] = rop;
            }
            rop = null;
            if (rops != null) {
                for (i = 0; i < mappings.length; ++i) {
                    BitSet paged;
                    if (rops[i] != null) continue;
                    Select sel = this._sql.newSelect();
                    sel.setLRS(true);
                    if (this._log.isTraceEnabled()) {
                        this._log.trace("executeExtent: " + mappings[i].getDescribedType());
                        sel.logEagerRelations();
                    }
                    rops[i] = (paged = this.selectExtent(sel, mappings[i], jfetch, subclasses)) == null ? new InstanceResultObjectProvider(sel, mappings[i], this, jfetch) : new PagingResultObjectProvider((SelectExecutor)sel, mappings[i], (JDBCStore)this, jfetch, paged, Long.MAX_VALUE);
                }
                if (rops.length == 1) {
                    return rops[0];
                }
                return new MergedResultObjectProvider(rops);
            }
            Union union = this._sql.newUnion(mappings.length);
            union.setLRS(true);
            final BitSet[] paged = new BitSet[mappings.length];
            union.select(new Union.Selector(){

                @Override
                public void select(Select sel, int idx) {
                    paged[idx] = JDBCStoreManager.this.selectExtent(sel, mappings[idx], jfetch, subclasses);
                }
            });
            for (int i2 = 0; i2 < paged.length; ++i2) {
                if (paged[i2] == null) continue;
                return new PagingResultObjectProvider((SelectExecutor)union, mappings, (JDBCStore)this, jfetch, paged, Long.MAX_VALUE);
            }
            return new InstanceResultObjectProvider(union, mappings[0], this, jfetch);
        }
        catch (SQLException se) {
            throw SQLExceptions.getStore(se, this._dict);
        }
    }

    private BitSet selectExtent(Select sel, ClassMapping mapping, JDBCFetchConfiguration fetch, boolean subclasses) {
        int subs = subclasses ? 1 : 2;
        BitSet paged = PagingResultObjectProvider.getPagedFields(sel, mapping, this, fetch, 2, Long.MAX_VALUE);
        if (paged == null) {
            sel.selectIdentifier(mapping, subs, this, fetch, 2);
        } else {
            sel.selectIdentifier(mapping, subs, this, fetch, 1);
        }
        return paged;
    }

    private StoreQuery newStoreQuery(String language) {
        ExpressionParser ep = QueryLanguages.parserForLanguage(language);
        if (ep != null) {
            return new JDBCStoreQuery(this, ep);
        }
        if ("openjpa.SQL".equals(language)) {
            return new SQLStoreQuery(this);
        }
        if ("openjpa.prepared.SQL".equals(language)) {
            return new PreparedSQLStoreQuery(this);
        }
        return null;
    }

    @Override
    public StoreQuery newQuery(String language) {
        StoreQuery sq = this.newStoreQuery(language);
        if (sq == null || QueryLanguages.parserForLanguage(language) == null) {
            return sq;
        }
        QueryCache queryCache = this._ctx.getConfiguration().getDataCacheManagerInstance().getSystemQueryCache();
        if (queryCache == null) {
            return sq;
        }
        return new QueryCacheStoreQuery(sq, queryCache);
    }

    @Override
    public FetchConfiguration newFetchConfiguration() {
        return new JDBCFetchConfigurationImpl();
    }

    @Override
    public Seq getDataStoreIdSequence(ClassMetaData meta) {
        if (meta.getIdentityStrategy() == 1 || meta.getIdentityStrategy() == 0) {
            return this._conf.getSequenceInstance();
        }
        return null;
    }

    @Override
    public Seq getValueSequence(FieldMetaData fmd) {
        return null;
    }

    @Override
    public void close() {
        if (this._conn != null) {
            this._conn.free();
        }
    }

    private void connect(boolean ref) {
        this._ctx.lock();
        try {
            if (this._conn == null) {
                this._conn = this.connectInternal();
            }
            if (ref) {
                this._conn.ref();
            }
        }
        catch (SQLException se) {
            throw SQLExceptions.getStore(se, this._dict);
        }
        finally {
            this._ctx.unlock();
        }
    }

    protected RefCountConnection connectInternal() throws SQLException {
        return ConcreteClassGenerator.newInstance(refCountConnectionImpl, this, this._ds.getConnection());
    }

    @Override
    public Connection getNewConnection() {
        try {
            return this._ds.getConnection();
        }
        catch (SQLException e) {
            throw SQLExceptions.getStore(e, this._dict);
        }
    }

    @Override
    public Object find(Object oid, ValueMapping vm, JDBCFetchConfiguration fetch) {
        Object pc;
        if (oid == null) {
            return null;
        }
        if (this._log.isTraceEnabled()) {
            this._log.trace("find: oid=" + oid + " " + vm.getDeclaredTypeMapping().getDescribedType());
        }
        if ((pc = this._ctx.find(oid, fetch, null, null, 0)) == null && vm != null) {
            OrphanedKeyAction action = this._conf.getOrphanedKeyActionInstance();
            pc = action.orphan(oid, null, vm);
        }
        return pc;
    }

    public Object load(ClassMapping mapping, JDBCFetchConfiguration fetch, BitSet exclude, Result result) throws SQLException {
        if (!mapping.isMapped()) {
            throw new InvalidStateException(_loc.get("virtual-mapping", mapping));
        }
        ClassMapping base = mapping;
        while (base.getJoinablePCSuperclassMapping() != null) {
            base = base.getJoinablePCSuperclassMapping();
        }
        Object oid = base.getObjectId(this, result, null, true, null);
        if (oid == null) {
            return null;
        }
        ConnectionInfo info = new ConnectionInfo();
        info.result = result;
        info.mapping = mapping;
        exclude = this.excludeInverseRelation(mapping, info, exclude);
        return this._ctx.find(oid, fetch, exclude, info, 0);
    }

    private BitSet excludeInverseRelation(ClassMapping mapping, ConnectionInfo info, BitSet exclude) {
        FieldMapping inverse = info.result.getMappedByFieldMapping();
        if (inverse != null) {
            FieldMapping[] fms = mapping.getDefinedFieldMappings();
            if (exclude == null) {
                exclude = new BitSet(fms.length);
            }
            for (int i = 0; i < fms.length; ++i) {
                if (fms[i] != inverse) continue;
                exclude.set(fms[i].getIndex());
                break;
            }
        }
        return exclude;
    }

    private void load(ClassMapping mapping, OpenJPAStateManager sm, JDBCFetchConfiguration fetch, Result res) throws SQLException {
        FieldMapping eagerToMany = this.load(mapping, sm, fetch, res, null);
        if (eagerToMany != null) {
            if (this._log.isTraceEnabled()) {
                this._log.trace("Loading eager toMany: " + eagerToMany.getName() + " for " + mapping);
            }
            eagerToMany.loadEagerJoin(sm, this, fetch.traverseJDBC(eagerToMany), res);
        }
        if (this._active && this._lm != null && res.isLocking()) {
            this._lm.loadedForUpdate(sm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FieldMapping load(ClassMapping mapping, OpenJPAStateManager sm, JDBCFetchConfiguration fetch, Result res, FieldMapping eagerToMany) throws SQLException {
        if (mapping.customLoad(sm, (JDBCStore)this, fetch, res)) {
            return eagerToMany;
        }
        ClassMapping parent = mapping.getJoinablePCSuperclassMapping();
        if (parent != null) {
            eagerToMany = this.load(parent, sm, fetch, res, eagerToMany);
        } else if (sm.getVersion() == null) {
            mapping.getVersion().load(sm, this, res);
        }
        FieldMapping[] fms = mapping.getDefinedFieldMappings();
        for (int i = 0; i < fms.length; ++i) {
            if (fms[i].isPrimaryKey() || sm.getLoaded().get(fms[i].getIndex())) continue;
            Object eres = res.getEager(fms[i]);
            res.startDataRequest(fms[i]);
            try {
                boolean lazyEmbeddable;
                if (eres == res) {
                    if (eagerToMany == null && fms[i].isEagerSelectToMany()) {
                        eagerToMany = fms[i];
                        continue;
                    }
                    fms[i].loadEagerJoin(sm, this, fetch.traverseJDBC(fms[i]), res);
                    continue;
                }
                if (eres != null) {
                    Object processed = fms[i].loadEagerParallel(sm, this, fetch.traverseJDBC(fms[i]), eres);
                    if (processed == eres) continue;
                    res.putEager(fms[i], processed);
                    continue;
                }
                boolean bl = lazyEmbeddable = fms[i].getValueMapping().isEmbedded() && fms[i].getEmbeddedMetaData() != null && fetch.requiresFetch(fms[i]) == 0;
                if (lazyEmbeddable) continue;
                fms[i].load(sm, this, fetch.traverseJDBC(fms[i]), res);
                continue;
            }
            finally {
                res.endDataRequest();
            }
        }
        return eagerToMany;
    }

    public boolean select(Select sel, ClassMapping mapping, int subs, OpenJPAStateManager sm, BitSet fields, JDBCFetchConfiguration fetch, int eager, boolean ident, boolean outer) {
        boolean joinedSupers = false;
        if (this.needClassCondition(mapping, subs, sm)) {
            joinedSupers = this.getJoinedSupers(sel, mapping, subs, outer);
        }
        eager = Math.min(eager, fetch.getEagerFetchMode());
        FieldMapping eagerToMany = this.createEagerSelects(sel, mapping, sm, fields, fetch, eager);
        int seld = this.selectBaseMappings(sel, mapping, mapping, sm, fields, fetch, eager, eagerToMany, ident, joinedSupers);
        if (eagerToMany != null) {
            eagerToMany.selectEagerJoin(sel, sm, this, fetch.traverseJDBC(eagerToMany), eager);
        }
        if (subs == 1 || subs == 3) {
            this.selectSubclassMappings(sel, mapping, sm, fetch);
        }
        if (sm != null) {
            sel.setDistinct(false);
        }
        return seld > 0;
    }

    private boolean getJoinedSupers(Select sel, ClassMapping mapping, int subs, boolean outer) {
        this.loadSubclasses(mapping);
        Joins joins = outer ? sel.newOuterJoins() : null;
        return mapping.getDiscriminator().addClassConditions(sel, subs == 1, joins);
    }

    private boolean needClassCondition(ClassMapping mapping, int subs, OpenJPAStateManager sm) {
        boolean retVal = false;
        if (sm == null || sm.getPCState() == PCState.TRANSIENT) {
            if (subs == 1 || subs == 2) {
                retVal = true;
            } else if (mapping.getDiscriminator() != null && SuperclassDiscriminatorStrategy.class.isInstance(mapping.getDiscriminator().getStrategy()) && mapping.getMappingRepository().getConfiguration().getCompatibilityInstance().getSuperclassDiscriminatorStrategyByDefault()) {
                retVal = true;
            }
        }
        return retVal;
    }

    private FieldMapping createEagerSelects(Select sel, ClassMapping mapping, OpenJPAStateManager sm, BitSet fields, JDBCFetchConfiguration fetch, int eager) {
        if (mapping == null || eager == 0) {
            return null;
        }
        FieldMapping eagerToMany = this.createEagerSelects(sel, mapping.getJoinablePCSuperclassMapping(), sm, fields, fetch, eager);
        FieldMapping[] fms = mapping.getDefinedFieldMappings();
        boolean inEagerJoin = sel.hasEagerJoin(false);
        for (int i = 0; i < fms.length; ++i) {
            int sels;
            int jtype;
            int mode = fms[i].getEagerFetchMode();
            if (mode == 0 || !JDBCStoreManager.requiresSelect(fms[i], sm, fields, fetch)) continue;
            int n = jtype = fms[i].getNullValue() == 2 ? 0 : 1;
            if (mode != 2 && !fms[i].isEagerSelectToMany() && fms[i].supportsSelect(sel, jtype, sm, this, fetch) > 0 && sel.eagerClone(fms[i], jtype, false, 1) != null) continue;
            boolean hasJoin = fetch.hasJoin(fms[i].getFullName(false));
            if ((hasJoin || mode == 1 || mode == -99 && sm != null) && fms[i].isEagerSelectToMany() && !inEagerJoin && !sel.hasEagerJoin(true) && (!sel.getAutoDistinct() || !sel.isLRS() && sel.getStartIndex() == 0L && sel.getEndIndex() == Long.MAX_VALUE) && fms[i].supportsSelect(sel, jtype, sm, this, fetch) > 0) {
                if (sel.eagerClone(fms[i], jtype, true, 1) == null) continue;
                eagerToMany = fms[i];
            }
            if (eager != 2 || (sels = fms[i].supportsSelect(sel, 2, sm, this, fetch)) == 0) continue;
            sel.eagerClone(fms[i], 2, fms[i].isEagerSelectToMany(), sels);
        }
        return eagerToMany;
    }

    private static boolean requiresSelect(FieldMapping fm, OpenJPAStateManager sm, BitSet fields, JDBCFetchConfiguration fetch) {
        if (fields != null) {
            return fields.get(fm.getIndex());
        }
        if (sm != null && sm.getPCState() != PCState.TRANSIENT && sm.getLoaded().get(fm.getIndex())) {
            return false;
        }
        return fetch.requiresFetch(fm) == 1;
    }

    private int selectBaseMappings(Select sel, ClassMapping mapping, ClassMapping orig, OpenJPAStateManager sm, BitSet fields, JDBCFetchConfiguration fetch, int eager, FieldMapping eagerToMany, boolean ident, boolean joined) {
        ClassMapping parent = mapping.getJoinablePCSuperclassMapping();
        if (parent == null && !mapping.isMapped()) {
            throw new InvalidStateException(_loc.get("virtual-mapping", mapping.getDescribedType()));
        }
        int seld = -1;
        int pseld = -1;
        if (parent == null) {
            if (sm == null) {
                if (ident) {
                    sel.selectIdentifier(mapping.getPrimaryKeyColumns());
                } else {
                    sel.select(mapping.getPrimaryKeyColumns());
                }
                seld = 1;
            }
            if ((sm == null || sm.getPCState() == PCState.TRANSIENT && (!(sm.getObjectId() instanceof OpenJPAId) || ((OpenJPAId)sm.getObjectId()).hasSubclasses())) && mapping.getDiscriminator().select(sel, orig)) {
                seld = 1;
            }
            if ((sm == null || sm.getVersion() == null) && mapping.getVersion().select(sel, orig)) {
                seld = 1;
            }
        } else {
            pseld = this.selectBaseMappings(sel, parent, orig, sm, fields, fetch, eager, eagerToMany, ident, joined);
        }
        FieldMapping[] fms = mapping.getDefinedFieldMappings();
        for (int i = 0; i < fms.length; ++i) {
            int fseld;
            if (fms[i] == eagerToMany) continue;
            SelectExecutor esel = sel.getEager(fms[i]);
            if (esel != null) {
                if (esel == sel) {
                    fms[i].selectEagerJoin(sel, sm, this, fetch.traverseJDBC(fms[i]), eager);
                } else {
                    fms[i].selectEagerParallel(esel, sm, this, fetch.traverseJDBC(fms[i]), eager);
                }
                seld = Math.max(0, seld);
                continue;
            }
            if (JDBCStoreManager.requiresSelect(fms[i], sm, fields, fetch)) {
                fseld = fms[i].select(sel, sm, this, fetch.traverseJDBC(fms[i]), eager);
                seld = Math.max(fseld, seld);
                continue;
            }
            if (!this.optSelect(fms[i], sel, sm, fetch) || (fseld = fms[i].select(sel, sm, this, fetch.traverseJDBC(fms[i]), 0)) < 0 || seld >= 0) continue;
            seld = 0;
        }
        if (eagerToMany != null && pseld < 0 && seld > 0 && !joined && parent != null) {
            FieldMapping[] pfms = parent.getDefinedFieldMappings();
            for (int i = 0; i < pfms.length; ++i) {
                if (pfms[i] != eagerToMany) continue;
                pseld = 0;
                break;
            }
        }
        if (!joined && pseld >= 0 && parent.getTable() != mapping.getTable()) {
            sel.where(mapping.joinSuperclass(sel.newJoins(), false));
        }
        return Math.max(pseld, seld);
    }

    private boolean optSelect(FieldMapping fm, Select sel, OpenJPAStateManager sm, JDBCFetchConfiguration fetch) {
        return !fm.isInDefaultFetchGroup() && !fm.isDefaultFetchGroupExplicit() && (sm == null || sm.getPCState() == PCState.TRANSIENT || !sm.getLoaded().get(fm.getIndex())) && fm.supportsSelect(sel, 4, sm, this, fetch) > 0;
    }

    /*
     * Unable to fully structure code
     */
    private void selectSubclassMappings(Select sel, ClassMapping mapping, OpenJPAStateManager sm, JDBCFetchConfiguration fetch) {
        this.loadSubclasses(mapping);
        subMappings = mapping.getJoinablePCSubclassMappings();
        if (subMappings.length == 0) {
            return;
        }
        if (this._dict.joinSyntax == 1) ** GOTO lbl-1000
        if (fetch.getSubclassFetchMode(mapping) != 0) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        canJoin = v0;
        for (i = 0; i < subMappings.length; ++i) {
            if (!subMappings[i].supportsEagerSelect(sel, sm, this, mapping, fetch)) continue;
            joined = canJoin == false;
            fms = subMappings[i].getDefinedFieldMappings();
            for (j = 0; j < fms.length; ++j) {
                if (fetch.requiresFetch(fms[j]) != 1 && (!fms[j].isInDefaultFetchGroup() && fms[j].isDefaultFetchGroupExplicit() || fms[j].supportsSelect(sel, 4, sm, this, fetch) <= 0)) continue;
                if (!joined) {
                    joined = true;
                    sel.where(JDBCStoreManager.joinSubclass(sel, mapping, subMappings[i], null));
                }
                if (fms[j].supportsSelect(sel, 3, sm, this, fetch) <= 0) continue;
                fms[j].select(sel, null, this, fetch.traverseJDBC(fms[j]), 0);
            }
        }
    }

    private static Joins joinSubclass(Select sel, ClassMapping base, ClassMapping sub, Joins joins) {
        if (sub == base || sub.getTable() == base.getTable() || sel.isSelected(sub.getTable())) {
            return null;
        }
        ClassMapping sup = sub.getJoinablePCSuperclassMapping();
        joins = JDBCStoreManager.joinSubclass(sel, base, sup, joins);
        if (joins == null) {
            joins = sel.newJoins();
        }
        return sub.joinSuperclass(joins, true);
    }

    @Override
    public void loadSubclasses(ClassMapping mapping) {
        Discriminator dsc = mapping.getDiscriminator();
        if (dsc.getSubclassesLoaded()) {
            return;
        }
        if (mapping.getRepository().getPersistentTypeNames(false, this._ctx.getClassLoader()) != null) {
            dsc.setSubclassesLoaded(true);
            return;
        }
        try {
            dsc.loadSubclasses(this);
        }
        catch (ClassNotFoundException cnfe) {
            throw new StoreException(cnfe);
        }
        catch (SQLException se) {
            throw SQLExceptions.getStore(se, this._dict);
        }
    }

    private void beforeExecuteStatement(Statement stmnt) {
        this._stmnts.add(stmnt);
    }

    private void afterExecuteStatement(Statement stmnt) {
        this._stmnts.remove(stmnt);
    }

    FinderQueryImpl getFinder(ClassMapping mapping, FetchConfiguration fetch) {
        FinderCache cache = this.getFinderCache();
        return cache == null ? null : (FinderQueryImpl)cache.get(mapping, fetch);
    }

    boolean cacheFinder(ClassMapping mapping, SelectExecutor select, FetchConfiguration fetch) {
        FinderCache cache = this.getFinderCache();
        return cache != null && cache.cache(mapping, select, fetch) != null;
    }

    FinderCache getFinderCache() {
        return ((BrokerImpl)this.getContext()).getCacheFinderQuery() ? this.getConfiguration().getFinderCacheInstance() : null;
    }

    static {
        try {
            clientConnectionImpl = ConcreteClassGenerator.getConcreteConstructor(ClientConnection.class, Connection.class);
            AccessController.doPrivileged(J2DoPrivHelper.setAccessibleAction(clientConnectionImpl, true));
            refCountConnectionImpl = ConcreteClassGenerator.getConcreteConstructor(RefCountConnection.class, JDBCStoreManager.class, Connection.class);
            AccessController.doPrivileged(J2DoPrivHelper.setAccessibleAction(refCountConnectionImpl, true));
            cancelStatementImpl = ConcreteClassGenerator.getConcreteConstructor(CancelStatement.class, JDBCStoreManager.class, Statement.class, Connection.class);
            AccessController.doPrivileged(J2DoPrivHelper.setAccessibleAction(cancelStatementImpl, true));
            cancelPreparedStatementImpl = ConcreteClassGenerator.getConcreteConstructor(CancelPreparedStatement.class, JDBCStoreManager.class, PreparedStatement.class, Connection.class);
            AccessController.doPrivileged(J2DoPrivHelper.setAccessibleAction(cancelPreparedStatementImpl, true));
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    protected abstract class CancelPreparedStatement
    extends DelegatingPreparedStatement {
        public CancelPreparedStatement(PreparedStatement stmnt, Connection conn) {
            super(stmnt, conn);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int executeUpdate() throws SQLException {
            JDBCStoreManager.this.beforeExecuteStatement(this);
            try {
                int n = super.executeUpdate();
                return n;
            }
            finally {
                JDBCStoreManager.this.afterExecuteStatement(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected ResultSet executeQuery(boolean wrap) throws SQLException {
            JDBCStoreManager.this.beforeExecuteStatement(this);
            try {
                ResultSet resultSet = super.executeQuery(wrap);
                return resultSet;
            }
            finally {
                JDBCStoreManager.this.afterExecuteStatement(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int[] executeBatch() throws SQLException {
            JDBCStoreManager.this.beforeExecuteStatement(this);
            try {
                int[] nArray = super.executeBatch();
                return nArray;
            }
            finally {
                JDBCStoreManager.this.afterExecuteStatement(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean execute() throws SQLException {
            JDBCStoreManager.this.beforeExecuteStatement(this);
            try {
                boolean bl = super.execute();
                return bl;
            }
            finally {
                JDBCStoreManager.this.afterExecuteStatement(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean execute(String s) throws SQLException {
            JDBCStoreManager.this.beforeExecuteStatement(this);
            try {
                boolean bl = super.execute(s);
                return bl;
            }
            finally {
                JDBCStoreManager.this.afterExecuteStatement(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int executeUpdate(String s) throws SQLException {
            JDBCStoreManager.this.beforeExecuteStatement(this);
            try {
                int n = super.executeUpdate(s);
                return n;
            }
            finally {
                JDBCStoreManager.this.afterExecuteStatement(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int executeUpdate(String s, int i) throws SQLException {
            JDBCStoreManager.this.beforeExecuteStatement(this);
            try {
                int n = super.executeUpdate(s, i);
                return n;
            }
            finally {
                JDBCStoreManager.this.afterExecuteStatement(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int executeUpdate(String s, int[] ia) throws SQLException {
            JDBCStoreManager.this.beforeExecuteStatement(this);
            try {
                int n = super.executeUpdate(s, ia);
                return n;
            }
            finally {
                JDBCStoreManager.this.afterExecuteStatement(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int executeUpdate(String s, String[] sa) throws SQLException {
            JDBCStoreManager.this.beforeExecuteStatement(this);
            try {
                int n = super.executeUpdate(s, sa);
                return n;
            }
            finally {
                JDBCStoreManager.this.afterExecuteStatement(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean execute(String s, int i) throws SQLException {
            JDBCStoreManager.this.beforeExecuteStatement(this);
            try {
                boolean bl = super.execute(s, i);
                return bl;
            }
            finally {
                JDBCStoreManager.this.afterExecuteStatement(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean execute(String s, int[] ia) throws SQLException {
            JDBCStoreManager.this.beforeExecuteStatement(this);
            try {
                boolean bl = super.execute(s, ia);
                return bl;
            }
            finally {
                JDBCStoreManager.this.afterExecuteStatement(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean execute(String s, String[] sa) throws SQLException {
            JDBCStoreManager.this.beforeExecuteStatement(this);
            try {
                boolean bl = super.execute(s, sa);
                return bl;
            }
            finally {
                JDBCStoreManager.this.afterExecuteStatement(this);
            }
        }
    }

    protected abstract class CancelStatement
    extends DelegatingStatement {
        public CancelStatement(Statement stmnt, Connection conn) {
            super(stmnt, conn);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int executeUpdate(String sql2) throws SQLException {
            JDBCStoreManager.this.beforeExecuteStatement(this);
            try {
                int n = super.executeUpdate(sql2);
                return n;
            }
            finally {
                JDBCStoreManager.this.afterExecuteStatement(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected ResultSet executeQuery(String sql2, boolean wrap) throws SQLException {
            JDBCStoreManager.this.beforeExecuteStatement(this);
            try {
                ResultSet resultSet = super.executeQuery(sql2, wrap);
                return resultSet;
            }
            finally {
                JDBCStoreManager.this.afterExecuteStatement(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean execute(String sql2) throws SQLException {
            JDBCStoreManager.this.beforeExecuteStatement(this);
            try {
                boolean bl = super.execute(sql2);
                return bl;
            }
            finally {
                JDBCStoreManager.this.afterExecuteStatement(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int executeUpdate(String sql2, int i) throws SQLException {
            JDBCStoreManager.this.beforeExecuteStatement(this);
            try {
                int n = super.executeUpdate(sql2, i);
                return n;
            }
            finally {
                JDBCStoreManager.this.afterExecuteStatement(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int executeUpdate(String sql2, int[] ia) throws SQLException {
            JDBCStoreManager.this.beforeExecuteStatement(this);
            try {
                int n = super.executeUpdate(sql2, ia);
                return n;
            }
            finally {
                JDBCStoreManager.this.afterExecuteStatement(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int executeUpdate(String sql2, String[] sa) throws SQLException {
            JDBCStoreManager.this.beforeExecuteStatement(this);
            try {
                int n = super.executeUpdate(sql2, sa);
                return n;
            }
            finally {
                JDBCStoreManager.this.afterExecuteStatement(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean execute(String sql2, int i) throws SQLException {
            JDBCStoreManager.this.beforeExecuteStatement(this);
            try {
                boolean bl = super.execute(sql2, i);
                return bl;
            }
            finally {
                JDBCStoreManager.this.afterExecuteStatement(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean execute(String sql2, int[] ia) throws SQLException {
            JDBCStoreManager.this.beforeExecuteStatement(this);
            try {
                boolean bl = super.execute(sql2, ia);
                return bl;
            }
            finally {
                JDBCStoreManager.this.afterExecuteStatement(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean execute(String sql2, String[] sa) throws SQLException {
            JDBCStoreManager.this.beforeExecuteStatement(this);
            try {
                boolean bl = super.execute(sql2, sa);
                return bl;
            }
            finally {
                JDBCStoreManager.this.afterExecuteStatement(this);
            }
        }
    }

    protected abstract class RefCountConnection
    extends DelegatingConnection {
        private boolean _retain;
        private int _refs;
        private boolean _freed;

        public RefCountConnection(Connection conn) {
            super(conn);
            this._retain = false;
            this._refs = 0;
            this._freed = false;
        }

        public boolean getRetain() {
            return this._retain;
        }

        public void setRetain(boolean retain) {
            if (this._retain && !retain && this._refs <= 0) {
                this.free();
            }
            this._retain = retain;
        }

        public void ref() {
            ++this._refs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws SQLException {
            JDBCStoreManager.this._ctx.lock();
            try {
                --this._refs;
                if (this._refs <= 0 && !this._retain) {
                    this.free();
                }
            }
            finally {
                JDBCStoreManager.this._ctx.unlock();
            }
        }

        public void free() {
            if (this._freed) {
                return;
            }
            try {
                this.getDelegate().close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this._freed = true;
            JDBCStoreManager.this._conn = null;
        }

        @Override
        protected Statement createStatement(boolean wrap) throws SQLException {
            return (Statement)ConcreteClassGenerator.newInstance(cancelStatementImpl, JDBCStoreManager.this, super.createStatement(false), this);
        }

        @Override
        protected Statement createStatement(int rsType, int rsConcur, boolean wrap) throws SQLException {
            return (Statement)ConcreteClassGenerator.newInstance(cancelStatementImpl, JDBCStoreManager.this, super.createStatement(rsType, rsConcur, false), this);
        }

        @Override
        protected PreparedStatement prepareStatement(String sql2, boolean wrap) throws SQLException {
            return (PreparedStatement)ConcreteClassGenerator.newInstance(cancelPreparedStatementImpl, JDBCStoreManager.this, super.prepareStatement(sql2, false), this);
        }

        @Override
        protected PreparedStatement prepareStatement(String sql2, int rsType, int rsConcur, boolean wrap) throws SQLException {
            return (PreparedStatement)ConcreteClassGenerator.newInstance(cancelPreparedStatementImpl, JDBCStoreManager.this, super.prepareStatement(sql2, rsType, rsConcur, false), this);
        }
    }

    public static abstract class ClientConnection
    extends DelegatingConnection {
        private boolean _closed = false;

        public ClientConnection(Connection conn) {
            super(conn);
        }

        @Override
        public void close() throws SQLException {
            this._closed = true;
            super.close();
        }

        protected void finalize() throws SQLException {
            if (!this._closed) {
                this.close();
            }
        }
    }
}

