/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.sql.SQLException;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.openejb.cli.SystemExitException;
import org.apache.openejb.resource.jdbc.BasicDataSourceUtil;
import org.apache.openejb.resource.jdbc.PasswordCipher;
import org.apache.openejb.util.Join;
import org.apache.openejb.util.Messages;
import org.apache.xbean.finder.ResourceFinder;

public class Cipher {
    private static Messages messages = new Messages(Cipher.class);

    public static void main(String[] args) throws SystemExitException {
        CommandLine line;
        PosixParser parser = new PosixParser();
        Options options = new Options();
        options.addOption(Cipher.option("h", "help", "cmd.cipher.opt.help"));
        options.addOption(Cipher.option("c", "cipher", "c", "cmd.cipher.opt.impl"));
        options.addOption(Cipher.option("d", "decrypt", "cmd.cipher.opt.decrypt"));
        options.addOption(Cipher.option("e", "encrypt", "cmd.cipher.opt.encrypt"));
        try {
            line = parser.parse(options, args);
        }
        catch (ParseException exp) {
            Cipher.help(options);
            throw new SystemExitException(-1);
        }
        if (line.hasOption("help")) {
            Cipher.help(options);
            return;
        }
        String cipherName = "Static3DES";
        if (line.hasOption("cipher")) {
            cipherName = line.getOptionValue("cipher");
        }
        if (line.getArgList().size() != 1) {
            System.out.println("Must specify either a plain text to encrypt or a ciphered value to decrypt.");
            Cipher.help(options);
            return;
        }
        try {
            PasswordCipher cipher = BasicDataSourceUtil.getPasswordCipher(cipherName);
            if (line.hasOption("decrypt")) {
                String pwdArg = (String)line.getArgList().get(0);
                char[] encryptdPassword = pwdArg.toCharArray();
                System.out.println(cipher.decrypt(encryptdPassword));
            } else {
                String plainPassword = (String)line.getArgList().get(0);
                System.out.println(new String(cipher.encrypt(plainPassword)));
            }
        }
        catch (SQLException e) {
            System.out.println("Could not load password cipher implementation class. Check your classpath.");
            Cipher.availableCiphers();
            throw new SystemExitException(-1);
        }
    }

    private static void availableCiphers() {
        try {
            ResourceFinder finder = new ResourceFinder("META-INF/");
            Map<String, Class<PasswordCipher>> impls = finder.mapAllImplementations(PasswordCipher.class);
            System.out.println("Available ciphers are: " + Join.join(", ", impls.keySet()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void help(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("cipher [options] <value>", "\n" + Cipher.i18n("cmd.cipher.description"), options, "\n");
        System.out.println("");
        Cipher.availableCiphers();
    }

    private static Option option(String shortOpt, String longOpt, String description) {
        OptionBuilder.withLongOpt(longOpt);
        OptionBuilder.withDescription(Cipher.i18n(description));
        return OptionBuilder.create(shortOpt);
    }

    private static Option option(String shortOpt, String longOpt, String argName, String description) {
        OptionBuilder.withLongOpt(longOpt);
        OptionBuilder.withArgName(argName);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription(Cipher.i18n(description));
        return OptionBuilder.create(shortOpt);
    }

    private static String i18n(String key) {
        return messages.format(key);
    }
}

