/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector.outbound;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TimerTask;
import javax.resource.ResourceException;
import javax.resource.spi.ManagedConnection;
import org.apache.geronimo.connector.outbound.AbstractSinglePoolConnectionInterceptor;
import org.apache.geronimo.connector.outbound.ConnectionInfo;
import org.apache.geronimo.connector.outbound.ConnectionInterceptor;
import org.apache.geronimo.connector.outbound.ConnectionReturnAction;
import org.apache.geronimo.connector.outbound.ManagedConnectionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SinglePoolConnectionInterceptor
extends AbstractSinglePoolConnectionInterceptor {
    private static final Logger log = LoggerFactory.getLogger(SinglePoolConnectionInterceptor.class.getName());
    private boolean selectOneAssumeMatch;
    private final List<ManagedConnectionInfo> pool;

    public SinglePoolConnectionInterceptor(ConnectionInterceptor next, int maxSize, int minSize, int blockingTimeoutMilliseconds, int idleTimeoutMinutes, boolean selectOneAssumeMatch) {
        super(next, maxSize, minSize, blockingTimeoutMilliseconds, idleTimeoutMinutes);
        this.pool = new ArrayList<ManagedConnectionInfo>(maxSize);
        this.selectOneAssumeMatch = selectOneAssumeMatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void internalGetConnection(ConnectionInfo connectionInfo) throws ResourceException {
        List<ManagedConnectionInfo> list = this.pool;
        synchronized (list) {
            ManagedConnection matchedMC;
            if (this.destroyed) {
                throw new ResourceException("ManagedConnection pool has been destroyed");
            }
            if (this.pool.isEmpty()) {
                this.next.getConnection(connectionInfo);
                ++this.connectionCount;
                if (log.isTraceEnabled()) {
                    log.trace("Supplying new connection MCI: " + connectionInfo.getManagedConnectionInfo() + " MC: " + connectionInfo.getManagedConnectionInfo().getManagedConnection() + " from pool: " + this);
                }
                return;
            }
            ManagedConnectionInfo newMCI = this.pool.remove(this.pool.size() - 1);
            if (this.connectionCount < this.minSize) {
                this.timer.schedule((TimerTask)new AbstractSinglePoolConnectionInterceptor.FillTask(connectionInfo), 10L);
            }
            if (this.selectOneAssumeMatch) {
                connectionInfo.setManagedConnectionInfo(newMCI);
                if (log.isTraceEnabled()) {
                    log.trace("Supplying pooled connection without checking matching MCI: " + connectionInfo.getManagedConnectionInfo() + " MC: " + connectionInfo.getManagedConnectionInfo().getManagedConnection() + " from pool: " + this);
                }
                return;
            }
            try {
                ManagedConnectionInfo mci = connectionInfo.getManagedConnectionInfo();
                matchedMC = newMCI.getManagedConnectionFactory().matchManagedConnections(Collections.singleton(newMCI.getManagedConnection()), mci.getSubject(), mci.getConnectionRequestInfo());
            }
            catch (ResourceException e) {
                ConnectionInfo returnCI = new ConnectionInfo();
                returnCI.setManagedConnectionInfo(newMCI);
                this.returnConnection(returnCI, ConnectionReturnAction.DESTROY);
                throw e;
            }
            if (matchedMC != null) {
                connectionInfo.setManagedConnectionInfo(newMCI);
                if (log.isTraceEnabled()) {
                    log.trace("Supplying pooled connection  MCI: " + connectionInfo.getManagedConnectionInfo() + " from pool: " + this);
                }
            } else {
                ConnectionInfo returnCI = new ConnectionInfo();
                returnCI.setManagedConnectionInfo(newMCI);
                this.returnConnection(returnCI, ConnectionReturnAction.RETURN_HANDLE);
                throw new ResourceException("The pooling strategy does not match the MatchManagedConnections implementation.  Please investigate and reconfigure this pool");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void internalDestroy() {
        List<ManagedConnectionInfo> list = this.pool;
        synchronized (list) {
            while (!this.pool.isEmpty()) {
                ManagedConnection mc = this.pool.remove(this.pool.size() - 1).getManagedConnection();
                if (mc == null) continue;
                try {
                    mc.destroy();
                }
                catch (ResourceException resourceException) {}
            }
            return;
        }
    }

    @Override
    protected Object getPool() {
        return this.pool;
    }

    @Override
    protected void doAdd(ManagedConnectionInfo mci) {
        this.pool.add(mci);
    }

    @Override
    protected boolean doRemove(ManagedConnectionInfo mci) {
        log.info("Removing " + mci + " from pool " + this);
        return !this.pool.remove(mci);
    }

    @Override
    protected void transferConnections(int maxSize, int shrinkNow) {
        for (int i = 0; i < shrinkNow; ++i) {
            ConnectionInfo killInfo = new ConnectionInfo(this.pool.get(0));
            this.internalReturn(killInfo, ConnectionReturnAction.DESTROY);
        }
    }

    @Override
    public int getIdleConnectionCount() {
        return this.pool.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void getExpiredManagedConnectionInfos(long threshold, List<ManagedConnectionInfo> killList) {
        List<ManagedConnectionInfo> list = this.pool;
        synchronized (list) {
            Iterator<ManagedConnectionInfo> mcis = this.pool.iterator();
            while (mcis.hasNext()) {
                ManagedConnectionInfo mci = mcis.next();
                if (mci.getLastUsed() >= threshold) continue;
                mcis.remove();
                killList.add(mci);
                --this.connectionCount;
            }
        }
    }

    @Override
    public void info(StringBuilder s) {
        s.append(this.getClass().getName());
        s.append("[minSize=").append(this.minSize);
        s.append(",maxSize=").append(this.maxSize);
        s.append(",idleTimeoutMilliseconds=").append(this.idleTimeoutMilliseconds);
        s.append(",blockingTimeoutMilliseconds=").append(this.blockingTimeoutMilliseconds);
        s.append(".selectOneAssumeMatch=").append(this.selectOneAssumeMatch).append("]\n");
        this.next.info(s);
    }
}

