/**
 *
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package org.apache.openejb.jee;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.HashSet;
import java.util.Set;


/**
 * javaee6.xsd
 *
 * <p>Java class for ejb-refType complex type.
 *
 * <p>The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
 * &lt;complexType name="ejb-refType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="description" type="{http://java.sun.com/xml/ns/javaee}descriptionType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="ejb-ref-name" type="{http://java.sun.com/xml/ns/javaee}ejb-ref-nameType"/>
 *         &lt;element name="ejb-ref-type" type="{http://java.sun.com/xml/ns/javaee}ejb-ref-typeType" minOccurs="0"/>
 *         &lt;element name="home" type="{http://java.sun.com/xml/ns/javaee}homeType" minOccurs="0"/>
 *         &lt;element name="remote" type="{http://java.sun.com/xml/ns/javaee}remoteType" minOccurs="0"/>
 *         &lt;element name="ejb-link" type="{http://java.sun.com/xml/ns/javaee}ejb-linkType" minOccurs="0"/>
 *         &lt;group ref="{http://java.sun.com/xml/ns/javaee}resourceGroup"/>
 *       &lt;/sequence>
 *       &lt;attribute name="id" type="{http://www.w3.org/2001/XMLSchema}ID" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 *
 *
 */

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ejb-refType", propOrder = {
        "descriptions",
        "ejbRefName",
        "ejbRefType",
        "home",
        "remote",
        "ejbLink",
        "mappedName",
        "injectionTarget",
        "lookupName"
        })
public class EjbRef implements EjbReference {

    @XmlTransient
    protected TextMap description = new TextMap();
    @XmlElement(name = "ejb-ref-name", required = true)
    protected String ejbRefName;
    @XmlElement(name = "ejb-ref-type")
    protected EjbRefType ejbRefType;
    protected String home;
    protected String remote;
    @XmlElement(name = "ejb-link")
    protected String ejbLink;
    @XmlElement(name = "mapped-name")
    protected String mappedName;
    @XmlElement(name = "lookup-name")
    protected String lookupName;
    @XmlElement(name = "injection-target", required = true)
    protected Set<InjectionTarget> injectionTarget;
    @XmlAttribute
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    @XmlID
    protected String id;

    @XmlTransient
    protected Type refType = Type.REMOTE;

    
    public EjbRef name(String ejbRefName) {
        this.ejbRefName = ejbRefName;
        return this;
    }

    public EjbRef type(EjbRefType ejbRefType) {
        this.ejbRefType = ejbRefType;
        return this;
    }

    public EjbRef link(String link) {
        this.ejbLink = link;
        return this;
    }

    public EjbRef remote(String remote) {
        this.remote = remote;
        return this;
    }

    public EjbRef remote(Class<?> remote) {
        return remote(remote.getName());
    }

    public EjbRef home(String home) {
        this.home = home;
        return this;
    }

    public EjbRef home(Class<?> home) {
        return home(home.getName());
    }

    public EjbRef mappedName(String mappedName) {
        this.mappedName = mappedName;
        return this;
    }

    public EjbRef lookup(String lookupName) {
        this.lookupName = lookupName;
        return this;
    }

    public EjbRef injectionTarget(String className, String property) {
        getInjectionTarget().add(new InjectionTarget(className, property));

        if (this.ejbRefName == null) {
            this.ejbRefName = "java:comp/env/" + className + "/" + property;
        }

        return this;
    }

    public EjbRef injectionTarget(Class<?> clazz, String property) {
        return injectionTarget(clazz.getName(), property);
    }

    public Type getRefType() {
        return refType;
    }

    public void setRefType(Type refType) {
        this.refType = refType;
    }

    @XmlElement(name = "description", required = true)
    public Text[] getDescriptions() {
        return description.toArray();
    }

    public void setDescriptions(Text[] text) {
        description.set(text);
    }

    public String getDescription() {
        return description.get();
    }

    public String getEjbRefName() {
        return ejbRefName;
    }

    public String getName() {
        return getEjbRefName();
    }

    public String getKey() {
        String name = getName();
        if (name == null || name.startsWith("java:")) return name;
        return "java:comp/env/" + name;
    }

    public String getType() {
        return getEjbRefType().name();
    }

    public void setName(String name) {
        setEjbRefName(name);
    }

    public void setType(String type) {
    }

    public void setEjbRefName(String value) {
        this.ejbRefName = value;
    }

    public EjbRefType getEjbRefType() {
        return ejbRefType;
    }

    public void setEjbRefType(EjbRefType value) {
        this.ejbRefType = value;
    }

    public String getHome() {
        return home;
    }

    public void setHome(String value) {
        this.home = value;
    }

    public String getRemote() {
        return remote;
    }

    public String getInterface() {
        return getRemote();
    }

    public void setRemote(String value) {
        this.remote = value;
    }

    public String getEjbLink() {
        return ejbLink;
    }

    public void setEjbLink(String value) {
        this.ejbLink = value;
    }

    public String getMappedName() {
        return mappedName;
    }

    public void setMappedName(String value) {
        this.mappedName = value;
    }

    public String getLookupName() {
        return lookupName;
    }

    public void setLookupName(String lookupName) {
        this.lookupName = lookupName;
    }

    public Set<InjectionTarget> getInjectionTarget() {
        if (injectionTarget == null) {
            injectionTarget = new HashSet<InjectionTarget>();
        }
        return this.injectionTarget;
    }

    public String getId() {
        return id;
    }

    public void setId(String value) {
        this.id = value;
    }

    @Override
    public String toString() {
        return "EjbRef{" +
                "name='" + ejbRefName + '\'' +
                ", remote='" + remote + '\'' +
                ", link='" + ejbLink + '\'' +
                ", mappedName='" + mappedName + '\'' +
                ", lookupName='" + lookupName + '\'' +
                '}';
    }
}
