/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.openejb.jee.jba;

import javax.xml.bind.annotation.XmlRegistry;


/**
 * This object contains factory methods for each 
 * Java content interface and Java element interface 
 * generated in the org.apache.openejb.jee.jba package. 
 * <p>An ObjectFactory allows you to programatically 
 * construct new instances of the Java representation 
 * for XML content. The Java representation of XML 
 * content can consist of schema derived interfaces 
 * and classes representing the binding of schema 
 * type definitions, element declarations and model 
 * groups.  Factory methods for each of these are 
 * provided in this class.
 * 
 */
@XmlRegistry
public class ObjectFactory {


    /**
     * Create a new ObjectFactory that can be used to create new instances of schema derived classes for package: org.apache.openejb.jee.jba
     * 
     */
    public ObjectFactory() {
    }

    /**
     * Create an instance of {@link ResJndiName }
     * 
     */
    public ResJndiName createResJndiName() {
        return new ResJndiName();
    }

    /**
     * Create an instance of {@link ContainerCacheConf }
     * 
     */
    public ContainerCacheConf createContainerCacheConf() {
        return new ContainerCacheConf();
    }

    /**
     * Create an instance of {@link ResourceManager }
     * 
     */
    public ResourceManager createResourceManager() {
        return new ResourceManager();
    }

    /**
     * Create an instance of {@link Bean }
     * 
     */
    public Bean createBean() {
        return new Bean();
    }

    /**
     * Create an instance of {@link ResourceEnvRef }
     * 
     */
    public ResourceEnvRef createResourceEnvRef() {
        return new ResourceEnvRef();
    }

    /**
     * Create an instance of {@link Depends }
     * 
     */
    public Depends createDepends() {
        return new Depends();
    }

    /**
     * Create an instance of {@link ListEntity }
     * 
     */
    public ListEntity createListEntity() {
        return new ListEntity();
    }

    /**
     * Create an instance of {@link ContainerConfiguration }
     * 
     */
    public ContainerConfiguration createContainerConfiguration() {
        return new ContainerConfiguration();
    }

    /**
     * Create an instance of {@link EndpointInterceptors }
     * 
     */
    public EndpointInterceptors createEndpointInterceptors() {
        return new EndpointInterceptors();
    }

    /**
     * Create an instance of {@link Interceptor }
     * 
     */
    public Interceptor createInterceptor() {
        return new Interceptor();
    }

    /**
     * Create an instance of {@link InvokerProxyBinding }
     * 
     */
    public InvokerProxyBinding createInvokerProxyBinding() {
        return new InvokerProxyBinding();
    }

    /**
     * Create an instance of {@link Jboss }
     * 
     */
    public Jboss createJboss() {
        return new Jboss();
    }

    /**
     * Create an instance of {@link CacheInvalidationConfig }
     * 
     */
    public CacheInvalidationConfig createCacheInvalidationConfig() {
        return new CacheInvalidationConfig();
    }

    /**
     * Create an instance of {@link ActivationConfigProperty }
     * 
     */
    public ActivationConfigProperty createActivationConfigProperty() {
        return new ActivationConfigProperty();
    }

    /**
     * Create an instance of {@link InvokerBindings }
     * 
     */
    public InvokerBindings createInvokerBindings() {
        return new InvokerBindings();
    }

    /**
     * Create an instance of {@link Invoker }
     * 
     */
    public Invoker createInvoker() {
        return new Invoker();
    }

    /**
     * Create an instance of {@link ActivationConfig }
     * 
     */
    public ActivationConfig createActivationConfig() {
        return new ActivationConfig();
    }

    /**
     * Create an instance of {@link ResourceRef }
     * 
     */
    public ResourceRef createResourceRef() {
        return new ResourceRef();
    }

    /**
     * Create an instance of {@link TransportConfig }
     * 
     */
    public TransportConfig createTransportConfig() {
        return new TransportConfig();
    }

    /**
     * Create an instance of {@link SasContext }
     * 
     */
    public SasContext createSasContext() {
        return new SasContext();
    }

    /**
     * Create an instance of {@link LoaderRepositoryConfig }
     * 
     */
    public LoaderRepositoryConfig createLoaderRepositoryConfig() {
        return new LoaderRepositoryConfig();
    }

    /**
     * Create an instance of {@link Partitions }
     * 
     */
    public Partitions createPartitions() {
        return new Partitions();
    }

    /**
     * Create an instance of {@link EjbRef }
     * 
     */
    public EjbRef createEjbRef() {
        return new EjbRef();
    }

    /**
     * Create an instance of {@link InvokerProxyBindings }
     * 
     */
    public InvokerProxyBindings createInvokerProxyBindings() {
        return new InvokerProxyBindings();
    }

    /**
     * Create an instance of {@link RetryHandlers }
     * 
     */
    public RetryHandlers createRetryHandlers() {
        return new RetryHandlers();
    }

    /**
     * Create an instance of {@link EnterpriseBeans }
     * 
     */
    public EnterpriseBeans createEnterpriseBeans() {
        return new EnterpriseBeans();
    }

    /**
     * Create an instance of {@link CachePolicyConfOther }
     * 
     */
    public CachePolicyConfOther createCachePolicyConfOther() {
        return new CachePolicyConfOther();
    }

    /**
     * Create an instance of {@link CachePolicyConf }
     * 
     */
    public CachePolicyConf createCachePolicyConf() {
        return new CachePolicyConf();
    }

    /**
     * Create an instance of {@link Home }
     * 
     */
    public Home createHome() {
        return new Home();
    }

    /**
     * Create an instance of {@link MessageDriven }
     * 
     */
    public MessageDriven createMessageDriven() {
        return new MessageDriven();
    }

    /**
     * Create an instance of {@link EjbLocalRef }
     * 
     */
    public EjbLocalRef createEjbLocalRef() {
        return new EjbLocalRef();
    }

    /**
     * Create an instance of {@link ClientInterceptors }
     * 
     */
    public ClientInterceptors createClientInterceptors() {
        return new ClientInterceptors();
    }

    /**
     * Create an instance of {@link Method }
     * 
     */
    public Method createMethod() {
        return new Method();
    }

    /**
     * Create an instance of {@link ClusterConfig }
     * 
     */
    public ClusterConfig createClusterConfig() {
        return new ClusterConfig();
    }

    /**
     * Create an instance of {@link MDBConfig }
     * 
     */
    public MDBConfig createMDBConfig() {
        return new MDBConfig();
    }

    /**
     * Create an instance of {@link AssemblyDescriptor }
     * 
     */
    public AssemblyDescriptor createAssemblyDescriptor() {
        return new AssemblyDescriptor();
    }

    /**
     * Create an instance of {@link ResUrl }
     * 
     */
    public ResUrl createResUrl() {
        return new ResUrl();
    }

    /**
     * Create an instance of {@link ContainerInterceptors }
     * 
     */
    public ContainerInterceptors createContainerInterceptors() {
        return new ContainerInterceptors();
    }

    /**
     * Create an instance of {@link MessageDestination }
     * 
     */
    public MessageDestination createMessageDestination() {
        return new MessageDestination();
    }

    /**
     * Create an instance of {@link DLQConfig }
     * 
     */
    public DLQConfig createDLQConfig() {
        return new DLQConfig();
    }

    /**
     * Create an instance of {@link LoaderRepository }
     * 
     */
    public LoaderRepository createLoaderRepository() {
        return new LoaderRepository();
    }

    /**
     * Create an instance of {@link Invalidable }
     * 
     */
    public Invalidable createInvalidable() {
        return new Invalidable();
    }

    /**
     * Create an instance of {@link EjbTimeoutIdentity }
     * 
     */
    public EjbTimeoutIdentity createEjbTimeoutIdentity() {
        return new EjbTimeoutIdentity();
    }

    /**
     * Create an instance of {@link MessageDestinationRef }
     * 
     */
    public MessageDestinationRef createMessageDestinationRef() {
        return new MessageDestinationRef();
    }

    /**
     * Create an instance of {@link ResourceManagers }
     * 
     */
    public ResourceManagers createResourceManagers() {
        return new ResourceManagers();
    }

    /**
     * Create an instance of {@link IorSecurityConfig }
     * 
     */
    public IorSecurityConfig createIorSecurityConfig() {
        return new IorSecurityConfig();
    }

    /**
     * Create an instance of {@link PortComponent }
     * 
     */
    public PortComponent createPortComponent() {
        return new PortComponent();
    }

    /**
     * Create an instance of {@link AsContext }
     * 
     */
    public AsContext createAsContext() {
        return new AsContext();
    }

    /**
     * Create an instance of {@link SecurityIdentity }
     * 
     */
    public SecurityIdentity createSecurityIdentity() {
        return new SecurityIdentity();
    }

    /**
     * Create an instance of {@link Handler }
     * 
     */
    public Handler createHandler() {
        return new Handler();
    }

    /**
     * Create an instance of {@link BatchCommitStrategy }
     * 
     */
    public BatchCommitStrategy createBatchCommitStrategy() {
        return new BatchCommitStrategy();
    }

    /**
     * Create an instance of {@link ContainerPoolConf }
     * 
     */
    public ContainerPoolConf createContainerPoolConf() {
        return new ContainerPoolConf();
    }

    /**
     * Create an instance of {@link MethodAttributes }
     * 
     */
    public MethodAttributes createMethodAttributes() {
        return new MethodAttributes();
    }

    /**
     * Create an instance of {@link PrincipalName }
     * 
     */
    public PrincipalName createPrincipalName() {
        return new PrincipalName();
    }

    /**
     * Create an instance of {@link JndiName }
     * 
     */
    public JndiName createJndiName() {
        return new JndiName();
    }

    /**
     * Create an instance of {@link Session }
     * 
     */
    public Session createSession() {
        return new Session();
    }

    /**
     * Create an instance of {@link Entity }
     * 
     */
    public Entity createEntity() {
        return new Entity();
    }

    /**
     * Create an instance of {@link ServiceRef }
     * 
     */
    public ServiceRef createServiceRef() {
        return new ServiceRef();
    }

    /**
     * Create an instance of {@link ContainerConfigurations }
     * 
     */
    public ContainerConfigurations createContainerConfigurations() {
        return new ContainerConfigurations();
    }

    /**
     * Create an instance of {@link ProxyFactoryConfig }
     * 
     */
    public ProxyFactoryConfig createProxyFactoryConfig() {
        return new ProxyFactoryConfig();
    }

    /**
     * Create an instance of {@link SecurityRole }
     * 
     */
    public SecurityRole createSecurityRole() {
        return new SecurityRole();
    }

    /**
     * Create an instance of {@link ResourceName }
     * 
     */
    public ResourceName createResourceName() {
        return new ResourceName();
    }

}
