/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.jarsigner;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.maven.shared.jarsigner.CommandLineConfigurationException;
import org.apache.maven.shared.jarsigner.DefaultJarSignerResult;
import org.apache.maven.shared.jarsigner.JarSigner;
import org.apache.maven.shared.jarsigner.JarSignerCommandLineBuilder;
import org.apache.maven.shared.jarsigner.JarSignerException;
import org.apache.maven.shared.jarsigner.JarSignerRequest;
import org.apache.maven.shared.jarsigner.JarSignerResult;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class DefaultJarSigner
extends AbstractLogEnabled
implements JarSigner {
    protected String jarSignerFile;

    public JarSignerResult execute(JarSignerRequest request) throws JarSignerException {
        if (this.jarSignerFile == null) {
            try {
                this.jarSignerFile = this.findJarSignerExecutable();
            }
            catch (IOException e) {
                throw new JarSignerException("Error finding jar signer executable. Reason: " + e.getMessage(), e);
            }
        }
        Commandline cli = this.createCommandLine(request);
        return this.executeCommandLine(cli, request);
    }

    protected Commandline createCommandLine(JarSignerRequest request) throws JarSignerException {
        JarSignerCommandLineBuilder cliBuilder = new JarSignerCommandLineBuilder();
        cliBuilder.setLogger(this.getLogger());
        cliBuilder.setJarSignerFile(this.jarSignerFile);
        try {
            return cliBuilder.build(request);
        }
        catch (CommandLineConfigurationException e) {
            throw new JarSignerException("Error configuring command-line. Reason: " + e.getMessage(), e);
        }
    }

    protected JarSignerResult executeCommandLine(Commandline cli, JarSignerRequest request) {
        StreamConsumer systemErr;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Executing: " + cli);
        }
        final boolean verbose = request.isVerbose();
        InputStream systemIn = new InputStream(){

            public int read() {
                return -1;
            }
        };
        StreamConsumer systemOut = request.getSystemOutStreamConsumer();
        if (systemOut == null) {
            systemOut = new StreamConsumer(){

                public void consumeLine(String line) {
                    if (verbose) {
                        DefaultJarSigner.this.getLogger().info(line);
                    } else {
                        DefaultJarSigner.this.getLogger().debug(line);
                    }
                }
            };
        }
        if ((systemErr = request.getSystemErrorStreamConsumer()) == null) {
            systemErr = new StreamConsumer(){

                public void consumeLine(String line) {
                    DefaultJarSigner.this.getLogger().warn(line);
                }
            };
        }
        DefaultJarSignerResult result = new DefaultJarSignerResult();
        result.setCommandline(cli);
        if (verbose) {
            this.getLogger().info(cli.toString());
        } else {
            this.getLogger().debug(cli.toString());
        }
        try {
            int resultCode = CommandLineUtils.executeCommandLine((Commandline)cli, (InputStream)systemIn, (StreamConsumer)systemOut, (StreamConsumer)systemErr);
            result.setExitCode(resultCode);
        }
        catch (CommandLineException e) {
            result.setExecutionException(e);
        }
        return result;
    }

    protected String findJarSignerExecutable() throws IOException {
        String command = "jarsigner" + (Os.isFamily((String)"windows") ? ".exe" : "");
        String executable = this.findExecutable(command, System.getProperty("java.home"), new String[]{"../bin", "bin", "../sh"});
        if (executable == null) {
            Map<String, String> env = System.getenv();
            String[] variables = new String[]{"JDK_HOME", "JAVA_HOME"};
            for (int i = 0; i < variables.length && executable == null; ++i) {
                executable = this.findExecutable(command, env.get(variables[i]), new String[]{"bin", "sh"});
            }
        }
        if (executable == null) {
            executable = command;
        }
        return executable;
    }

    protected String findExecutable(String command, String homeDir, String[] subDirs) {
        if (StringUtils.isNotEmpty((String)homeDir)) {
            for (int i = 0; i < subDirs.length; ++i) {
                File file = new File(new File(homeDir, subDirs[i]), command);
                if (!file.isFile()) continue;
                return file.getAbsolutePath();
            }
        }
        return null;
    }
}

