/*
 * $Id$
 */

package org.apache.maven.scm.providers.starteam.settings;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * Class Settings.
 * 
 * @version $Revision$ $Date$
 */
public class Settings implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Enable compression in all stdcmd.
     */
    private boolean compressionEnable = false;

    /**
     * EOL setting in all applicable stdcmd.
     */
    private String eol = "on";


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get eOL setting in all applicable stdcmd.
     * 
     * @return String
     */
    public String getEol()
    {
        return this.eol;
    } //-- String getEol() 

    /**
     * Get enable compression in all stdcmd.
     * 
     * @return boolean
     */
    public boolean isCompressionEnable()
    {
        return this.compressionEnable;
    } //-- boolean isCompressionEnable() 

    /**
     * Set enable compression in all stdcmd.
     * 
     * @param compressionEnable
     */
    public void setCompressionEnable(boolean compressionEnable)
    {
        this.compressionEnable = compressionEnable;
    } //-- void setCompressionEnable(boolean) 

    /**
     * Set eOL setting in all applicable stdcmd.
     * 
     * @param eol
     */
    public void setEol(String eol)
    {
        this.eol = eol;
    } //-- void setEol(String) 


    private String modelEncoding = "UTF-8";

    /**
     * Set an encoding used for reading/writing the model.
     *
     * @param modelEncoding the encoding used when reading/writing the model.
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    /**
     * @return the current encoding used when reading/writing this model.
     */
    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
