/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.starteam.command.changelog;

import java.util.Date;
import org.apache.maven.scm.ScmBranch;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.changelog.AbstractChangeLogCommand;
import org.apache.maven.scm.command.changelog.ChangeLogScmResult;
import org.apache.maven.scm.command.changelog.ChangeLogSet;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.starteam.command.StarteamCommand;
import org.apache.maven.scm.provider.starteam.command.StarteamCommandLineUtils;
import org.apache.maven.scm.provider.starteam.command.changelog.StarteamChangeLogConsumer;
import org.apache.maven.scm.provider.starteam.repository.StarteamScmProviderRepository;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class StarteamChangeLogCommand
extends AbstractChangeLogCommand
implements StarteamCommand {
    protected ChangeLogScmResult executeChangeLogCommand(ScmProviderRepository repo, ScmFileSet fileSet, Date startDate, Date endDate, ScmBranch branch, String datePattern) throws ScmException {
        int exitCode;
        if (branch != null || StringUtils.isNotEmpty((String)branch.getName())) {
            this.getLogger().warn("This provider doesn't support changelog with on a given branch.");
        }
        StarteamScmProviderRepository repository = (StarteamScmProviderRepository)repo;
        Commandline cl = StarteamChangeLogCommand.createCommandLine(repository, fileSet, startDate);
        StarteamChangeLogConsumer consumer = new StarteamChangeLogConsumer(fileSet.getBasedir(), this.getLogger(), startDate, endDate, datePattern);
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        try {
            exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)consumer, (StreamConsumer)stderr);
        }
        catch (CommandLineException ex) {
            throw new ScmException("Error while executing command.", (Throwable)ex);
        }
        if (exitCode != 0) {
            return new ChangeLogScmResult(cl.toString(), "The 'stcmd' command failed.", stderr.getOutput(), false);
        }
        return new ChangeLogScmResult(cl.toString(), new ChangeLogSet(consumer.getModifications(), startDate, endDate));
    }

    public static Commandline createCommandLine(StarteamScmProviderRepository repo, ScmFileSet workingDirectory, Date startDate) {
        return StarteamCommandLineUtils.createStarteamCommandLine("hist", null, workingDirectory, repo);
    }
}

