/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.local.command.checkin;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.checkin.AbstractCheckInCommand;
import org.apache.maven.scm.command.checkin.CheckInScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.local.command.LocalCommand;
import org.apache.maven.scm.provider.local.repository.LocalScmProviderRepository;
import org.apache.maven.scm.util.FilenameUtils;
import org.codehaus.plexus.util.FileUtils;

public class LocalCheckInCommand
extends AbstractCheckInCommand
implements LocalCommand {
    protected CheckInScmResult executeCheckInCommand(ScmProviderRepository repo, ScmFileSet fileSet, String message, ScmVersion version) throws ScmException {
        LocalScmProviderRepository repository = (LocalScmProviderRepository)repo;
        if (version != null && StringUtils.isNotEmpty((CharSequence)version.getName())) {
            throw new ScmException("The local scm doesn't support tags.");
        }
        File root = new File(repository.getRoot());
        String module = repository.getModule();
        File source = new File(root, module);
        File basedir = fileSet.getBasedir();
        if (!basedir.exists()) {
            throw new ScmException("The working directory doesn't exist (" + basedir.getAbsolutePath() + ").");
        }
        if (!root.exists()) {
            throw new ScmException("The base directory doesn't exist (" + root.getAbsolutePath() + ").");
        }
        if (!source.exists()) {
            throw new ScmException("The module directory doesn't exist (" + source.getAbsolutePath() + ").");
        }
        ArrayList<ScmFile> checkedInFiles = new ArrayList<ScmFile>();
        try {
            File repoRoot = new File(repository.getRoot(), repository.getModule());
            List files = fileSet.getFileList();
            if (files.isEmpty()) {
                files = FileUtils.getFiles((File)basedir, (String)"**", null, (boolean)false);
            }
            for (File file : files) {
                ScmFileStatus status;
                String path = FilenameUtils.normalizeFilename((String)file.getPath());
                File repoFile = new File(repoRoot, path);
                file = new File(basedir, path);
                if (repoFile.exists()) {
                    String repoFileContents = FileUtils.fileRead((File)repoFile);
                    String fileContents = FileUtils.fileRead((File)file);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("fileContents:" + fileContents);
                        this.logger.debug("repoFileContents:" + repoFileContents);
                    }
                    if (fileContents.equals(repoFileContents)) continue;
                    status = ScmFileStatus.CHECKED_IN;
                } else if (repository.isFileAdded(path)) {
                    status = ScmFileStatus.CHECKED_IN;
                } else {
                    if (!this.logger.isWarnEnabled()) continue;
                    this.logger.warn("skipped unknown file in checkin:" + path);
                    continue;
                }
                FileUtils.copyFile((File)file, (File)repoFile);
                ScmFile scmFile = new ScmFile(path, status);
                this.logger.info(scmFile.toString());
                checkedInFiles.add(scmFile);
            }
        }
        catch (IOException ex) {
            throw new ScmException("Error while checking in the files.", (Throwable)ex);
        }
        return new CheckInScmResult(null, checkedInFiles);
    }
}

