/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.maven.shared.release.AbstractReleaseRequest;
import org.apache.maven.shared.release.ReleaseBranchRequest;
import org.apache.maven.shared.release.ReleaseCleanRequest;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.ReleaseFailureException;
import org.apache.maven.shared.release.ReleaseManager;
import org.apache.maven.shared.release.ReleaseManagerListener;
import org.apache.maven.shared.release.ReleasePerformRequest;
import org.apache.maven.shared.release.ReleasePrepareRequest;
import org.apache.maven.shared.release.ReleaseResult;
import org.apache.maven.shared.release.ReleaseRollbackRequest;
import org.apache.maven.shared.release.ReleaseUpdateVersionsRequest;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.config.ReleaseDescriptorBuilder;
import org.apache.maven.shared.release.config.ReleaseDescriptorStore;
import org.apache.maven.shared.release.config.ReleaseDescriptorStoreException;
import org.apache.maven.shared.release.config.ReleaseUtils;
import org.apache.maven.shared.release.phase.ReleasePhase;
import org.apache.maven.shared.release.phase.ResourceGenerator;
import org.apache.maven.shared.release.strategy.Strategy;
import org.codehaus.plexus.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named
public class DefaultReleaseManager
implements ReleaseManager {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, Strategy> strategies;
    private final Map<String, ReleasePhase> releasePhases;
    private final AtomicReference<ReleaseDescriptorStore> configStore;

    @Inject
    public DefaultReleaseManager(Map<String, Strategy> strategies, Map<String, ReleasePhase> releasePhases, @Named(value="properties") ReleaseDescriptorStore configStore) {
        this.strategies = Objects.requireNonNull(strategies);
        this.releasePhases = Objects.requireNonNull(releasePhases);
        this.configStore = new AtomicReference<ReleaseDescriptorStore>(Objects.requireNonNull(configStore));
    }

    public void setConfigStore(ReleaseDescriptorStore configStore) {
        this.configStore.set(configStore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReleaseResult prepareWithResult(ReleasePrepareRequest prepareRequest) {
        ReleaseResult result = new ReleaseResult();
        result.setStartTime(System.currentTimeMillis());
        try {
            this.prepare(prepareRequest, result);
            result.setResultCode(0);
        }
        catch (ReleaseExecutionException | ReleaseFailureException e) {
            this.captureException(result, prepareRequest.getReleaseManagerListener(), (Exception)e);
        }
        finally {
            result.setEndTime(System.currentTimeMillis());
        }
        return result;
    }

    @Override
    public void prepare(ReleasePrepareRequest prepareRequest) throws ReleaseExecutionException, ReleaseFailureException {
        this.prepare(prepareRequest, new ReleaseResult());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepare(ReleasePrepareRequest prepareRequest, ReleaseResult result) throws ReleaseExecutionException, ReleaseFailureException {
        final ReleaseDescriptorBuilder builder = prepareRequest.getReleaseDescriptorBuilder();
        ReleaseUtils.copyPropertiesToReleaseDescriptor(prepareRequest.getUserProperties(), new ReleaseDescriptorBuilder(){

            @Override
            public ReleaseDescriptorBuilder addDevelopmentVersion(String key, String value) {
                builder.addDevelopmentVersion(key, value);
                return this;
            }

            @Override
            public ReleaseDescriptorBuilder addReleaseVersion(String key, String value) {
                builder.addReleaseVersion(key, value);
                return this;
            }

            @Override
            public ReleaseDescriptorBuilder addDependencyReleaseVersion(String dependencyKey, String version) {
                builder.addDependencyReleaseVersion(dependencyKey, version);
                return this;
            }

            @Override
            public ReleaseDescriptorBuilder addDependencyDevelopmentVersion(String dependencyKey, String version) {
                builder.addDependencyDevelopmentVersion(dependencyKey, version);
                return this;
            }
        });
        ReleaseDescriptorBuilder.BuilderReleaseDescriptor config = BooleanUtils.isNotFalse((Boolean)prepareRequest.getResume()) ? this.loadReleaseDescriptor(builder, prepareRequest.getReleaseManagerListener()) : ReleaseUtils.buildReleaseDescriptor(builder);
        Strategy releaseStrategy = this.getStrategy(config.getReleaseStrategyId());
        List<String> preparePhases = this.getGoalPhases(releaseStrategy, "prepare");
        this.goalStart(prepareRequest.getReleaseManagerListener(), "prepare", preparePhases);
        String completedPhase = config.getCompletedPhase();
        int index = preparePhases.indexOf(completedPhase);
        for (int idx = 0; idx <= index; ++idx) {
            this.phaseSkip(prepareRequest.getReleaseManagerListener(), preparePhases.get(idx));
        }
        if (index == preparePhases.size() - 1) {
            this.logInfo(result, "Release preparation already completed. You can now continue with release:perform, or start again using the -Dresume=false flag");
        } else if (index >= 0) {
            this.logInfo(result, "Resuming release from phase '" + preparePhases.get(index + 1) + "'");
        }
        for (int i = index + 1; i < preparePhases.size(); ++i) {
            String name = preparePhases.get(i);
            ReleasePhase phase = this.releasePhases.get(name);
            if (phase == null) {
                throw new ReleaseExecutionException("Unable to find phase '" + name + "' to execute");
            }
            this.phaseStart(prepareRequest.getReleaseManagerListener(), name);
            ReleaseResult phaseResult = null;
            try {
                phaseResult = BooleanUtils.isTrue((Boolean)prepareRequest.getDryRun()) ? phase.simulate((ReleaseDescriptor)config, prepareRequest.getReleaseEnvironment(), prepareRequest.getReactorProjects()) : phase.execute((ReleaseDescriptor)config, prepareRequest.getReleaseEnvironment(), prepareRequest.getReactorProjects());
            }
            finally {
                if (result != null && phaseResult != null) {
                    result.appendOutput(phaseResult.getOutput());
                }
            }
            config.setCompletedPhase(name);
            try {
                this.configStore.get().write(config);
            }
            catch (ReleaseDescriptorStoreException e) {
                throw new ReleaseExecutionException("Error writing release properties after completing phase", (Throwable)e);
            }
            this.phaseEnd(prepareRequest.getReleaseManagerListener());
        }
        this.goalEnd(prepareRequest.getReleaseManagerListener());
    }

    @Override
    public void rollback(ReleaseRollbackRequest rollbackRequest) throws ReleaseExecutionException, ReleaseFailureException {
        ReleaseDescriptorBuilder.BuilderReleaseDescriptor releaseDescriptor = this.loadReleaseDescriptor(rollbackRequest.getReleaseDescriptorBuilder(), null);
        Strategy releaseStrategy = this.getStrategy(releaseDescriptor.getReleaseStrategyId());
        List<String> rollbackPhases = this.getGoalPhases(releaseStrategy, "rollback");
        this.goalStart(rollbackRequest.getReleaseManagerListener(), "rollback", rollbackPhases);
        for (String name : rollbackPhases) {
            ReleasePhase phase = this.releasePhases.get(name);
            if (phase == null) {
                throw new ReleaseExecutionException("Unable to find phase '" + name + "' to execute");
            }
            this.phaseStart(rollbackRequest.getReleaseManagerListener(), name);
            phase.execute((ReleaseDescriptor)releaseDescriptor, rollbackRequest.getReleaseEnvironment(), rollbackRequest.getReactorProjects());
            this.phaseEnd(rollbackRequest.getReleaseManagerListener());
        }
        this.clean(rollbackRequest);
        this.goalEnd(rollbackRequest.getReleaseManagerListener());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReleaseResult performWithResult(ReleasePerformRequest performRequest) {
        ReleaseResult result = new ReleaseResult();
        try {
            result.setStartTime(System.currentTimeMillis());
            this.perform(performRequest, result);
            result.setResultCode(0);
        }
        catch (ReleaseExecutionException | ReleaseFailureException e) {
            this.captureException(result, performRequest.getReleaseManagerListener(), (Exception)e);
        }
        finally {
            result.setEndTime(System.currentTimeMillis());
        }
        return result;
    }

    @Override
    public void perform(ReleasePerformRequest performRequest) throws ReleaseExecutionException, ReleaseFailureException {
        this.perform(performRequest, new ReleaseResult());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void perform(ReleasePerformRequest performRequest, ReleaseResult result) throws ReleaseExecutionException, ReleaseFailureException {
        List<String> specificProfiles = ReleaseUtils.buildReleaseDescriptor(performRequest.getReleaseDescriptorBuilder()).getActivateProfiles();
        ReleaseDescriptorBuilder builder = this.loadReleaseDescriptorBuilder(performRequest.getReleaseDescriptorBuilder(), performRequest.getReleaseManagerListener());
        if (specificProfiles != null && !specificProfiles.isEmpty()) {
            ArrayList<String> allProfiles = new ArrayList<String>(ReleaseUtils.buildReleaseDescriptor(builder).getActivateProfiles());
            for (String specificProfile : specificProfiles) {
                if (allProfiles.contains(specificProfile)) continue;
                allProfiles.add(specificProfile);
            }
            builder.setActivateProfiles(allProfiles);
        }
        ReleaseDescriptorBuilder.BuilderReleaseDescriptor releaseDescriptor = ReleaseUtils.buildReleaseDescriptor(builder);
        Strategy releaseStrategy = this.getStrategy(releaseDescriptor.getReleaseStrategyId());
        List<String> performPhases = this.getGoalPhases(releaseStrategy, "perform");
        this.goalStart(performRequest.getReleaseManagerListener(), "perform", performPhases);
        for (String name : performPhases) {
            ReleasePhase phase = this.releasePhases.get(name);
            if (phase == null) {
                throw new ReleaseExecutionException("Unable to find phase '" + name + "' to execute");
            }
            this.phaseStart(performRequest.getReleaseManagerListener(), name);
            ReleaseResult phaseResult = null;
            try {
                phaseResult = BooleanUtils.isTrue((Boolean)performRequest.getDryRun()) ? phase.simulate((ReleaseDescriptor)releaseDescriptor, performRequest.getReleaseEnvironment(), performRequest.getReactorProjects()) : phase.execute((ReleaseDescriptor)releaseDescriptor, performRequest.getReleaseEnvironment(), performRequest.getReactorProjects());
            }
            finally {
                if (result != null && phaseResult != null) {
                    result.appendOutput(phaseResult.getOutput());
                }
            }
            this.phaseEnd(performRequest.getReleaseManagerListener());
        }
        if (BooleanUtils.isNotFalse((Boolean)performRequest.getClean())) {
            this.clean(performRequest);
        }
        this.goalEnd(performRequest.getReleaseManagerListener());
    }

    @Override
    public void branch(ReleaseBranchRequest branchRequest) throws ReleaseExecutionException, ReleaseFailureException {
        final ReleaseDescriptorBuilder builder = branchRequest.getReleaseDescriptorBuilder();
        ReleaseUtils.copyPropertiesToReleaseDescriptor(branchRequest.getUserProperties(), new ReleaseDescriptorBuilder(){

            @Override
            public ReleaseDescriptorBuilder addDevelopmentVersion(String key, String value) {
                builder.addDevelopmentVersion(key, value);
                return this;
            }

            @Override
            public ReleaseDescriptorBuilder addReleaseVersion(String key, String value) {
                builder.addReleaseVersion(key, value);
                return this;
            }
        });
        ReleaseDescriptorBuilder.BuilderReleaseDescriptor releaseDescriptor = this.loadReleaseDescriptor(builder, branchRequest.getReleaseManagerListener());
        boolean dryRun = BooleanUtils.isTrue((Boolean)branchRequest.getDryRun());
        Strategy releaseStrategy = this.getStrategy(releaseDescriptor.getReleaseStrategyId());
        List<String> branchPhases = this.getGoalPhases(releaseStrategy, "branch");
        this.goalStart(branchRequest.getReleaseManagerListener(), "branch", branchPhases);
        for (String name : branchPhases) {
            ReleasePhase phase = this.releasePhases.get(name);
            if (phase == null) {
                throw new ReleaseExecutionException("Unable to find phase '" + name + "' to execute");
            }
            this.phaseStart(branchRequest.getReleaseManagerListener(), name);
            if (dryRun) {
                phase.simulate((ReleaseDescriptor)releaseDescriptor, branchRequest.getReleaseEnvironment(), branchRequest.getReactorProjects());
            } else {
                phase.execute((ReleaseDescriptor)releaseDescriptor, branchRequest.getReleaseEnvironment(), branchRequest.getReactorProjects());
            }
            this.phaseEnd(branchRequest.getReleaseManagerListener());
        }
        if (!dryRun) {
            this.clean(branchRequest);
        }
        this.goalEnd(branchRequest.getReleaseManagerListener());
    }

    @Override
    public void updateVersions(ReleaseUpdateVersionsRequest updateVersionsRequest) throws ReleaseExecutionException, ReleaseFailureException {
        final ReleaseDescriptorBuilder builder = updateVersionsRequest.getReleaseDescriptorBuilder();
        ReleaseUtils.copyPropertiesToReleaseDescriptor(updateVersionsRequest.getUserProperties(), new ReleaseDescriptorBuilder(){

            @Override
            public ReleaseDescriptorBuilder addDevelopmentVersion(String key, String value) {
                builder.addDevelopmentVersion(key, value);
                return this;
            }

            @Override
            public ReleaseDescriptorBuilder addReleaseVersion(String key, String value) {
                builder.addReleaseVersion(key, value);
                return this;
            }
        });
        ReleaseDescriptorBuilder.BuilderReleaseDescriptor releaseDescriptor = this.loadReleaseDescriptor(builder, updateVersionsRequest.getReleaseManagerListener());
        Strategy releaseStrategy = this.getStrategy(releaseDescriptor.getReleaseStrategyId());
        List<String> updateVersionsPhases = this.getGoalPhases(releaseStrategy, "updateVersions");
        this.goalStart(updateVersionsRequest.getReleaseManagerListener(), "updateVersions", updateVersionsPhases);
        for (String name : updateVersionsPhases) {
            ReleasePhase phase = this.releasePhases.get(name);
            if (phase == null) {
                throw new ReleaseExecutionException("Unable to find phase '" + name + "' to execute");
            }
            this.phaseStart(updateVersionsRequest.getReleaseManagerListener(), name);
            phase.execute((ReleaseDescriptor)releaseDescriptor, updateVersionsRequest.getReleaseEnvironment(), updateVersionsRequest.getReactorProjects());
            this.phaseEnd(updateVersionsRequest.getReleaseManagerListener());
        }
        this.clean(updateVersionsRequest);
        this.goalEnd(updateVersionsRequest.getReleaseManagerListener());
    }

    protected File determineWorkingDirectory(File checkoutDirectory, String relativePathProjectDirectory) {
        if (StringUtils.isNotEmpty((String)relativePathProjectDirectory)) {
            return new File(checkoutDirectory, relativePathProjectDirectory);
        }
        return checkoutDirectory;
    }

    private ReleaseDescriptorBuilder.BuilderReleaseDescriptor loadReleaseDescriptor(ReleaseDescriptorBuilder builder, ReleaseManagerListener listener) throws ReleaseExecutionException {
        return ReleaseUtils.buildReleaseDescriptor(this.loadReleaseDescriptorBuilder(builder, listener));
    }

    private ReleaseDescriptorBuilder loadReleaseDescriptorBuilder(ReleaseDescriptorBuilder builder, ReleaseManagerListener listener) throws ReleaseExecutionException {
        try {
            return this.configStore.get().read(builder);
        }
        catch (ReleaseDescriptorStoreException e) {
            throw new ReleaseExecutionException("Error reading stored configuration: " + e.getMessage(), (Throwable)e);
        }
    }

    protected void clean(AbstractReleaseRequest releaseRequest) throws ReleaseFailureException {
        ReleaseCleanRequest cleanRequest = new ReleaseCleanRequest();
        cleanRequest.setReleaseDescriptorBuilder(releaseRequest.getReleaseDescriptorBuilder());
        cleanRequest.setReleaseManagerListener(releaseRequest.getReleaseManagerListener());
        cleanRequest.setReactorProjects(releaseRequest.getReactorProjects());
        this.clean(cleanRequest);
    }

    @Override
    public void clean(ReleaseCleanRequest cleanRequest) throws ReleaseFailureException {
        this.logger.info("Cleaning up after release...");
        ReleaseDescriptorBuilder.BuilderReleaseDescriptor releaseDescriptor = ReleaseUtils.buildReleaseDescriptor(cleanRequest.getReleaseDescriptorBuilder());
        this.configStore.get().delete(releaseDescriptor);
        Strategy releaseStrategy = this.getStrategy(releaseDescriptor.getReleaseStrategyId());
        LinkedHashSet<String> phases = new LinkedHashSet<String>();
        phases.addAll(this.getGoalPhases(releaseStrategy, "prepare"));
        phases.addAll(this.getGoalPhases(releaseStrategy, "branch"));
        for (String name : phases) {
            ReleasePhase phase = this.releasePhases.get(name);
            if (!(phase instanceof ResourceGenerator)) continue;
            ((ResourceGenerator)phase).clean(cleanRequest.getReactorProjects());
        }
    }

    void goalStart(ReleaseManagerListener listener, String goal, List<String> phases) {
        if (listener != null) {
            listener.goalStart(goal, phases);
        }
    }

    void goalEnd(ReleaseManagerListener listener) {
        if (listener != null) {
            listener.goalEnd();
        }
    }

    void phaseSkip(ReleaseManagerListener listener, String name) {
        if (listener != null) {
            listener.phaseSkip(name);
        }
    }

    void phaseStart(ReleaseManagerListener listener, String name) {
        if (listener != null) {
            listener.phaseStart(name);
        }
    }

    void phaseEnd(ReleaseManagerListener listener) {
        if (listener != null) {
            listener.phaseEnd();
        }
    }

    void error(ReleaseManagerListener listener, String name) {
        if (listener != null) {
            listener.error(name);
        }
    }

    private Strategy getStrategy(String strategyId) throws ReleaseFailureException {
        Strategy strategy = this.strategies.get(strategyId);
        if (strategy == null) {
            throw new ReleaseFailureException("Unknown strategy: " + strategyId);
        }
        return strategy;
    }

    private List<String> getGoalPhases(Strategy strategy, String goal) {
        List phases;
        if ("prepare".equals(goal)) {
            phases = strategy.getPreparePhases();
            if (phases == null) {
                phases = this.strategies.get("default").getPreparePhases();
            }
        } else if ("perform".equals(goal)) {
            phases = strategy.getPerformPhases();
            if (phases == null) {
                phases = this.strategies.get("default").getPerformPhases();
            }
        } else if ("rollback".equals(goal)) {
            phases = strategy.getRollbackPhases();
            if (phases == null) {
                phases = this.strategies.get("default").getRollbackPhases();
            }
        } else if ("branch".equals(goal)) {
            phases = strategy.getBranchPhases();
            if (phases == null) {
                phases = this.strategies.get("default").getBranchPhases();
            }
        } else if ("updateVersions".equals(goal)) {
            phases = strategy.getUpdateVersionsPhases();
            if (phases == null) {
                phases = this.strategies.get("default").getUpdateVersionsPhases();
            }
        } else {
            phases = null;
        }
        return Collections.unmodifiableList(phases);
    }

    private void logInfo(ReleaseResult result, String message) {
        if (result != null) {
            result.appendInfo(message);
        }
        this.logger.info(message);
    }

    private void captureException(ReleaseResult result, ReleaseManagerListener listener, Exception e) {
        if (listener != null) {
            listener.error(e.getMessage());
        }
        result.appendError(e);
        result.setResultCode(1);
    }
}

