/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.site.render;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.apache.maven.doxia.siterenderer.DocumentRenderer;
import org.apache.maven.doxia.siterenderer.DoxiaDocumentRenderer;
import org.apache.maven.doxia.siterenderer.RendererException;
import org.apache.maven.doxia.siterenderer.SiteRenderingContext;
import org.apache.maven.doxia.tools.SiteTool;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.plugins.site.render.AbstractSiteRenderingMojo;
import org.apache.maven.plugins.site.render.ReportDocumentRenderer;
import org.apache.maven.plugins.site.render.SitePluginReportDocumentRenderer;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.MavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.reporting.exec.MavenReportExecution;
import org.apache.maven.shared.utils.logging.MessageBuilder;
import org.apache.maven.shared.utils.logging.MessageUtils;

@Mojo(name="site", requiresDependencyResolution=ResolutionScope.TEST, requiresReports=true, threadSafe=true)
public class SiteMojo
extends AbstractSiteRenderingMojo {
    @Parameter(property="siteOutputDirectory", defaultValue="${project.reporting.outputDirectory}")
    protected File outputDirectory;
    @Parameter(property="generateReports", defaultValue="true")
    private boolean generateReports;
    @Parameter(property="validate", defaultValue="false")
    private boolean validate;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"maven.site.skip = true: Skipping site generation");
            return;
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)"executing Site Mojo");
        }
        this.checkInputEncoding();
        List<Object> reports = this.generateReports ? this.getReports() : Collections.emptyList();
        try {
            List<Locale> localesList = this.getLocales();
            for (Locale locale : localesList) {
                this.getLog().info((CharSequence)("Rendering site for " + MessageUtils.buffer().strong((Object)(!locale.equals(SiteTool.DEFAULT_LOCALE) ? "locale '" + locale + "'" : "default locale")).toString()));
                this.renderLocale(locale, reports, localesList);
            }
        }
        catch (RendererException e) {
            if (e.getCause() instanceof MavenReportException) {
                throw new MojoExecutionException(e.getMessage(), e.getCause());
            }
            throw new MojoExecutionException("Failed to render reports", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error during site generation", (Exception)e);
        }
    }

    private void renderLocale(Locale locale, List<MavenReportExecution> reports, List<Locale> supportedLocales) throws IOException, RendererException, MojoFailureException, MojoExecutionException {
        SiteRenderingContext context = this.createSiteRenderingContext(locale);
        context.addSiteLocales(supportedLocales);
        if (!locale.equals(SiteTool.DEFAULT_LOCALE)) {
            context.addSiteDirectory(new File(this.generatedSiteDirectory, locale.toString()));
        } else {
            context.addSiteDirectory(this.generatedSiteDirectory);
        }
        context.setInputEncoding(this.getInputEncoding());
        context.setOutputEncoding(this.getOutputEncoding());
        context.setValidate(this.validate);
        if (this.validate) {
            this.getLog().info((CharSequence)"Validation is switched on, xml input documents will be validated!");
        }
        File outputDir = this.getOutputDirectory(locale);
        Map<String, DocumentRenderer> documents = this.locateDocuments(context, reports, locale);
        this.siteRenderer.copyResources(context, outputDir);
        List<DocumentRenderer> nonDoxiaDocuments = this.renderDoxiaDocuments(documents, context, outputDir, false);
        for (MavenReportExecution mavenReportExecution : reports) {
            MavenReport report = mavenReportExecution.getMavenReport();
            report.setReportOutputDirectory(outputDir);
        }
        this.renderNonDoxiaDocuments(nonDoxiaDocuments, context, outputDir);
        context.getSiteDirectories().clear();
        if (!locale.equals(SiteTool.DEFAULT_LOCALE)) {
            context.addSiteDirectory(new File(this.generatedSiteDirectory, locale.toString()));
        } else {
            context.addSiteDirectory(this.generatedSiteDirectory);
        }
        Map generatedDocuments = this.siteRenderer.locateDocumentFiles(context, false);
        this.renderDoxiaDocuments(generatedDocuments, context, outputDir, true);
        this.siteRenderer.copyResources(context, outputDir);
    }

    private List<DocumentRenderer> renderDoxiaDocuments(Map<String, DocumentRenderer> documents, SiteRenderingContext context, File outputDir, boolean generated) throws RendererException, IOException {
        TreeMap<String, DocumentRenderer> doxiaDocuments = new TreeMap<String, DocumentRenderer>();
        ArrayList<DocumentRenderer> nonDoxiaDocuments = new ArrayList<DocumentRenderer>();
        TreeMap<String, Integer> counts = new TreeMap<String, Integer>();
        for (Map.Entry<String, DocumentRenderer> entry : documents.entrySet()) {
            DocumentRenderer doc = entry.getValue();
            if (doc instanceof DoxiaDocumentRenderer) {
                doxiaDocuments.put(entry.getKey(), doc);
                DoxiaDocumentRenderer doxia = (DoxiaDocumentRenderer)doc;
                String parserId = doxia.getRenderingContext().getParserId();
                Integer count = (Integer)counts.get(parserId);
                if (count == null) {
                    count = 1;
                } else {
                    Integer n = count;
                    Integer n2 = count = Integer.valueOf(count + 1);
                }
                counts.put(parserId, count);
                continue;
            }
            nonDoxiaDocuments.add(doc);
        }
        if (doxiaDocuments.size() > 0) {
            MessageBuilder mb = MessageUtils.buffer();
            mb.a((CharSequence)"Rendering ");
            mb.strong((Object)(doxiaDocuments.size() + (generated ? " generated" : "") + " Doxia document" + (doxiaDocuments.size() > 1 ? "s" : "")));
            mb.a((CharSequence)": ");
            boolean first = true;
            for (Map.Entry entry : counts.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    mb.a((CharSequence)", ");
                }
                mb.strong((Object)(entry.getValue() + " " + (String)entry.getKey()));
            }
            this.getLog().info((CharSequence)mb.toString());
            this.siteRenderer.render(doxiaDocuments.values(), context, outputDir);
        }
        return nonDoxiaDocuments;
    }

    private void renderNonDoxiaDocuments(List<DocumentRenderer> documents, SiteRenderingContext context, File outputDir) throws RendererException, IOException {
        Integer count;
        String type;
        TreeMap<String, Integer> counts = new TreeMap<String, Integer>();
        for (DocumentRenderer documentRenderer : documents) {
            type = documentRenderer instanceof ReportDocumentRenderer || documentRenderer instanceof SitePluginReportDocumentRenderer ? "report" : "other";
            count = (Integer)counts.get(type);
            if (count == null) {
                count = 1;
            } else {
                Integer n = count;
                Integer n2 = count = Integer.valueOf(count + 1);
            }
            counts.put(type, count);
        }
        if (documents.size() > 0) {
            for (Map.Entry entry : counts.entrySet()) {
                type = (String)entry.getKey();
                count = (Integer)entry.getValue();
                MessageBuilder mb = MessageUtils.buffer();
                mb.a((CharSequence)"Rendering ");
                mb.strong((Object)(count + " " + type + " document" + (count > 1 ? "s" : "")));
                this.getLog().info((CharSequence)mb.toString());
            }
            this.siteRenderer.render(documents, context, outputDir);
        }
    }

    private File getOutputDirectory(Locale locale) {
        File file = !locale.equals(SiteTool.DEFAULT_LOCALE) ? new File(this.outputDirectory, locale.toString()) : this.outputDirectory;
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public MavenSession getSession() {
        return this.mavenSession;
    }
}

