/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.invoker;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.invoker.BeanShellScriptInterpreter;
import org.apache.maven.plugin.invoker.BuildErrorException;
import org.apache.maven.plugin.invoker.BuildFailureException;
import org.apache.maven.plugin.invoker.FileLogger;
import org.apache.maven.plugin.invoker.GroovyScriptInterpreter;
import org.apache.maven.plugin.invoker.ScriptEvaluationException;
import org.apache.maven.plugin.invoker.ScriptInterpreter;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

class ScriptRunner {
    private Log log;
    private Map scriptInterpreters;
    private Map globalVariables;
    private List classPath;
    private String encoding;

    public ScriptRunner(Log log) {
        if (log == null) {
            throw new IllegalArgumentException("missing logger");
        }
        this.log = log;
        this.scriptInterpreters = new LinkedHashMap();
        this.scriptInterpreters.put("bsh", new BeanShellScriptInterpreter());
        this.scriptInterpreters.put("groovy", new GroovyScriptInterpreter());
        this.globalVariables = new HashMap();
        this.classPath = new ArrayList();
    }

    private Log getLog() {
        return this.log;
    }

    public void setGlobalVariable(String name, Object value) {
        this.globalVariables.put(name, value);
    }

    public void setClassPath(List classPath) {
        this.classPath = classPath != null ? new ArrayList(classPath) : new ArrayList();
    }

    public void setScriptEncoding(String encoding) {
        this.encoding = StringUtils.isNotEmpty((String)encoding) ? encoding : null;
    }

    public void run(String scriptDescription, File basedir, String relativeScriptPath, Map context, FileLogger logger, String stage, boolean failOnException) throws MojoExecutionException, BuildFailureException {
        Object result;
        String script;
        if (relativeScriptPath == null) {
            return;
        }
        File scriptFile = this.resolveScript(new File(basedir, relativeScriptPath));
        if (!scriptFile.exists()) {
            return;
        }
        HashMap<String, Object> globalVariables = new HashMap<String, Object>(this.globalVariables);
        globalVariables.put("basedir", basedir);
        globalVariables.put("context", context);
        PrintStream out = logger != null ? logger.getPrintStream() : null;
        ScriptInterpreter interpreter = this.getInterpreter(scriptFile);
        if (this.getLog().isDebugEnabled()) {
            String name = interpreter.getClass().getName();
            name = name.substring(name.lastIndexOf(46) + 1);
            this.getLog().debug((CharSequence)("Running script with " + name + ": " + scriptFile));
        }
        try {
            script = FileUtils.fileRead((File)scriptFile, (String)this.encoding);
        }
        catch (IOException e) {
            String errorMessage = "error reading " + scriptDescription + " " + scriptFile.getPath() + ", " + e.getMessage();
            throw new MojoExecutionException(errorMessage, (Exception)e);
        }
        try {
            if (logger != null) {
                logger.consumeLine("Running " + scriptDescription + ": " + scriptFile);
            }
            result = interpreter.evaluateScript(script, this.classPath, globalVariables, out);
            if (logger != null) {
                logger.consumeLine("Finished " + scriptDescription + ": " + scriptFile);
            }
        }
        catch (ScriptEvaluationException e) {
            String msg;
            Throwable t = e.getCause() != null ? e.getCause() : e;
            String string = msg = t.getMessage() != null ? t.getMessage() : t.toString();
            if (this.getLog().isDebugEnabled()) {
                String errorMessage = "Error evaluating " + scriptDescription + " " + scriptFile.getPath() + ", " + t;
                this.getLog().debug((CharSequence)errorMessage, t);
            }
            if (logger != null) {
                t.printStackTrace(logger.getPrintStream());
            }
            if (failOnException) {
                throw new BuildFailureException("The " + scriptDescription + " did not succeed. " + msg, stage);
            }
            throw new BuildErrorException("The " + scriptDescription + " did not succeed. " + msg, stage, t);
        }
        if (result != null && !Boolean.TRUE.equals(result) && !"true".equals(result)) {
            throw new BuildFailureException("The " + scriptDescription + " returned " + result + ".", stage);
        }
    }

    private File resolveScript(File scriptFile) {
        if (scriptFile != null && !scriptFile.exists()) {
            Iterator it = this.scriptInterpreters.keySet().iterator();
            while (it.hasNext()) {
                String ext = (String)it.next();
                File candidateFile = new File(scriptFile.getPath() + '.' + ext);
                if (!candidateFile.exists()) continue;
                scriptFile = candidateFile;
                break;
            }
        }
        return scriptFile;
    }

    private ScriptInterpreter getInterpreter(File scriptFile) {
        String ext = FileUtils.extension((String)scriptFile.getName()).toLowerCase(Locale.ENGLISH);
        ScriptInterpreter interpreter = (ScriptInterpreter)this.scriptInterpreters.get(ext);
        if (interpreter == null) {
            interpreter = (ScriptInterpreter)this.scriptInterpreters.get("bsh");
        }
        return interpreter;
    }
}

