/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.invoker;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.installer.ArtifactInstaller;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.invoker.MetadataUtils;
import org.apache.maven.plugin.invoker.PomUtils;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;

public class InstallMojo
extends AbstractMojo {
    private ArtifactInstaller installer;
    private ArtifactFactory artifactFactory;
    private ArtifactRepositoryFactory repositoryFactory;
    private ArtifactRepository localRepository;
    private File localRepositoryPath;
    private MavenProject project;
    private Collection reactorProjects;
    private boolean skipInstallation;
    private Collection installedArtifacts;
    private Collection copiedArtifacts;

    public void execute() throws MojoExecutionException {
        if (this.skipInstallation) {
            this.getLog().info((CharSequence)"Skipping artifact installation per configuration.");
            return;
        }
        ArtifactRepository testRepository = this.createTestRepository();
        this.installedArtifacts = new HashSet();
        this.copiedArtifacts = new HashSet();
        this.installProjectDependencies(this.project, this.reactorProjects, testRepository);
        this.installProjectParents(this.project, testRepository);
        this.installProjectArtifacts(this.project, testRepository);
    }

    private ArtifactRepository createTestRepository() throws MojoExecutionException {
        ArtifactRepository testRepository = this.localRepository;
        if (this.localRepositoryPath != null) {
            try {
                if (!this.localRepositoryPath.exists() && !this.localRepositoryPath.mkdirs()) {
                    throw new IOException("Failed to create directory: " + this.localRepositoryPath);
                }
                testRepository = this.repositoryFactory.createArtifactRepository(this.localRepository.getId(), this.localRepositoryPath.toURL().toExternalForm(), this.localRepository.getLayout(), this.localRepository.getSnapshots(), this.localRepository.getReleases());
            }
            catch (Exception e) {
                throw new MojoExecutionException("Failed to create local repository: " + this.localRepositoryPath, e);
            }
        }
        return testRepository;
    }

    private void installArtifact(File file, Artifact artifact, ArtifactRepository testRepository) throws MojoExecutionException {
        try {
            if (file == null) {
                throw new IllegalStateException("Artifact has no associated file: " + file);
            }
            if (!file.isFile()) {
                throw new IllegalStateException("Artifact is not fully assembled: " + file);
            }
            if (this.installedArtifacts.add(artifact.getId())) {
                this.installer.install(file, artifact, testRepository);
            } else {
                this.getLog().debug((CharSequence)("Not re-installing " + artifact + ", " + file));
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to install artifact: " + artifact, e);
        }
    }

    private void copyArtifact(File file, Artifact artifact, ArtifactRepository testRepository) throws MojoExecutionException {
        try {
            if (file == null) {
                throw new IllegalStateException("Artifact has no associated file: " + file);
            }
            if (!file.isFile()) {
                throw new IllegalStateException("Artifact is not fully assembled: " + file);
            }
            if (this.copiedArtifacts.add(artifact.getId())) {
                File destination = new File(testRepository.getBasedir(), testRepository.pathOf(artifact));
                this.getLog().debug((CharSequence)("Installing " + file + " to " + destination));
                this.copyFileIfDifferent(file, destination);
                MetadataUtils.createMetadata(destination, artifact);
            } else {
                this.getLog().debug((CharSequence)("Not re-installing " + artifact + ", " + file));
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to stage artifact: " + artifact, e);
        }
    }

    private void copyFileIfDifferent(File src, File dst) throws IOException {
        if (src.lastModified() != dst.lastModified() || src.length() != dst.length()) {
            FileUtils.copyFile((File)src, (File)dst);
            dst.setLastModified(src.lastModified());
        }
    }

    private void installProjectArtifacts(MavenProject mvnProject, ArtifactRepository testRepository) throws MojoExecutionException {
        try {
            this.installProjectPom(mvnProject, testRepository);
            Artifact mainArtifact = mvnProject.getArtifact();
            if (mainArtifact.getFile() != null) {
                this.installArtifact(mainArtifact.getFile(), mainArtifact, testRepository);
            }
            List attachedArtifacts = mvnProject.getAttachedArtifacts();
            Iterator artifactIter = attachedArtifacts.iterator();
            while (artifactIter.hasNext()) {
                Artifact attachedArtifact = (Artifact)artifactIter.next();
                this.installArtifact(attachedArtifact.getFile(), attachedArtifact, testRepository);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to install project artifacts: " + mvnProject, e);
        }
    }

    private void installProjectParents(MavenProject mvnProject, ArtifactRepository testRepository) throws MojoExecutionException {
        try {
            for (MavenProject parent = mvnProject.getParent(); parent != null; parent = parent.getParent()) {
                if (parent.getFile() == null) {
                    this.copyParentPoms(parent.getGroupId(), parent.getArtifactId(), parent.getVersion(), testRepository);
                    break;
                }
                this.installProjectPom(parent, testRepository);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to install project parents: " + mvnProject, e);
        }
    }

    private void installProjectPom(MavenProject mvnProject, ArtifactRepository testRepository) throws MojoExecutionException {
        try {
            Artifact pomArtifact = null;
            if ("pom".equals(mvnProject.getPackaging())) {
                pomArtifact = mvnProject.getArtifact();
            }
            if (pomArtifact == null) {
                pomArtifact = this.artifactFactory.createProjectArtifact(mvnProject.getGroupId(), mvnProject.getArtifactId(), mvnProject.getVersion());
            }
            this.installArtifact(mvnProject.getFile(), pomArtifact, testRepository);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to install POM: " + mvnProject, e);
        }
    }

    private void installProjectDependencies(MavenProject mvnProject, Collection reactorProjects, ArtifactRepository testRepository) throws MojoExecutionException {
        Artifact artifact;
        HashMap<String, MavenProject> projects = new HashMap<String, MavenProject>();
        Iterator it = reactorProjects.iterator();
        while (it.hasNext()) {
            MavenProject reactorProject = (MavenProject)it.next();
            String projectId = reactorProject.getGroupId() + ':' + reactorProject.getArtifactId() + ':' + reactorProject.getVersion();
            projects.put(projectId, reactorProject);
        }
        Set artifacts = mvnProject.getArtifacts();
        LinkedHashSet<String> dependencyProjects = new LinkedHashSet<String>();
        LinkedHashSet<Artifact> dependencyArtifacts = new LinkedHashSet<Artifact>();
        Iterator it2 = artifacts.iterator();
        while (it2.hasNext()) {
            artifact = (Artifact)it2.next();
            artifact.isSnapshot();
            String projectId = artifact.getGroupId() + ':' + artifact.getArtifactId() + ':' + artifact.getBaseVersion();
            if (projects.containsKey(projectId)) {
                dependencyProjects.add(projectId);
                continue;
            }
            dependencyArtifacts.add(artifact);
        }
        try {
            it2 = dependencyArtifacts.iterator();
            while (it2.hasNext()) {
                artifact = (Artifact)it2.next();
                Artifact depArtifact = this.artifactFactory.createArtifactWithClassifier(artifact.getGroupId(), artifact.getArtifactId(), artifact.getBaseVersion(), artifact.getType(), artifact.getClassifier());
                File artifactFile = artifact.getFile();
                Artifact pomArtifact = this.artifactFactory.createProjectArtifact(depArtifact.getGroupId(), depArtifact.getArtifactId(), depArtifact.getBaseVersion());
                File pomFile = new File(this.localRepository.getBasedir(), this.localRepository.pathOf(pomArtifact));
                if (pomFile.isFile()) {
                    if (!pomArtifact.getId().equals(depArtifact.getId())) {
                        this.copyArtifact(pomFile, pomArtifact, testRepository);
                    }
                    this.copyParentPoms(pomFile, testRepository);
                }
                this.copyArtifact(artifactFile, depArtifact, testRepository);
            }
            it2 = dependencyProjects.iterator();
            while (it2.hasNext()) {
                String projectId = (String)it2.next();
                MavenProject dependencyProject = (MavenProject)projects.get(projectId);
                this.installProjectArtifacts(dependencyProject, testRepository);
                this.installProjectParents(dependencyProject, testRepository);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to install project dependencies: " + mvnProject, e);
        }
    }

    private void copyParentPoms(File pomFile, ArtifactRepository testRepository) throws MojoExecutionException {
        Model model = PomUtils.loadPom(pomFile);
        Parent parent = model.getParent();
        if (parent != null) {
            this.copyParentPoms(parent.getGroupId(), parent.getArtifactId(), parent.getVersion(), testRepository);
        }
    }

    private void copyParentPoms(String groupId, String artifactId, String version, ArtifactRepository testRepository) throws MojoExecutionException {
        Artifact pomArtifact = this.artifactFactory.createProjectArtifact(groupId, artifactId, version);
        if (this.installedArtifacts.contains(pomArtifact.getId()) || this.copiedArtifacts.contains(pomArtifact.getId())) {
            this.getLog().debug((CharSequence)("Not re-installing " + pomArtifact));
            return;
        }
        File pomFile = new File(this.localRepository.getBasedir(), this.localRepository.pathOf(pomArtifact));
        if (pomFile.isFile()) {
            this.copyArtifact(pomFile, pomArtifact, testRepository);
            this.copyParentPoms(pomFile, testRepository);
        }
    }
}

